/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.gettersetter;

import java.util.LinkedList;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.InstrumenterLogger;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.asm.CloneMap;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.FieldMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.instrumentation.metadata.MethodMetadata;
import org.multiverse.repackaged.org.objectweb.asm.Opcodes;
import org.multiverse.repackaged.org.objectweb.asm.tree.AbstractInsnNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.ClassNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.FieldInsnNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.InsnList;
import org.multiverse.repackaged.org.objectweb.asm.tree.MethodInsnNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.MethodNode;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class GetterSetterInlineTransformer
implements Opcodes {
    private final ClassNode originalClassNode;
    private final ClassMetadata classMetadata;
    private final MetadataRepository metadataRepository;
    private final ClassLoader classLoader;
    private final InstrumenterLogger logger;

    public GetterSetterInlineTransformer(ClassNode originalClassNode, ClassMetadata classMetadata, MetadataRepository metadataRepository, ClassLoader classLoader, InstrumenterLogger logger) {
        this.classLoader = classLoader;
        this.originalClassNode = originalClassNode;
        this.classMetadata = classMetadata;
        this.metadataRepository = metadataRepository;
        this.logger = logger;
    }

    public ClassNode transform() {
        LinkedList<MethodNode> newMethods = new LinkedList<MethodNode>();
        for (MethodNode originalMethodNode : this.originalClassNode.methods) {
            MethodNode transformed = this.transform(originalMethodNode);
            newMethods.add(transformed);
        }
        this.originalClassNode.methods = newMethods;
        return this.originalClassNode;
    }

    private MethodNode transform(MethodNode originalMethodNode) {
        MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(originalMethodNode.name, originalMethodNode.desc);
        if (this.skipMethod(methodMetadata)) {
            return originalMethodNode;
        }
        CloneMap cloneMap = new CloneMap();
        MethodNode result = AsmUtils.cloneMethodWithoutInstructions(originalMethodNode, cloneMap);
        InsnList newInstructions = new InsnList();
        block3: for (int k = 0; k < originalMethodNode.instructions.size(); ++k) {
            AbstractInsnNode originalInsn = originalMethodNode.instructions.get(k);
            switch (originalInsn.getOpcode()) {
                case 182: 
                case 183: {
                    AbstractInsnNode fixedInsn = this.optimizeInvoke((MethodInsnNode)originalInsn, cloneMap);
                    newInstructions.add(fixedInsn);
                    continue block3;
                }
                default: {
                    newInstructions.add(originalInsn.clone(cloneMap));
                }
            }
        }
        result.instructions = newInstructions;
        return result;
    }

    private AbstractInsnNode optimizeInvoke(MethodInsnNode methodInsnNode, CloneMap cloneMap) {
        FieldMetadata fieldMetadata;
        ClassMetadata ownerMetadata = this.metadataRepository.loadClassMetadata(this.classLoader, methodInsnNode.owner);
        MethodMetadata calleeMetadata = ownerMetadata.getMethodMetadata(methodInsnNode.name, methodInsnNode.desc);
        boolean implementationKnown = this.classMetadata.isFinal() || methodInsnNode.getOpcode() == 183;
        FieldMetadata fieldMetadata2 = fieldMetadata = calleeMetadata == null ? null : calleeMetadata.getGetterSetterField();
        if (!(ownerMetadata.isTransactionalObject() && calleeMetadata != null && implementationKnown && fieldMetadata != null && fieldMetadata.isManagedField())) {
            return methodInsnNode.clone(cloneMap);
        }
        switch (calleeMetadata.getMethodType()) {
            case getter: {
                return new FieldInsnNode(180, ownerMetadata.getName(), fieldMetadata.getName(), fieldMetadata.getDesc());
            }
            case setter: {
                return new FieldInsnNode(181, ownerMetadata.getName(), fieldMetadata.getName(), fieldMetadata.getDesc());
            }
            case unknown: {
                return methodInsnNode;
            }
        }
        throw new IllegalStateException();
    }

    private boolean skipMethod(MethodMetadata methodMetadata) {
        return methodMetadata.isAbstract() || methodMetadata.isNative() || !methodMetadata.isTransactional();
    }
}

