/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.Component;
import org.apache.camel.Producer;
import org.apache.camel.component.log.LogProducer;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.processor.CamelLogger;
import org.apache.camel.util.ServiceHelper;

public class LogEndpoint
extends ProcessorEndpoint {
    private CamelLogger logger;

    public LogEndpoint() {
    }

    public LogEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public LogEndpoint(String endpointUri, Component component, CamelLogger logger) {
        super(endpointUri, component);
        this.setLogger(logger);
    }

    public CamelLogger getLogger() {
        return this.logger;
    }

    @Override
    public void start() throws Exception {
        ServiceHelper.startService(this.logger);
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopService(this.logger);
    }

    public void setLogger(CamelLogger logger) {
        this.logger = logger;
        this.setProcessor(this.logger);
    }

    @Override
    public Producer createProducer() throws Exception {
        return new LogProducer(this, this.getLogger());
    }

    @Override
    protected String createEndpointUri() {
        return "log:" + this.logger.toString();
    }
}

