/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.util.AsyncProcessorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SedaConsumer
extends ServiceSupport
implements Consumer,
Runnable,
ShutdownAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(SedaConsumer.class);
    private CountDownLatch latch;
    private volatile boolean shutdownPending;
    private SedaEndpoint endpoint;
    private AsyncProcessor processor;
    private ExecutorService executor;
    private ExceptionHandler exceptionHandler;

    public SedaConsumer(SedaEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = AsyncProcessorTypeConverter.convert(processor);
    }

    public String toString() {
        return "SedaConsumer[" + this.endpoint.getEndpointUri() + "]";
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    @Override
    public int getPendingExchangesSize() {
        return this.endpoint.getQueue().size();
    }

    @Override
    public void prepareShutdown() {
        this.shutdownPending = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preparing to shutdown, waiting for " + this.latch.getCount() + " consumer threads to complete.");
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        BlockingQueue<Exchange> queue = this.endpoint.getQueue();
        while (queue != null && this.isRunAllowed()) {
            Exchange exchange = null;
            try {
                exchange = queue.poll(1000L, TimeUnit.MILLISECONDS);
                if (exchange != null) {
                    try {
                        this.sendToConsumers(exchange);
                        if (exchange.getException() == null) continue;
                        this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
                    }
                    catch (Exception e) {
                        this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
                    }
                    continue;
                }
                if (!this.shutdownPending || !queue.isEmpty()) continue;
                if (!LOG.isTraceEnabled()) break;
                LOG.trace("Shutdown is pending, so this consumer thread is breaking out because the task queue is empty.");
                break;
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Sleep interrupted, are we stopping? " + (this.isStopping() || this.isStopped()));
            }
            catch (Throwable e) {
                if (exchange != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
                    continue;
                }
                this.getExceptionHandler().handleException(e);
            }
        }
        this.latch.countDown();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ending this polling consumer thread, there are still " + this.latch.getCount() + " consumer threads left.");
        }
    }

    protected void sendToConsumers(Exchange exchange) throws Exception {
        int size = this.endpoint.getConsumers().size();
        if (size > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Multicasting to " + this.endpoint.getConsumers().size() + " consumers for Exchange: " + exchange);
            }
            MulticastProcessor mp = this.endpoint.getConsumerMulticastProcessor();
            AsyncProcessorHelper.process(mp, exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                }
            });
        } else {
            AsyncProcessorHelper.process(this.processor, exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                }
            });
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.latch = new CountDownLatch(this.endpoint.getConcurrentConsumers());
        this.shutdownPending = false;
        int poolSize = this.endpoint.getConcurrentConsumers();
        this.executor = this.endpoint.getCamelContext().getExecutorServiceStrategy().newFixedThreadPool(this, this.endpoint.getEndpointUri(), poolSize);
        for (int i = 0; i < poolSize; ++i) {
            this.executor.execute(this);
        }
        this.endpoint.onStarted(this);
    }

    @Override
    protected void doStop() throws Exception {
        this.endpoint.onStopped(this);
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceStrategy().shutdownNow(this.executor);
            this.executor = null;
        }
    }
}

