/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollEnricher
extends ServiceSupport
implements Processor {
    private static final transient Logger LOG = LoggerFactory.getLogger(PollEnricher.class);
    private AggregationStrategy aggregationStrategy;
    private PollingConsumer consumer;
    private long timeout;

    public PollEnricher(PollingConsumer consumer) {
        this(PollEnricher.defaultAggregationStrategy(), consumer, 0L);
    }

    public PollEnricher(AggregationStrategy aggregationStrategy, PollingConsumer consumer, long timeout) {
        this.aggregationStrategy = aggregationStrategy;
        this.consumer = consumer;
        this.timeout = timeout;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public void setDefaultAggregationStrategy() {
        this.aggregationStrategy = PollEnricher.defaultAggregationStrategy();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Exchange resourceExchange;
        this.preCheckPoll(exchange);
        if (this.timeout < 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Consumer receive: " + this.consumer);
            }
            resourceExchange = this.consumer.receive();
        } else if (this.timeout == 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Consumer receiveNoWait: " + this.consumer);
            }
            resourceExchange = this.consumer.receiveNoWait();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Consumer receive with timeout: " + this.timeout + " ms. " + this.consumer);
            }
            resourceExchange = this.consumer.receive(this.timeout);
        }
        if (LOG.isDebugEnabled()) {
            if (resourceExchange == null) {
                LOG.debug("Consumer received no exchange");
            } else {
                LOG.debug("Consumer received: " + resourceExchange);
            }
        }
        if (resourceExchange != null && resourceExchange.isFailed()) {
            ExchangeHelper.copyResultsPreservePattern(exchange, resourceExchange);
        } else {
            PollEnricher.prepareResult(exchange);
            ExchangeHelper.prepareAggregation(exchange, resourceExchange);
            Exchange aggregatedExchange = this.aggregationStrategy.aggregate(exchange, resourceExchange);
            if (aggregatedExchange != null) {
                ExchangeHelper.copyResultsPreservePattern(exchange, aggregatedExchange);
                if (resourceExchange != null) {
                    resourceExchange.handoverCompletions(exchange);
                }
            }
        }
    }

    protected void preCheckPoll(Exchange exchange) throws Exception {
    }

    private static void prepareResult(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
        }
    }

    private static AggregationStrategy defaultAggregationStrategy() {
        return new CopyAggregationStrategy();
    }

    public String toString() {
        return "PollEnrich[" + this.consumer + "]";
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.consumer);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.consumer);
    }

    private static class CopyAggregationStrategy
    implements AggregationStrategy {
        private CopyAggregationStrategy() {
        }

        @Override
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange != null) {
                ExchangeHelper.copyResultsPreservePattern(oldExchange, newExchange);
            }
            return oldExchange;
        }
    }
}

