/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ValueBuilder;

public final class Builder {
    private Builder() {
    }

    public static ValueBuilder bean(Object beanOrBeanRef) {
        return Builder.bean(beanOrBeanRef, null);
    }

    public static ValueBuilder bean(Object beanOrBeanRef, String method) {
        Expression expression = beanOrBeanRef instanceof String ? ExpressionBuilder.beanExpression((String)beanOrBeanRef, method) : ExpressionBuilder.beanExpression(beanOrBeanRef, method);
        return new ValueBuilder(expression);
    }

    public static ValueBuilder bean(Class<?> beanType, String method) {
        Expression expression = ExpressionBuilder.beanExpression(beanType, method);
        return new ValueBuilder(expression);
    }

    public static ValueBuilder constant(Object value) {
        Expression expression = ExpressionBuilder.constantExpression(value);
        return new ValueBuilder(expression);
    }

    public static ValueBuilder simple(String value) {
        Expression expression = ExpressionBuilder.simpleExpression(value);
        return new ValueBuilder(expression);
    }

    public static ValueBuilder header(String name) {
        Expression expression = ExpressionBuilder.headerExpression(name);
        return new ValueBuilder(expression);
    }

    public static ValueBuilder property(String name) {
        Expression expression = ExpressionBuilder.propertyExpression(name);
        return new ValueBuilder(expression);
    }

    public static ValueBuilder body() {
        Expression expression = ExpressionBuilder.bodyExpression();
        return new ValueBuilder(expression);
    }

    public static <T> ValueBuilder bodyAs(Class<T> type) {
        Expression expression = ExpressionBuilder.bodyExpression(type);
        return new ValueBuilder(expression);
    }

    public static ValueBuilder outBody() {
        Expression expression = ExpressionBuilder.outBodyExpression();
        return new ValueBuilder(expression);
    }

    public static <T> ValueBuilder outBodyAs(Class<T> type) {
        Expression expression = ExpressionBuilder.outBodyExpression(type);
        return new ValueBuilder(expression);
    }

    public static ValueBuilder faultBody() {
        Expression expression = ExpressionBuilder.faultBodyExpression();
        return new ValueBuilder(expression);
    }

    public static <T> ValueBuilder faultBodyAs(Class<T> type) {
        Expression expression = ExpressionBuilder.faultBodyExpression(type);
        return new ValueBuilder(expression);
    }

    public static ValueBuilder systemProperty(String name) {
        return Builder.systemProperty(name, null);
    }

    public static ValueBuilder systemProperty(String name, String defaultValue) {
        return new ValueBuilder(ExpressionBuilder.systemPropertyExpression(name, defaultValue));
    }

    public static ValueBuilder exceptionMessage() {
        Expression expression = ExpressionBuilder.exchangeExceptionMessageExpression();
        return new ValueBuilder(expression);
    }

    public static ValueBuilder exceptionStackTrace() {
        Expression expression = ExpressionBuilder.exchangeExceptionStackTraceExpression();
        return new ValueBuilder(expression);
    }

    public static ValueBuilder regexReplaceAll(Expression content, String regex, String replacement) {
        Expression newExp = ExpressionBuilder.regexReplaceAll(content, regex, replacement);
        return new ValueBuilder(newExp);
    }

    public static ValueBuilder regexReplaceAll(Expression content, String regex, Expression replacement) {
        Expression newExp = ExpressionBuilder.regexReplaceAll(content, regex, replacement);
        return new ValueBuilder(newExp);
    }

    public static ValueBuilder sendTo(String uri) {
        Expression expression = ExpressionBuilder.toExpression(uri);
        return new ValueBuilder(expression);
    }
}

