/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerFileExclusiveReadLockStrategy
implements GenericFileExclusiveReadLockStrategy<File> {
    private static final transient Logger LOG = LoggerFactory.getLogger(MarkerFileExclusiveReadLockStrategy.class);
    private File lock;
    private String lockFileName;

    @Override
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) {
        String dir = endpoint.getConfiguration().getDirectory();
        File file = new File(dir);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Prepare on startup by deleting orphaned lock files from: " + dir);
        }
        MarkerFileExclusiveReadLockStrategy.deleteLockFiles(file, endpoint.isRecursive());
    }

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        this.lockFileName = file.getAbsoluteFilePath() + ".camelLock";
        if (LOG.isTraceEnabled()) {
            LOG.trace("Locking the file: " + file + " using the lock file name: " + this.lockFileName);
        }
        this.lock = new File(this.lockFileName);
        boolean acquired = this.lock.createNewFile();
        if (!acquired) {
            this.lock = null;
        }
        return acquired;
    }

    @Override
    public void releaseExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        if (this.lock != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Unlocking file: " + this.lockFileName);
            }
            boolean deleted = FileUtil.deleteFile(this.lock);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Lock file: " + this.lockFileName + " was deleted: " + deleted);
            }
        }
    }

    @Override
    public void setTimeout(long timeout) {
    }

    @Override
    public void setCheckInterval(long checkInterval) {
    }

    private static void deleteLockFiles(File dir, boolean recursive) {
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.getName().startsWith(".")) continue;
            if (file.getName().endsWith(".camelLock")) {
                LOG.warn("Deleting orphaned lock file: " + file);
                FileUtil.deleteFile(file);
                continue;
            }
            if (!recursive || !file.isDirectory()) continue;
            MarkerFileExclusiveReadLockStrategy.deleteLockFiles(file, true);
        }
    }
}

