/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.InflightRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInflightRepository
extends ServiceSupport
implements InflightRepository {
    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultInflightRepository.class);
    private final AtomicInteger totalCount = new AtomicInteger();
    private final ConcurrentHashMap<String, AtomicInteger> endpointCount = new ConcurrentHashMap();

    @Override
    public void add(Exchange exchange) {
        int count = this.totalCount.incrementAndGet();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Total " + count + " inflight exchanges. Last added: " + exchange.getExchangeId());
        }
        if (exchange.getFromEndpoint() == null) {
            return;
        }
        String key = exchange.getFromEndpoint().getEndpointKey();
        AtomicInteger existing = this.endpointCount.putIfAbsent(key, new AtomicInteger(1));
        if (existing != null) {
            existing.addAndGet(1);
        }
    }

    @Override
    public void remove(Exchange exchange) {
        int count = this.totalCount.decrementAndGet();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Total " + count + " inflight exchanges. Last removed: " + exchange.getExchangeId());
        }
        if (exchange.getFromEndpoint() == null) {
            return;
        }
        String key = exchange.getFromEndpoint().getEndpointKey();
        AtomicInteger existing = this.endpointCount.get(key);
        if (existing != null) {
            existing.addAndGet(-1);
        }
    }

    @Override
    public int size() {
        return this.totalCount.get();
    }

    @Override
    public int size(Endpoint endpoint) {
        AtomicInteger answer = this.endpointCount.get(endpoint.getEndpointKey());
        return answer != null ? answer.get() : 0;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        int count = this.size();
        if (count > 0) {
            LOG.warn("Shutting down while there are still " + count + " in flight exchanges.");
        } else {
            LOG.info("Shutting down with no inflight exchanges.");
        }
        this.endpointCount.clear();
    }
}

