/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.DefaultTracedRouteNodes;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationVetoable;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.UnitOfWorkHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUnitOfWork
implements UnitOfWork,
Service {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private String id;
    private CamelContext context;
    private List<Synchronization> synchronizations;
    private Message originalInMessage;
    private final TracedRouteNodes tracedRouteNodes;
    private Set<Object> transactedBy;
    private final Stack<RouteContext> routeContextStack = new Stack();

    public DefaultUnitOfWork(Exchange exchange) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork created for ExchangeId: " + exchange.getExchangeId() + " with " + exchange);
        }
        this.tracedRouteNodes = new DefaultTracedRouteNodes();
        this.context = exchange.getContext();
        if (exchange.getIn().getClass().getSimpleName().equals("JmsMessage")) {
            this.originalInMessage = new DefaultMessage();
            this.originalInMessage.setBody(exchange.getIn().getBody());
        } else {
            this.originalInMessage = exchange.getIn().copy();
        }
        if (exchange.getProperty("CamelCreatedTimestamp") == null) {
            exchange.setProperty("CamelCreatedTimestamp", new Date());
        }
        EventHelper.notifyExchangeCreated(exchange.getContext(), exchange);
        if (exchange.getContext() != null) {
            exchange.getContext().getInflightRepository().add(exchange);
        }
    }

    @Override
    public void start() throws Exception {
        this.id = null;
    }

    @Override
    public void stop() throws Exception {
        if (this.synchronizations != null) {
            this.synchronizations.clear();
        }
        if (this.tracedRouteNodes != null) {
            this.tracedRouteNodes.clear();
        }
        if (this.transactedBy != null) {
            this.transactedBy.clear();
        }
        this.originalInMessage = null;
        if (!this.routeContextStack.isEmpty()) {
            this.routeContextStack.clear();
        }
    }

    @Override
    public synchronized void addSynchronization(Synchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<Synchronization>();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Adding synchronization " + synchronization);
        }
        this.synchronizations.add(synchronization);
    }

    @Override
    public synchronized void removeSynchronization(Synchronization synchronization) {
        if (this.synchronizations != null) {
            this.synchronizations.remove(synchronization);
        }
    }

    @Override
    public void handoverSynchronization(Exchange target) {
        if (this.synchronizations == null || this.synchronizations.isEmpty()) {
            return;
        }
        Iterator<Synchronization> it = this.synchronizations.iterator();
        while (it.hasNext()) {
            Synchronization synchronization = it.next();
            boolean handover = true;
            if (synchronization instanceof SynchronizationVetoable) {
                SynchronizationVetoable veto = (SynchronizationVetoable)synchronization;
                handover = veto.allowHandover();
            }
            if (handover) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Handover synchronization " + synchronization + " to: " + target);
                }
                target.addOnCompletion(synchronization);
                it.remove();
                continue;
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("Handover not allow for synchronization " + synchronization);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done(Exchange exchange) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork done for ExchangeId: " + exchange.getExchangeId() + " with " + exchange);
        }
        boolean failed = exchange.isFailed();
        UnitOfWorkHelper.doneSynchronizations(exchange, this.synchronizations, this.log);
        try {
            if (failed) {
                EventHelper.notifyExchangeFailed(exchange.getContext(), exchange);
            } else {
                EventHelper.notifyExchangeDone(exchange.getContext(), exchange);
            }
        }
        catch (Throwable e) {
            this.log.warn("Exception occurred during event notification. This exception will be ignored.", e);
        }
        finally {
            if (exchange.getContext() != null) {
                exchange.getContext().getInflightRepository().remove(exchange);
            }
        }
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.context.getUuidGenerator().generateUuid();
        }
        return this.id;
    }

    @Override
    public Message getOriginalInMessage() {
        return this.originalInMessage;
    }

    @Override
    public TracedRouteNodes getTracedRouteNodes() {
        return this.tracedRouteNodes;
    }

    @Override
    public boolean isTransacted() {
        return this.transactedBy != null && !this.transactedBy.isEmpty();
    }

    @Override
    public boolean isTransactedBy(Object key) {
        return this.getTransactedBy().contains(key);
    }

    @Override
    public void beginTransactedBy(Object key) {
        this.getTransactedBy().add(key);
    }

    @Override
    public void endTransactedBy(Object key) {
        this.getTransactedBy().remove(key);
    }

    @Override
    public RouteContext getRouteContext() {
        if (this.routeContextStack.isEmpty()) {
            return null;
        }
        return this.routeContextStack.peek();
    }

    @Override
    public void pushRouteContext(RouteContext routeContext) {
        this.routeContextStack.add(routeContext);
    }

    @Override
    public RouteContext popRouteContext() {
        if (this.routeContextStack.isEmpty()) {
            return null;
        }
        return this.routeContextStack.pop();
    }

    @Override
    public AsyncCallback beforeProcess(Processor processor, Exchange exchange, AsyncCallback callback) {
        return callback;
    }

    @Override
    public void afterProcess(Processor processor, Exchange exchange, AsyncCallback callback, boolean doneSync) {
    }

    private Set<Object> getTransactedBy() {
        if (this.transactedBy == null) {
            this.transactedBy = new LinkedHashSet<Object>();
        }
        return this.transactedBy;
    }

    public String toString() {
        return "DefaultUnitOfWork";
    }
}

