/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="jaxb")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JaxbDataFormat
extends DataFormatDefinition {
    @XmlAttribute(required=true)
    private String contextPath;
    @XmlAttribute
    private Boolean prettyPrint;
    @XmlAttribute
    private Boolean ignoreJAXBElement;
    @XmlAttribute
    private Boolean filterNonXmlChars;
    @XmlAttribute
    private String encoding;
    @XmlAttribute
    private String partClass;
    @XmlAttribute
    private String partNamespace;

    public JaxbDataFormat() {
        super("jaxb");
    }

    public JaxbDataFormat(boolean prettyPrint) {
        this();
        this.setPrettyPrint(prettyPrint);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Boolean getIgnoreJAXBElement() {
        return this.ignoreJAXBElement;
    }

    public void setIgnoreJAXBElement(Boolean ignoreJAXBElement) {
        this.ignoreJAXBElement = ignoreJAXBElement;
    }

    public Boolean getFilterNonXmlChars() {
        return this.filterNonXmlChars;
    }

    public void setFilterNonXmlChars(Boolean filterNonXmlChars) {
        this.filterNonXmlChars = filterNonXmlChars;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getPartClass() {
        return this.partClass;
    }

    public void setPartClass(String partClass) {
        this.partClass = partClass;
    }

    public String getPartNamespace() {
        return this.partNamespace;
    }

    public void setPartNamespace(String partNamespace) {
        this.partNamespace = partNamespace;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat) {
        Boolean answer = ObjectHelper.toBoolean(this.getPrettyPrint());
        if (answer != null && !answer.booleanValue()) {
            this.setProperty(dataFormat, "prettyPrint", Boolean.FALSE);
        } else {
            this.setProperty(dataFormat, "prettyPrint", Boolean.TRUE);
        }
        answer = ObjectHelper.toBoolean(this.getIgnoreJAXBElement());
        if (answer != null && !answer.booleanValue()) {
            this.setProperty(dataFormat, "ignoreJAXBElement", Boolean.FALSE);
        } else {
            this.setProperty(dataFormat, "ignoreJAXBElement", Boolean.TRUE);
        }
        answer = ObjectHelper.toBoolean(this.getFilterNonXmlChars());
        if (answer != null && answer.booleanValue()) {
            this.setProperty(dataFormat, "filterNonXmlChars", Boolean.TRUE);
        } else {
            this.setProperty(dataFormat, "filterNonXmlChars", Boolean.FALSE);
        }
        if (this.partClass != null) {
            this.setProperty(dataFormat, "partClass", this.partClass);
        }
        if (this.partNamespace != null) {
            this.setProperty(dataFormat, "partNamespace", QName.valueOf(this.partNamespace));
        }
        if (this.encoding != null) {
            this.setProperty(dataFormat, "encoding", this.encoding);
        }
        this.setProperty(dataFormat, "contextPath", this.contextPath);
    }
}

