/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.OrderedComparator;
import org.slf4j.Logger;

public final class UnitOfWorkHelper {
    private UnitOfWorkHelper() {
    }

    public static void doneSynchronizations(Exchange exchange, List<Synchronization> synchronizations, Logger log) {
        boolean failed = exchange.isFailed();
        if (synchronizations != null && !synchronizations.isEmpty()) {
            ArrayList<Synchronization> copy = new ArrayList<Synchronization>(synchronizations);
            Collections.reverse(copy);
            Collections.sort(copy, new OrderedComparator());
            for (Synchronization synchronization : copy) {
                try {
                    if (failed) {
                        if (log.isTraceEnabled()) {
                            log.trace("Invoking synchronization.onFailure: " + synchronization + " with " + exchange);
                        }
                        synchronization.onFailure(exchange);
                        continue;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Invoking synchronization.onComplete: " + synchronization + " with " + exchange);
                    }
                    synchronization.onComplete(exchange);
                }
                catch (Throwable e) {
                    log.warn("Exception occurred during onCompletion. This exception will be ignored.", e);
                }
            }
        }
    }
}

