/*
 * Decompiled with CFR 0.152.
 */
package play.modules.camel;

import akka.camel.CamelContextManager;
import akka.camel.CamelServiceManager;
import com.google.gson.JsonObject;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.hazelcast.HazelcastComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.springframework.jms.core.JmsTemplate;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.inject.BeanSource;
import play.modules.camel.Injector;
import play.mvc.Http;
import play.mvc.Router;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelPlugin
extends PlayPlugin
implements BeanSource {
    private static DefaultCamelContext ctx;
    private static BrokerService broker;

    public void onApplicationStart() {
        try {
            if (broker == null && Play.configuration.containsKey("broker.connector")) {
                Logger.info((String)"Starting Broker Service...", (Object[])new Object[0]);
                broker = new BrokerService();
                broker.setAdvisorySupport(false);
                broker.setUseJmx(true);
                broker.setBrokerName("play-activemq");
                broker.addConnector(Play.configuration.getProperty("broker.connector", "nio://localhost:61616"));
                broker.setEnableStatistics(true);
                broker.start();
                Logger.info((String)"Starting Broker Service...OK", (Object[])new Object[0]);
            }
            if (ctx == null) {
                Logger.info((String)"Starting Camel Service...", (Object[])new Object[0]);
                ctx = new DefaultCamelContext();
                ctx.setName("play-camel");
                Logger.info((String)"Starting ActiveMQComponent...", (Object[])new Object[0]);
                ActiveMQComponent amqc = new ActiveMQComponent((CamelContext)ctx);
                String brokerURL = Play.configuration.getProperty("broker.url", "vm://localhost");
                amqc.setBrokerURL(brokerURL);
                amqc.setUsePooledConnection(true);
                amqc.setMessageIdEnabled(true);
                amqc.setMessageTimestampEnabled(true);
                amqc.setTestConnectionOnStartup(true);
                amqc.setTransacted(true);
                amqc.setAutoStartup(true);
                amqc.start();
                ctx.addComponent("activemq", (Component)amqc);
                Logger.info((String)"Starting ActiveMQComponent...OK", (Object[])new Object[0]);
                Logger.info((String)"Starting HazelcastComponent...", (Object[])new Object[0]);
                HazelcastComponent hazel = new HazelcastComponent((CamelContext)ctx);
                hazel.start();
                ctx.addComponent("hazelcast", (Component)hazel);
                Logger.info((String)"Starting HazelcastComponent...OK", (Object[])new Object[0]);
                ctx.start();
                Logger.info((String)"Starting Camel Service...OK", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            Logger.info((String)"Starting Camel Service...KO", (Object[])new Object[0]);
            throw new ExceptionInInitializerError(e);
        }
        try {
            Logger.info((String)"Starting AKKA Camel Service...", (Object[])new Object[0]);
            CamelContextManager.init((CamelContext)ctx);
            CamelContextManager.start();
            CamelServiceManager.startCamelService();
            Logger.info((String)"Starting AKKA Camel Service is...OK", (Object[])new Object[0]);
        }
        catch (Exception e) {
            Logger.info((String)"Starting AKKA Camel Service is...KO", (Object[])new Object[0]);
            throw new ExceptionInInitializerError(e);
        }
        Injector.inject(this);
    }

    public void onApplicationStop() {
        Logger.info((String)"Stopping Camel Services...", (Object[])new Object[0]);
        try {
            CamelServiceManager.stopCamelService();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (CamelContextManager.started()) {
                CamelContextManager.stop();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            broker.stop();
            while (broker.isStarted()) {
                Thread.sleep(1000L);
            }
            broker = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ctx.shutdown();
            while (!ctx.isStopped()) {
                Thread.sleep(100L);
            }
            ctx = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.info((String)"Stopping Camel Services...OK", (Object[])new Object[0]);
    }

    public <T> T getBeanOfType(Class<T> clazz) {
        if (clazz.equals(CamelContext.class)) {
            Logger.info((String)"%s Injection...OK", (Object[])new Object[]{clazz.getName()});
            return (T)ctx;
        }
        if (clazz.equals(JmsTemplate.class)) {
            Logger.info((String)"%s Injection...OK", (Object[])new Object[]{clazz.getName()});
            return (T)CamelPlugin.getJmsTemplate();
        }
        return null;
    }

    private static ActiveMQComponent getActiveMQComponent() {
        return (ActiveMQComponent)ctx.getComponent("activemq", ActiveMQComponent.class);
    }

    public boolean rawInvocation(Http.Request request, Http.Response response) throws Exception {
        if ("/@camel".equals(request.path)) {
            response.status = 302;
            response.setHeader("Location", "/@camel/");
            return true;
        }
        return false;
    }

    public void onRoutesLoaded() {
        Router.prependRoute((String)"GET", (String)"/@camel/?", (String)"camel.CamelApplication.index");
    }

    public static CamelContext getCamelContext() {
        return ctx;
    }

    public static BrokerService getBroker() {
        return broker;
    }

    public static JmsTemplate getJmsTemplate() {
        return new JmsTemplate(CamelPlugin.getActiveMQComponent().getConfiguration().getConnectionFactory());
    }

    public String getStatus() {
        return "Camel Status: " + ctx.getStatus().toString();
    }

    public JsonObject getJsonStatus() {
        JsonObject o = new JsonObject();
        o.addProperty("started", ctx.getStatus().toString());
        return o;
    }
}

