/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api.backoff;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.multiverse.api.Transaction;
import org.multiverse.api.backoff.BackoffPolicy;
import org.multiverse.instrumentation.InstrumentationStamp;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class ExponentialBackoffPolicy
implements BackoffPolicy {
    public static final ExponentialBackoffPolicy INSTANCE_100_MS_MAX = new ExponentialBackoffPolicy();
    private final long maxDelayNs;
    private final long minDelayNs;
    private final long[] slotTimes;

    public ExponentialBackoffPolicy() {
        this(100L, TimeUnit.MILLISECONDS.toNanos(100L), TimeUnit.NANOSECONDS);
    }

    public ExponentialBackoffPolicy(long minDelayNs, long maxDelay, TimeUnit unit) {
        this.maxDelayNs = unit.toNanos(maxDelay);
        this.minDelayNs = minDelayNs;
        if (minDelayNs > this.maxDelayNs) {
            throw new IllegalArgumentException("minimum delay can't be larger than maximum delay");
        }
        this.slotTimes = new long[1000];
        for (int k = 0; k < this.slotTimes.length; ++k) {
            this.slotTimes[k] = Math.round(1.0 * (double)k / (double)this.slotTimes.length * (double)this.maxDelayNs);
        }
    }

    public long getMaxDelayNs() {
        return this.maxDelayNs;
    }

    public long getMinDelayNs() {
        return this.minDelayNs;
    }

    @Override
    public void delay(Transaction t) throws InterruptedException {
        this.delayedUninterruptible(t);
    }

    @Override
    public void delayedUninterruptible(Transaction t) {
        long delayNs = this.calcDelayNs(t);
        long remainingTimeoutNs = t.getRemainingTimeoutNs();
        if (remainingTimeoutNs == Long.MAX_VALUE) {
            if (delayNs > 1000L) {
                LockSupport.parkNanos(delayNs);
            }
        } else {
            if (delayNs > remainingTimeoutNs) {
                delayNs = remainingTimeoutNs;
            }
            long startNs = System.nanoTime();
            LockSupport.parkNanos(delayNs);
            long durationNs = System.nanoTime() - startNs;
            t.setRemainingTimeoutNs(Math.min(0L, remainingTimeoutNs - durationNs));
        }
    }

    protected long calcDelayNs(Transaction tx) {
        int attempt = tx.getAttempt();
        int maxSlot = attempt >= this.slotTimes.length ? this.slotTimes.length - 1 : attempt;
        if (maxSlot <= 0) {
            maxSlot = 1;
        }
        int slotIndex = Math.abs(System.identityHashCode(Thread.currentThread()) % maxSlot);
        long delayNs = this.slotTimes[slotIndex];
        if (this.minDelayNs > 0L && delayNs < this.minDelayNs) {
            delayNs = this.minDelayNs;
        }
        if (this.maxDelayNs > 0L && delayNs > this.maxDelayNs) {
            delayNs = this.maxDelayNs;
        }
        return delayNs;
    }
}

