/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.javaagent;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.multiverse.instrumentation.InstrumentationStamp;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class JavaAgentProblemMonitor {
    private static final Logger logger = Logger.getLogger(JavaAgentProblemMonitor.class.getName());
    public static final JavaAgentProblemMonitor INSTANCE = new JavaAgentProblemMonitor();
    private final int maxProblemListSize;
    private final int delayMs;
    private final boolean startLoggingDeamon;
    private volatile boolean problemFound;
    private volatile List<String> problemClasses = new LinkedList<String>();

    private JavaAgentProblemMonitor() {
        this.maxProblemListSize = Integer.parseInt(System.getProperty("org.multiverse.javaagent.problemmonitor.maxProblems", "10"));
        this.startLoggingDeamon = Boolean.parseBoolean(System.getProperty("org.multiverse.javaagent.problemmonitor.startLoggingDeamon", "true"));
        this.delayMs = Integer.parseInt(System.getProperty("org.multiverse.javaagent.problemmonitor.delayMs", "10000"));
    }

    public boolean isProblemFound() {
        return this.problemFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalProblem(String classname) {
        if (classname == null) {
            throw new NullPointerException();
        }
        if (this.problemFound) {
            return;
        }
        JavaAgentProblemMonitor javaAgentProblemMonitor = this;
        synchronized (javaAgentProblemMonitor) {
            if (this.problemFound) {
                return;
            }
            if (this.problemClasses.size() < this.maxProblemListSize && !this.problemClasses.contains(classname)) {
                LinkedList<String> newProblemClasses = new LinkedList<String>(this.problemClasses);
                newProblemClasses.add(classname);
                this.problemClasses = newProblemClasses;
            }
            this.problemFound = true;
            if (this.startLoggingDeamon) {
                new LoggingDaemon().start();
            }
        }
    }

    @InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
    class LoggingDaemon
    extends Thread {
        LoggingDaemon() {
            super("JavaAgentProblemMonitor-LoggingDaemon");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                StringBuffer sb = new StringBuffer("STM integrity compromised, instrumentation problems encountered. Partial instrumented classes could give unexpected results. Check the logging for the instrumentation exception(s).\n");
                sb.append(String.format("List of problem classes: (%s max)\n", JavaAgentProblemMonitor.this.maxProblemListSize));
                List c = JavaAgentProblemMonitor.this.problemClasses;
                for (String classname : c) {
                    sb.append("    ");
                    sb.append(classname);
                    sb.append("\n");
                }
                logger.severe(sb.toString());
                try {
                    Thread.sleep(JavaAgentProblemMonitor.this.delayMs);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

