/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.multiverse.instrumentation.InstrumentationStamp;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class SpeculativeConfiguration {
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicBoolean readonly = new AtomicBoolean(true);
    private final AtomicBoolean isReadTrackingEnabled = new AtomicBoolean(false);
    private final int maximumArraySize;
    private final boolean isSpeculativeReadonlyEnabled;
    private final boolean isSpeculativeNoReadTrackingEnabled;
    private final boolean isSpeculativeSizeEnabled;

    public static SpeculativeConfiguration createSpeculativeConfiguration(boolean enabled, int maximumArraySize) {
        if (enabled) {
            return new SpeculativeConfiguration(true, true, true, maximumArraySize);
        }
        return new SpeculativeConfiguration(false, false, false, maximumArraySize);
    }

    public SpeculativeConfiguration(boolean isSpeculativeOnReadonly, boolean isSpeculativeNonAutomaticReadTrackingEnabled, boolean isSpeculativeSizeEnabled, int maximumArraySize) {
        this.isSpeculativeReadonlyEnabled = isSpeculativeOnReadonly;
        this.isSpeculativeNoReadTrackingEnabled = isSpeculativeNonAutomaticReadTrackingEnabled;
        this.isSpeculativeSizeEnabled = isSpeculativeSizeEnabled;
        this.size.set(1);
        this.maximumArraySize = maximumArraySize;
    }

    public SpeculativeConfiguration(int maximumArraySize) {
        this(true, true, true, maximumArraySize);
    }

    public boolean isEnabled() {
        return this.isSpeculativeNoReadTrackingEnabled || this.isSpeculativeReadonlyEnabled || this.isSpeculativeSizeEnabled;
    }

    public boolean isSpeculativeSizeEnabled() {
        return this.isSpeculativeSizeEnabled;
    }

    public void setOptimalSize(int newValue) {
        this.size.set(newValue);
    }

    public int getOptimalSize() {
        return this.size.get();
    }

    public void signalSpeculativeSizeFailure(int failedSize) {
        int currentSize;
        if (failedSize < 0) {
            throw new IllegalArgumentException();
        }
        int newOptimalSize = failedSize == 0 ? 1 : (failedSize == 1 ? 2 : (failedSize == 2 ? 3 : failedSize + 2));
        do {
            if ((currentSize = this.size.get()) < newOptimalSize) continue;
            return;
        } while (!this.size.compareAndSet(currentSize, newOptimalSize));
    }

    public int getMaximumArraySize() {
        return this.maximumArraySize;
    }

    public void signalSpeculativeReadonlyFailure() {
        if (!this.isSpeculativeReadonlyEnabled) {
            throw new IllegalStateException();
        }
        this.readonly.set(false);
    }

    public boolean isSpeculativeReadonlyEnabled() {
        return this.isSpeculativeReadonlyEnabled;
    }

    public boolean isReadonly() {
        return this.readonly.get();
    }

    public SpeculativeConfiguration withSpeculativeReadonlyDisabled() {
        return new SpeculativeConfiguration(false, this.isSpeculativeNoReadTrackingEnabled, this.isSpeculativeSizeEnabled, this.maximumArraySize);
    }

    public boolean isSpeculativeNoReadTrackingEnabled() {
        return this.isSpeculativeNoReadTrackingEnabled;
    }

    public void signalSpeculativeReadTrackingDisabledFailure() {
        if (!this.isSpeculativeNoReadTrackingEnabled) {
            throw new IllegalStateException();
        }
        this.isReadTrackingEnabled.set(true);
    }

    public boolean isReadTrackingEnabled() {
        return this.isReadTrackingEnabled.get();
    }

    public SpeculativeConfiguration withSpeculativeNonAutomaticReadTrackingDisabled() {
        return new SpeculativeConfiguration(this.isSpeculativeReadonlyEnabled, false, this.isSpeculativeSizeEnabled, this.maximumArraySize);
    }

    public String toString() {
        return String.format("SpeculativeConfiguration(size=%s, isSpeculativeReadonlyEnabled=%s, isSpeculativeNonAutomaticReadTrackingEnabled=%s, isSpeculativeSizeEnabled=%s)", this.size.get(), this.isSpeculativeReadonlyEnabled, this.isSpeculativeNoReadTrackingEnabled, this.isSpeculativeSizeEnabled);
    }
}

