/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.latches.Latch;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.readonly.AbstractReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class MonoReadonlyAlphaTransaction
extends AbstractReadonlyAlphaTransaction {
    private AlphaTranlocal attached;

    public MonoReadonlyAlphaTransaction(ReadonlyConfiguration config) {
        super(config);
    }

    @Override
    protected void doReset() {
        this.attached = null;
    }

    @Override
    protected AlphaTranlocal findAttached(AlphaTransactionalObject txObject) {
        if (this.attached == null) {
            return null;
        }
        if (txObject != this.attached.getTransactionalObject()) {
            return null;
        }
        return this.attached;
    }

    @Override
    protected void attach(AlphaTranlocal tranlocal) {
        if (this.attached != null) {
            ((ReadonlyConfiguration)this.config).speculativeConfiguration.signalSpeculativeSizeFailure(1);
            throw SpeculativeConfigurationFailure.create();
        }
        this.attached = tranlocal;
    }

    @Override
    protected boolean dodoRegisterRetryLatch(Latch latch, long wakeupVersion) {
        if (this.attached == null) {
            return false;
        }
        AlphaTransactionalObject txObject = this.attached.getTransactionalObject();
        switch (txObject.___registerRetryListener(latch, wakeupVersion)) {
            case registered: 
            case opened: {
                return true;
            }
            case noregistration: {
                return true;
            }
        }
        throw new IllegalStateException();
    }
}

