/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import java.util.IdentityHashMap;
import java.util.Map;
import org.multiverse.api.Listeners;
import org.multiverse.api.Transaction;
import org.multiverse.api.commitlock.CommitLockFilter;
import org.multiverse.api.latches.Latch;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.update.AbstractUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class MapUpdateAlphaTransaction
extends AbstractUpdateAlphaTransaction {
    private final Map<AlphaTransactionalObject, AlphaTranlocal> attachedMap = new IdentityHashMap<AlphaTransactionalObject, AlphaTranlocal>(30);

    public MapUpdateAlphaTransaction(UpdateConfiguration config) {
        super(config);
    }

    @Override
    protected void doDoReset() {
        this.attachedMap.clear();
    }

    @Override
    protected void attach(AlphaTranlocal tranlocal) {
        this.attachedMap.put(tranlocal.getTransactionalObject(), tranlocal);
    }

    @Override
    protected AlphaTranlocal findAttached(AlphaTransactionalObject transactionalObject) {
        return this.attachedMap.get(transactionalObject);
    }

    @Override
    protected boolean tryWriteLocks(CommitLockFilter commitLockFilter) {
        return ((UpdateConfiguration)this.config).commitLockPolicy.tryAcquireAll(this.attachedMap.values(), commitLockFilter, (Transaction)this);
    }

    @Override
    protected void doReleaseWriteLocksForFailure() {
        for (AlphaTranlocal tranlocal : this.attachedMap.values()) {
            this.doReleaseWriteSetLocksForFailure(tranlocal);
        }
    }

    @Override
    protected void doReleaseWriteLocksForSuccess(long writeVersion) {
        for (AlphaTranlocal tranlocal : this.attachedMap.values()) {
            this.doReleaseWriteLockForSuccess(tranlocal, writeVersion);
        }
    }

    @Override
    protected boolean isDirty() {
        boolean isDirty = false;
        for (AlphaTranlocal attached : this.attachedMap.values()) {
            if (!this.isDirty(attached)) continue;
            isDirty = true;
        }
        return isDirty;
    }

    @Override
    protected boolean hasWriteConflict() {
        for (AlphaTranlocal attached : this.attachedMap.values()) {
            if (!this.hasWriteConflict(attached)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasReadWriteConflict() {
        for (AlphaTranlocal attached : this.attachedMap.values()) {
            if (!this.hasReadConflict(attached)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Listeners[] makeChangesPermanent(long writeVersion) {
        Listeners[] listenersArray = null;
        int index = 0;
        int listenersIndex = 0;
        for (AlphaTranlocal attached : this.attachedMap.values()) {
            Listeners listeners = this.makePermanent(attached, writeVersion);
            if (listeners != null) {
                if (listenersArray == null) {
                    listenersArray = new Listeners[this.attachedMap.size() - index];
                }
                listenersArray[listenersIndex] = listeners;
                ++listenersIndex;
            }
            ++index;
        }
        return listenersArray;
    }

    @Override
    protected boolean dodoRegisterRetryLatch(Latch latch, long wakeupVersion) {
        if (this.attachedMap.isEmpty()) {
            return false;
        }
        boolean trackedReads = false;
        block5: for (AlphaTransactionalObject txObject : this.attachedMap.keySet()) {
            switch (txObject.___registerRetryListener(latch, wakeupVersion)) {
                case noregistration: {
                    continue block5;
                }
                case registered: {
                    trackedReads = true;
                    continue block5;
                }
                case opened: {
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return trackedReads;
    }
}

