/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.annogen.view.internal;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import org.codehaus.annogen.override.AnnoBean;
import org.codehaus.annogen.override.AnnoBeanSet;
import org.codehaus.annogen.view.internal.javadoc.JavadocAnnogenTigerDelegate;

public final class JavadocAnnogenTigerDelegateImpl_150
extends JavadocAnnogenTigerDelegate {
    public boolean extractAnnotations(AnnoBeanSet out, ProgramElementDoc src) {
        AnnotationDesc[] anns = src.annotations();
        if (anns == null || anns.length == 0) {
            return false;
        }
        for (int i = 0; i < anns.length; ++i) {
            AnnoBean proxy;
            Class annType = this.getClassFor(anns[i]);
            if (annType == null || (proxy = out.findOrCreateBeanFor(annType)) == null) continue;
            this.copyValues(anns[i], proxy);
        }
        return true;
    }

    public boolean extractAnnotations(AnnoBeanSet out, ExecutableMemberDoc method, int paramNum) {
        throw new IllegalStateException("parameter annos NYI");
    }

    private void copyValues(AnnotationDesc src, AnnoBean dest) {
        AnnotationDesc.ElementValuePair[] values = src.elementValues();
        if (values == null || values.length == 0) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            Object value;
            AnnotationTypeElementDoc ated = values[i].element();
            String name = ated.name();
            AnnotationValue avalue = values[i].value();
            if (avalue == null || (value = avalue.value()) == null) continue;
            if (value instanceof AnnotationDesc) {
                AnnoBean nested;
                Class nestedClass = this.getClassFor((AnnotationDesc)value);
                if (nestedClass == null || (nested = dest.createNestableBean(nestedClass)) == null) continue;
                this.copyValues((AnnotationDesc)value, nested);
                dest.setValue(name, nested);
                continue;
            }
            if (value.getClass().isArray()) {
                throw new IllegalStateException("arrays NYI");
            }
            dest.setValue(name, value);
        }
    }

    private Class getClassFor(AnnotationDesc javadocAnn) {
        try {
            return Class.forName(javadocAnn.annotationType().qualifiedTypeName());
        }
        catch (ClassNotFoundException cnfe) {
            this.getLogger().error(cnfe);
            return null;
        }
    }
}

