/*
 * Decompiled with CFR 0.152.
 */
package com.karneim.util.collection.set;

import com.karneim.util.collection.set.ISet_char;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class CharSet
implements ISet_char {
    static final int[] PRIMENUMBERS = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021, 1024};
    static final long[] VALUES = new long[64];
    static final int max = 4;
    static final char maxChar = '\u00ff';
    protected IAbstract set;

    protected CharSet(IAbstract iAbstract) {
        this.set = iAbstract;
    }

    public CharSet() {
        this.set = new LongMap();
    }

    public CharSet(char c) {
        this();
        this.set.add(c);
    }

    public CharSet(String string) {
        this();
        this.set.addAll(string, 0, string.length());
    }

    public void complement() {
        this.set.complement();
    }

    public boolean contains(char c) {
        return this.set.contains(c);
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public int size() {
        return this.set.size();
    }

    public ISet_char.Iterator iterator() {
        return this.set.iterator();
    }

    public void clear() {
        this.set = new LongMap();
    }

    public boolean add(char c) {
        return this.set.add(c);
    }

    public boolean remove(char c) {
        return this.set.remove(c);
    }

    public void addAll(String string) {
        this.addAll(string, 0, string.length());
    }

    public void addAll(String string, int n) {
        this.addAll(string, n, string.length() - n);
    }

    public void addAll(String string, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.set.addAll(string, n, n2);
    }

    public void addAll(char[] cArray) {
        this.addAll(cArray, 0, cArray.length);
    }

    public void addAll(char[] cArray, int n) {
        this.addAll(cArray, n, cArray.length - n);
    }

    public void addAll(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.set.addAll(cArray, n, n2);
    }

    public void addAll(ISet_char iSet_char) {
        if (iSet_char instanceof CharSet) {
            this.set.addAll(((CharSet)iSet_char).set);
        } else {
            ISet_char.Iterator iterator = iSet_char.iterator();
            for (int i = iSet_char.size(); i > 0; --i) {
                this.set.add(iterator.next());
            }
        }
    }

    public void removeAll(ISet_char iSet_char) {
        if (iSet_char instanceof CharSet) {
            this.set.removeAll(((CharSet)iSet_char).set);
        } else {
            ISet_char.Iterator iterator = iSet_char.iterator();
            for (int i = iSet_char.size(); i > 0; --i) {
                this.set.remove(iterator.next());
            }
        }
    }

    public void retainAll(ISet_char iSet_char) {
        if (iSet_char instanceof CharSet) {
            this.set.retainAll(((CharSet)iSet_char).set);
        } else {
            CharSet charSet = new CharSet();
            ISet_char.Iterator iterator = iSet_char.iterator();
            for (int i = iSet_char.size(); i > 0; --i) {
                charSet.add(iterator.next());
            }
            this.set.retainAll(charSet.set);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.set.equals(((CharSet)object).set);
    }

    public int hashCode() {
        return this.set.size();
    }

    protected IAbstract cloneAbstract(IAbstract iAbstract) {
        if (iAbstract instanceof LongMap) {
            return new LongMap((LongMap)iAbstract);
        }
        throw new Error("");
    }

    public Object clone() {
        try {
            CharSet charSet = (CharSet)super.clone();
            charSet.set = charSet.cloneAbstract(this.set);
            CharSet charSet2 = charSet;
            return charSet2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("CloneNotSupportedException:\n".concat(String.valueOf(String.valueOf(cloneNotSupportedException))));
        }
    }

    public String toString() {
        char c;
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        int c3 = -1;
        char c4 = '\u0000';
        do {
            if (this.contains(c4)) {
                if (c2 != -1) continue;
                c2 = c4;
                continue;
            }
            if (c2 == -1) continue;
            c = c4;
            if (c2 == (c = (char)(c - '\u0001'))) {
                if (c == '[' || c == ']' || c == '\\' || c == '-') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            } else {
                char c5 = c2;
                if (c5 == '[' || c5 == ']' || c5 == '\\' || c5 == '-') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
                if (c != ++c2) {
                    stringBuffer.append("-");
                }
                if (c == '[' || c == ']' || c == '\\' || c == '-') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            c2 = '\uffffffff';
        } while ((c4 = (char)(c4 + '\u0001')) != '\u0000');
        if (c2 != '\uffffffff') {
            c = c2;
            if (c == '[' || c == ']' || c == '\\' || c == '-') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
            if (c2 != '\ufffe') {
                stringBuffer.append('-');
            }
            stringBuffer.append('\uffff');
        }
        for (c = stringBuffer.length() - 1; c >= '\u0000'; --c) {
            if (stringBuffer.charAt(c) <= '\u00ff') continue;
            stringBuffer.setCharAt(c, '.');
        }
        return stringBuffer.toString();
    }

    static {
        CharSet.VALUES[0] = 1L;
        int n = 0;
        int n2 = 1;
        while (n2 < VALUES.length) {
            CharSet.VALUES[n2] = VALUES[n] << 1;
            ++n2;
            ++n;
        }
        max = 4;
        maxChar = (char)255;
    }

    final class LongMap
    implements IAbstract {
        Wrapper[] sets = null;
        int size = 0;

        protected LongMap(LongMap longMap) {
            this.sets = new Wrapper[longMap.sets.length];
            for (int i = 0; i < longMap.sets.length; ++i) {
                if (longMap.sets[i] == null) continue;
                this.sets[i] = new Wrapper(longMap.sets[i].offset, longMap.sets[i].value);
            }
            this.size = longMap.size;
        }

        LongMap() {
            this.sets = new Wrapper[PRIMENUMBERS[0]];
        }

        LongMap(char c, char c2) {
            this.sets = new Wrapper[PRIMENUMBERS[0]];
            this.add(c);
            this.add(c2);
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public int size() {
            if (this.size >= 0) {
                return this.size;
            }
            int n = 0;
            for (int i = 0; i < this.sets.length; ++i) {
                if (this.sets[i] == null) continue;
                n += this.sets[i].size();
            }
            this.size = n;
            return n;
        }

        public boolean contains(char c) {
            int n = c / 64;
            int n2 = n % this.sets.length;
            if (this.sets[n2] == null || this.sets[n2].offset != n) {
                return false;
            }
            return (this.sets[n2].value & VALUES[c % 64]) != (long)0;
        }

        public void complement() {
            this.size = -1;
            Wrapper[] wrapperArray = this.sets;
            this.sets = new Wrapper[PRIMENUMBERS[0]];
            int n = 0;
            while (true) {
                if (n >= 4) break;
                int n2 = n % wrapperArray.length;
                long l = -1L;
                if (wrapperArray[n2] != null && wrapperArray[n2].offset == n) {
                    l ^= wrapperArray[n2].value;
                }
                if (l != (long)0) {
                    this.addAll(n, l);
                }
                ++n;
            }
        }

        public boolean add(char c) {
            if (c > '\u00ff') {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("ch > maxChar = ").append('\u00ff').append("(").append(255).append(")"))));
            }
            int n = c / 64;
            while (true) {
                int n2;
                if (this.sets[n2 = n % this.sets.length] == null) {
                    this.sets[n2] = new Wrapper(n, 1L << c % 64);
                    if (this.size >= 0) {
                        ++this.size;
                    }
                    return true;
                }
                if (this.sets[n2].offset == n) {
                    long l = this.sets[n2].value;
                    this.sets[n2].value |= VALUES[c % 64];
                    long l2 = this.sets[n2].value;
                    if (l == l2) {
                        return false;
                    }
                    if (this.size >= 0) {
                        ++this.size;
                    }
                    return true;
                }
                this.expand();
            }
        }

        public void addAll(char[] cArray, int n, int n2) {
            while (n2 > 0) {
                this.add(cArray[n]);
                ++n;
                --n2;
            }
        }

        public void addAll(String string, int n, int n2) {
            while (n2 > 0) {
                this.add(string.charAt(n));
                ++n;
                --n2;
            }
        }

        public void addAll(IAbstract iAbstract) {
            this.addAll((LongMap)iAbstract);
        }

        void addAll(LongMap longMap) {
            if (this.sets.length >= longMap.sets.length) {
                for (int i = 0; i < longMap.sets.length; ++i) {
                    if (longMap.sets[i] == null) continue;
                    this.addAll(longMap.sets[i].offset, longMap.sets[i].value);
                }
            } else {
                int n;
                Wrapper[] wrapperArray = this.sets;
                this.sets = new Wrapper[longMap.sets.length];
                for (n = 0; n < longMap.sets.length; ++n) {
                    this.sets[n] = longMap.sets[n] == null ? null : new Wrapper(longMap.sets[n].offset, longMap.sets[n].value);
                }
                this.size = longMap.size;
                for (n = 0; n < wrapperArray.length; ++n) {
                    if (wrapperArray[n] == null) continue;
                    this.addAll(wrapperArray[n]);
                }
            }
        }

        private void addAll(int n, long l) {
            this.size = -1;
            while (true) {
                int n2;
                if (this.sets[n2 = n % this.sets.length] == null) {
                    this.sets[n2] = new Wrapper(n, l);
                    return;
                }
                if (this.sets[n2].offset == n) {
                    this.sets[n2].value |= l;
                    return;
                }
                this.expand();
            }
        }

        private void addAll(Wrapper wrapper) {
            this.size = -1;
            while (true) {
                int n;
                if (this.sets[n = wrapper.offset % this.sets.length] == null) {
                    this.sets[n] = wrapper;
                    return;
                }
                if (this.sets[n].offset == wrapper.offset) {
                    this.sets[n].value |= wrapper.value;
                    return;
                }
                this.expand();
            }
        }

        public boolean remove(char c) {
            int n = c / 64;
            int n2 = n % this.sets.length;
            if (this.sets[n2] == null) {
                return false;
            }
            if (this.sets[n2].offset != n) {
                return false;
            }
            long l = this.sets[n2].value;
            this.sets[n2].value &= 0xFFFFFFFFFFFFFFFFL ^ VALUES[c % 64];
            long l2 = this.sets[n2].value;
            if (l == l2) {
                return false;
            }
            if (this.size > 0) {
                --this.size;
            }
            if (l2 == (long)0) {
                this.sets[n2] = null;
            }
            return true;
        }

        public void removeAll(IAbstract iAbstract) {
            this.removeAll((LongMap)iAbstract);
        }

        void removeAll(LongMap longMap) {
            for (int i = 0; i < longMap.sets.length; ++i) {
                if (longMap.sets[i] == null) continue;
                this.removeAll(longMap.sets[i].offset, longMap.sets[i].value);
            }
        }

        private void removeAll(int n, long l) {
            int n2 = n % this.sets.length;
            if (this.sets[n2] == null) {
                return;
            }
            if (this.sets[n2].offset != n) {
                return;
            }
            this.size = -1;
            this.sets[n2].value &= 0xFFFFFFFFFFFFFFFFL ^ l;
            if (this.sets[n2].value == (long)0) {
                this.sets[n2] = null;
            }
        }

        public void retainAll(IAbstract iAbstract) {
            this.retainAll((LongMap)iAbstract);
        }

        void retainAll(LongMap longMap) {
            this.size = -1;
            for (int i = 0; i < this.sets.length; ++i) {
                if (this.sets[i] == null) continue;
                Wrapper wrapper = this.sets[i];
                Wrapper wrapper2 = longMap.sets[wrapper.offset % longMap.sets.length];
                if (wrapper2 == null) {
                    this.sets[i] = null;
                    continue;
                }
                if (wrapper.offset != wrapper2.offset) {
                    this.sets[i] = null;
                    continue;
                }
                wrapper.value &= wrapper2.value;
                if (this.sets[i].value != (long)0) continue;
                this.sets[i] = null;
            }
        }

        private void expand() {
            Wrapper[] wrapperArray = this.sets;
            block0: while (true) {
                this.sets = new Wrapper[this.nextPrimeNumber()];
                for (int i = 0; i < wrapperArray.length; ++i) {
                    if (wrapperArray[i] == null) continue;
                    int n = wrapperArray[i].offset % this.sets.length;
                    if (this.sets[n] != null) continue block0;
                    this.sets[n] = wrapperArray[i];
                }
                break;
            }
        }

        private int nextPrimeNumber() {
            int n = this.sets.length;
            int n2 = 0;
            while (PRIMENUMBERS[n2] != n) {
                ++n2;
            }
            return PRIMENUMBERS[++n2];
        }

        public ISet_char.Iterator iterator() {
            return new ISet_char.Iterator(this){
                int currentOffset;
                long currentValue;
                char currentChar;
                final int setsLength;
                private final /* synthetic */ LongMap this$1;
                {
                    this.this$1 = longMap;
                    this.currentOffset = 0;
                    this.currentValue = 1L;
                    this.currentChar = '\u0000';
                    this.setsLength = this.this$1.sets.length;
                }

                public boolean hasNext() {
                    do {
                        if (!this.this$1.contains(this.currentChar)) continue;
                        return true;
                    } while ((this.currentChar = (char)(this.currentChar + '\u0001')) != '\u0000');
                    return false;
                }

                public char next() {
                    do {
                        if (!this.this$1.contains(this.currentChar)) continue;
                        char c = this.currentChar;
                        this.currentChar = (char)(c + '\u0001');
                        return c;
                    } while ((this.currentChar = (char)(this.currentChar + '\u0001')) != '\u0000');
                    throw new NoSuchElementException(LongMap.access$0(this.this$1).toString());
                }
            };
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LongMap longMap = (LongMap)object;
            if (this.size != longMap.size) {
                return false;
            }
            for (int i = 0; i < this.sets.length; ++i) {
                if (this.sets[i] == null) continue;
                if (this.sets[i].value == (long)0) {
                    throw new Error("this.sets[i].value==0");
                }
                Wrapper wrapper = this.sets[i];
                Wrapper wrapper2 = longMap.sets[wrapper.offset % longMap.sets.length];
                if (wrapper2 == null) {
                    return false;
                }
                if (wrapper.offset != wrapper2.offset) {
                    return false;
                }
                if (wrapper.value == wrapper2.value) continue;
                return false;
            }
            return true;
        }

        static /* synthetic */ CharSet access$0(LongMap longMap) {
            return longMap.CharSet.this;
        }
    }

    static final class Wrapper
    implements Serializable {
        final int offset;
        long value;

        Wrapper(int n, long l) {
            this.offset = n;
            this.value = l;
        }

        int size() {
            int n = 0;
            block18: for (long i = this.value; i != (long)0; i >>>= 4) {
                switch ((int)(i & 0xFL)) {
                    case 0: {
                        n += 0;
                        continue block18;
                    }
                    case 1: {
                        ++n;
                        continue block18;
                    }
                    case 2: {
                        ++n;
                        continue block18;
                    }
                    case 3: {
                        n += 2;
                        continue block18;
                    }
                    case 4: {
                        ++n;
                        continue block18;
                    }
                    case 5: {
                        n += 2;
                        continue block18;
                    }
                    case 6: {
                        n += 2;
                        continue block18;
                    }
                    case 7: {
                        n += 3;
                        continue block18;
                    }
                    case 8: {
                        ++n;
                        continue block18;
                    }
                    case 9: {
                        n += 2;
                        continue block18;
                    }
                    case 10: {
                        n += 2;
                        continue block18;
                    }
                    case 11: {
                        n += 3;
                        continue block18;
                    }
                    case 12: {
                        n += 2;
                        continue block18;
                    }
                    case 13: {
                        n += 3;
                        continue block18;
                    }
                    case 14: {
                        n += 3;
                        continue block18;
                    }
                    case 15: {
                        n += 4;
                        continue block18;
                    }
                    default: {
                        throw new RuntimeException("error: should never happen");
                    }
                }
            }
            return n;
        }
    }

    static interface IAbstract
    extends Serializable {
        public int size();

        public boolean isEmpty();

        public void complement();

        public boolean contains(char var1);

        public boolean add(char var1);

        public boolean remove(char var1);

        public void addAll(IAbstract var1);

        public void removeAll(IAbstract var1);

        public void retainAll(IAbstract var1);

        public ISet_char.Iterator iterator();

        public void addAll(String var1, int var2, int var3);

        public void addAll(char[] var1, int var2, int var3);

        public boolean equals(Object var1);
    }
}

