/*
 * Decompiled with CFR 0.152.
 */
package com.karneim.util.collection.set;

import com.karneim.util.collection.set.CharSet;
import com.karneim.util.collection.set.FSAData;
import com.karneim.util.collection.set.SAutomatonData;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.HashMap;

public class DFASet {
    protected final State[] states;
    protected final Integer startState;
    static Class class$com$karneim$util$collection$set$FSAData;

    protected DFASet(State[] stateArray, Integer n) {
        this.states = stateArray;
        this.startState = n;
    }

    public DFASet(FSAData fSAData) {
        int n;
        if (fSAData == null) {
            throw new IllegalArgumentException("automaton==null");
        }
        HashMap<String, CharSet> hashMap = new HashMap<String, CharSet>();
        State[] stateArray = new State[fSAData.states == null ? 0 : fSAData.states.length];
        for (n = 0; n < stateArray.length; ++n) {
            FSAData.State state = fSAData.states[n];
            if (state == null) {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n + 1))).append(". state of automaton is null"))));
            }
            State.Transition[] transitionArray = new State.Transition[state.transitions == null ? 0 : state.transitions.length];
            for (int i = 0; i < transitionArray.length; ++i) {
                FSAData.State.Transition transition = state.transitions[i];
                if (transition == null) {
                    throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + 1))).append(". transition of state ").append(state.number).append(" is null"))));
                }
                if (transition.charSet == null) {
                    throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("charSet of ").append(i + 1).append(". transition of state ").append(state.number).append(" is null"))));
                }
                CharSet charSet = (CharSet)hashMap.get(transition.charSet);
                if (charSet == null) {
                    charSet = new CharSet(transition.charSet);
                    hashMap.put(transition.charSet, charSet);
                }
                int n2 = 0;
                try {
                    while (fSAData.states[n2].number != transition.toStateNumber) {
                        ++n2;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("toState ").append(transition.toStateNumber).append(" of ").append(i + 1).append(". transition of state ").append(state.number).append(" does not exist"))));
                }
                transitionArray[i] = new State.Transition(charSet, n2);
            }
            stateArray[n] = new State(state.isFinal, transitionArray);
        }
        this.states = stateArray;
        if (fSAData.startStateNumber == null) {
            this.startState = null;
        } else {
            n = fSAData.startStateNumber;
            int n3 = 0;
            try {
                while (fSAData.states[n3].number != n) {
                    ++n3;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("startState ").append(fSAData.startStateNumber).append(" does not exist"))));
            }
            this.startState = new Integer(n3);
        }
    }

    protected static FSAData toFSAData(Object object) {
        if (object.getClass() != (class$com$karneim$util$collection$set$FSAData == null ? (class$com$karneim$util$collection$set$FSAData = DFASet.class$("com.karneim.util.collection.set.FSAData")) : class$com$karneim$util$collection$set$FSAData)) {
            SAutomatonData sAutomatonData = (SAutomatonData)object;
            FSAData.State[] stateArray = new FSAData.State[sAutomatonData.states == null ? 0 : sAutomatonData.states.length];
            for (int i = 0; i < stateArray.length; ++i) {
                SAutomatonData.State state = sAutomatonData.states[i];
                if (state == null) continue;
                FSAData.State.Transition[] transitionArray = new FSAData.State.Transition[state.transitions == null ? 0 : state.transitions.length];
                for (int j = 0; j < transitionArray.length; ++j) {
                    SAutomatonData.State.Transition transition = state.transitions[j];
                    transitionArray[j] = new FSAData.State.Transition(transition.properties, transition.charSet, transition.toStateNumber);
                }
                stateArray[i] = new FSAData.State(state.number, state.isFinal, transitionArray, state.transitionsAreDeterministic);
            }
            return new FSAData(stateArray, sAutomatonData.startStateNumber, sAutomatonData.isDeterministic);
        }
        FSAData fSAData = (FSAData)object;
        switch (fSAData.objectVersion) {
            case 1: {
                return fSAData;
            }
        }
        return fSAData;
    }

    public DFASet(InputStream inputStream) throws ClassNotFoundException, IOException {
        this(DFASet.toFSAData(new ObjectInputStream(inputStream).readObject()));
    }

    public boolean contains(char[] cArray) {
        return this.contains(cArray, 0, cArray.length);
    }

    public boolean contains(char[] cArray, int n) {
        return this.contains(cArray, n, cArray.length - n);
    }

    public boolean contains(char[] cArray, int n, int n2) {
        if (this.startState == null) {
            return false;
        }
        State state = this.states[this.startState];
        while (n2 > 0) {
            int n3;
            block4: {
                for (n3 = 0; n3 < state.transitions.length; ++n3) {
                    if (!state.transitions[n3].charSet.contains(cArray[n])) {
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            state = this.states[state.transitions[n3].toState];
            ++n;
            --n2;
        }
        return state.isFinal;
    }

    public boolean contains(String string) {
        return this.contains(string, 0, string.length());
    }

    public boolean contains(String string, int n) {
        return this.contains(string, n, string.length() - n);
    }

    public boolean contains(String string, int n, int n2) {
        if (this.startState == null) {
            return false;
        }
        State state = this.states[this.startState];
        while (n2 > 0) {
            int n3;
            block4: {
                for (n3 = 0; n3 < state.transitions.length; ++n3) {
                    if (!state.transitions[n3].charSet.contains(string.charAt(n))) {
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            state = this.states[state.transitions[n3].toState];
            ++n;
            --n2;
        }
        return state.isFinal;
    }

    public boolean contains(Reader reader) throws IOException {
        if (this.startState == null) {
            return false;
        }
        State state = this.states[this.startState];
        int n = reader.read();
        while (n != -1) {
            int n2;
            block4: {
                for (n2 = 0; n2 < state.transitions.length; ++n2) {
                    if (!state.transitions[n2].charSet.contains((char)n)) {
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            state = this.states[state.transitions[n2].toState];
            n = reader.read();
        }
        return state.isFinal;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class State {
        protected final boolean isFinal;
        protected final Transition[] transitions;

        protected State(boolean bl, Transition[] transitionArray) {
            this.isFinal = bl;
            this.transitions = transitionArray;
        }

        protected static class Transition {
            protected final CharSet charSet;
            protected final int toState;

            protected Transition(CharSet charSet, int n) {
                this.charSet = charSet;
                this.toState = n;
            }
        }
    }
}

