/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.aspect;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.codehaus.aspectwerkz.AspectContext;
import org.codehaus.aspectwerkz.aspect.AspectContainer;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;

public abstract class AbstractAspectContainer
implements AspectContainer {
    protected Class m_aspectClass;
    protected Reference m_classLoader;
    protected String m_uuid;
    protected String m_qualifiedName;
    private AspectDefinition m_aspectDefinitionLazy;
    public static final int ASPECT_CONSTRUCTION_TYPE_UNKNOWN = 0;
    public static final int ASPECT_CONSTRUCTION_TYPE_DEFAULT = 1;
    public static final int ASPECT_CONSTRUCTION_TYPE_ASPECT_CONTEXT = 2;
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected int m_constructionType = 0;

    public AbstractAspectContainer(Class aspectClass, ClassLoader aopSystemClassLoader, String uuid, String qualifiedName, Map parameters) {
        this.m_aspectClass = aspectClass;
        this.m_classLoader = new WeakReference<ClassLoader>(aopSystemClassLoader);
        this.m_uuid = uuid;
        this.m_qualifiedName = qualifiedName;
    }

    public AspectDefinition getAspectDefinition() {
        if (this.m_aspectDefinitionLazy == null) {
            SystemDefinition def = SystemDefinitionContainer.getDefinitionFor(this.getDefiningSystemClassLoader(), this.m_uuid);
            if (def == null) {
                throw new RuntimeException("Definition " + this.m_uuid + " not found from " + this.getDefiningSystemClassLoader());
            }
            for (AspectDefinition aspectDefinition : def.getAspectDefinitions()) {
                if (!this.m_qualifiedName.equals(aspectDefinition.getQualifiedName())) continue;
                this.m_aspectDefinitionLazy = aspectDefinition;
            }
            if (this.m_aspectDefinitionLazy == null) {
                throw new RuntimeException("Aspect definition not found " + this.m_qualifiedName + " from " + this.getDefiningSystemClassLoader());
            }
        }
        return this.m_aspectDefinitionLazy;
    }

    public ClassLoader getDefiningSystemClassLoader() {
        return (ClassLoader)this.m_classLoader.get();
    }

    public Object aspectOf() {
        return this.createAspect(this.getContext(null));
    }

    public Object aspectOf(Class klass) {
        return this.createAspect(this.getContext(klass));
    }

    public Object aspectOf(Object instance) {
        return this.createAspect(this.getContext(instance));
    }

    public Object aspectOf(Thread thread) {
        return this.createAspect(this.getContext(thread));
    }

    protected abstract Object createAspect(AspectContext var1);

    protected AspectContext getContext(Object associated) {
        AspectDefinition aspectDefinition = this.getAspectDefinition();
        return new AspectContext(this.m_uuid, this.m_aspectClass, aspectDefinition.getName(), aspectDefinition.getDeploymentModel(), aspectDefinition, aspectDefinition.getParameters(), associated);
    }

    public Class getAspectClass() {
        return this.m_aspectClass;
    }
}

