/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.cflow;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.aspectwerkz.aspect.AdviceType;
import org.codehaus.aspectwerkz.cflow.AbstractCflowSystemAspect;
import org.codehaus.aspectwerkz.cflow.CflowCompiler;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfo;

public class CflowBinding {
    private static final ClassInfo ABSTRACT_CFLOWCLASS = JavaClassInfo.getClassInfo(AbstractCflowSystemAspect.class);
    private static final MethodInfo CFLOW_ENTER_ADVICE;
    private static final MethodInfo CFLOW_EXIT_ADVICE;
    private int m_cflowID;
    private ExpressionInfo m_cflowSubExpression;
    private ExpressionInfo m_outerExpression;
    private boolean m_isCflowBelow;

    public CflowBinding(int cflowID, ExpressionInfo cflowSubExpression, ExpressionInfo outerExpression, boolean isCflowBelow) {
        this.m_cflowID = cflowID;
        this.m_cflowSubExpression = cflowSubExpression;
        this.m_outerExpression = outerExpression;
        this.m_isCflowBelow = isCflowBelow;
    }

    public ExpressionInfo getExpression() {
        return this.m_cflowSubExpression;
    }

    public static List getCflowBindingsForCflowOf(ExpressionInfo expressionInfo) {
        ArrayList cflowBindings = new ArrayList();
        if (expressionInfo != null) {
            expressionInfo.getCflowAspectExpression().populateCflowAspectBindings(cflowBindings);
        }
        return cflowBindings;
    }

    public AspectDefinition getAspectDefinition(SystemDefinition systemDefinition, ClassLoader loader) {
        String aspectName = CflowCompiler.getCflowAspectClassName(this.m_cflowID);
        Class aspectClass = CflowCompiler.compileCflowAspectAndAttachToClassLoader(loader, this.m_cflowID);
        ClassInfo cflowAspectInfo = JavaClassInfo.getClassInfo(aspectClass);
        AspectDefinition aspectDef = new AspectDefinition(aspectName.replace('/', '.'), cflowAspectInfo, systemDefinition);
        aspectDef.addBeforeAdviceDefinition(new AdviceDefinition(CFLOW_ENTER_ADVICE.getName(), AdviceType.BEFORE, null, aspectName, aspectName, this.m_cflowSubExpression, CFLOW_ENTER_ADVICE, aspectDef));
        aspectDef.addAfterAdviceDefinition(new AdviceDefinition(CFLOW_EXIT_ADVICE.getName(), AdviceType.AFTER_FINALLY, null, aspectName, aspectName, this.m_cflowSubExpression, CFLOW_EXIT_ADVICE, aspectDef));
        return aspectDef;
    }

    public boolean isCflowBelow() {
        return this.m_isCflowBelow;
    }

    public int getCflowID() {
        return this.m_cflowID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CflowBinding)) {
            return false;
        }
        CflowBinding cflowBinding = (CflowBinding)o;
        if (this.m_cflowID != cflowBinding.m_cflowID) {
            return false;
        }
        return this.m_isCflowBelow == cflowBinding.m_isCflowBelow;
    }

    public int hashCode() {
        int result = this.m_cflowID;
        result = 29 * result + (this.m_isCflowBelow ? 1 : 0);
        return result;
    }

    static {
        MethodInfo enter = null;
        MethodInfo exit = null;
        for (int i = 0; i < ABSTRACT_CFLOWCLASS.getMethods().length; ++i) {
            MethodInfo methodInfo = ABSTRACT_CFLOWCLASS.getMethods()[i];
            if (methodInfo.getName().equals("enter")) {
                enter = methodInfo;
                continue;
            }
            if (!methodInfo.getName().equals("exit")) continue;
            exit = methodInfo;
        }
        if (enter == null || exit == null) {
            throw new Error("Could not gather cflow advices from " + AbstractCflowSystemAspect.class);
        }
        CFLOW_ENTER_ADVICE = enter;
        CFLOW_EXIT_ADVICE = exit;
    }
}

