/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.aspectwerkz.definition.DocumentParser;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XmlParser {
    private static final String DTD_PUBLIC_ID = "-//AspectWerkz//DTD 2.0//EN";
    private static final String DTD_PUBLIC_ID_ALIAS = "-//AspectWerkz//DTD//EN";
    private static final InputStream DTD_STREAM = XmlParser.class.getResourceAsStream("/aspectwerkz2.dtd");
    private static File s_timestamp = new File(".timestamp");
    private static Set s_definitions = null;

    public static Set parseNoCache(ClassLoader loader, URL url) {
        try {
            Document document = XmlParser.createDocument(url);
            s_definitions = DocumentParser.parse(loader, document);
            return s_definitions;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static Document mergeDocuments(Document document1, Document document2) {
        if (document2 == null && document1 != null) {
            return document1;
        }
        if (document1 == null && document2 != null) {
            return document2;
        }
        if (document1 == null && document2 == null) {
            return null;
        }
        try {
            Element root1 = document1.getRootElement();
            Element root2 = document2.getRootElement();
            Iterator it1 = root2.elementIterator();
            while (it1.hasNext()) {
                Element element = (Element)it1.next();
                element.setParent(null);
                root1.add(element);
            }
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return document1;
    }

    public static Document createDocument(URL url) throws DocumentException {
        SAXReader reader = new SAXReader();
        XmlParser.setEntityResolver(reader);
        InputStream in = null;
        try {
            in = url.openStream();
            Document document = reader.read(in);
            return document;
        }
        catch (IOException e) {
            throw new DocumentException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable t) {}
        }
    }

    public static Document createDocument(String string) throws DocumentException {
        return DocumentHelper.parseText(string);
    }

    private static void setEntityResolver(SAXReader reader) {
        EntityResolver resolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                if (publicId.equals(XmlParser.DTD_PUBLIC_ID) || publicId.equals(XmlParser.DTD_PUBLIC_ID_ALIAS)) {
                    InputStream in = DTD_STREAM;
                    if (in == null) {
                        System.err.println("AspectWerkz - WARN - could not open DTD");
                        return new InputSource();
                    }
                    return new InputSource(in);
                }
                System.err.println("AspectWerkz - WARN - deprecated DTD " + publicId + " - consider upgrading to " + XmlParser.DTD_PUBLIC_ID);
                return new InputSource();
            }
        };
        reader.setEntityResolver(resolver);
    }

    private static boolean isNotUpdated(File definitionFile) {
        return definitionFile.lastModified() < XmlParser.getParsingTimestamp() && s_definitions != null;
    }

    private static void setParsingTimestamp() {
        long newModifiedTime = System.currentTimeMillis();
        s_timestamp.setLastModified(newModifiedTime);
    }

    private static long getParsingTimestamp() {
        long modifiedTime = s_timestamp.lastModified();
        if (modifiedTime == 0L) {
            try {
                s_timestamp.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("could not create timestamp file: " + s_timestamp.getAbsolutePath());
            }
        }
        return modifiedTime;
    }
}

