/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.aspectwerkz.cflow.CflowAspectExpressionVisitor;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.expression.AdvisedClassFilterExpressionVisitor;
import org.codehaus.aspectwerkz.expression.ExpressionValidateVisitor;
import org.codehaus.aspectwerkz.expression.ExpressionVisitor;
import org.codehaus.aspectwerkz.expression.ast.ASTRoot;
import org.codehaus.aspectwerkz.expression.ast.ExpressionParser;
import org.codehaus.aspectwerkz.expression.ast.Node;
import org.codehaus.aspectwerkz.expression.regexp.Pattern;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.StaticJoinPoint;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.util.SequencedHashMap;

public class ExpressionInfo {
    public static final String JOINPOINT_CLASS_NAME = JoinPoint.class.getName();
    public static final String STATIC_JOINPOINT_CLASS_NAME = StaticJoinPoint.class.getName();
    public static final String JOINPOINT_ABBREVIATION = "JoinPoint";
    public static final String STATIC_JOINPOINT_ABBREVIATION = "StaticJoinPoint";
    public static final String RTTI_ABBREVIATION = "Rtti";
    private static final ExpressionParser s_parser = new ExpressionParser(System.in);
    private final ExpressionVisitor m_expression;
    private final AdvisedClassFilterExpressionVisitor m_advisedClassFilterExpression;
    private final CflowAspectExpressionVisitor m_cflowAspectExpression;
    private Map m_argsTypeByName = new SequencedHashMap();
    private List m_possibleArguments = null;
    private String m_specialArgumentName = null;

    public ExpressionInfo(String expression, String namespace) {
        try {
            ASTRoot root = s_parser.parse(expression);
            this.m_expression = new ExpressionVisitor(this, expression, namespace, root);
            this.m_advisedClassFilterExpression = new AdvisedClassFilterExpressionVisitor(this, expression, namespace, root);
            this.m_cflowAspectExpression = new CflowAspectExpressionVisitor(this, root, namespace);
        }
        catch (Throwable e) {
            throw new DefinitionException("expression is not well-formed [" + expression + "]: " + e.getMessage(), e);
        }
    }

    public ExpressionInfo(Node subExpression, String namespace) {
        try {
            this.m_expression = new ExpressionVisitor(this, "N/A", namespace, subExpression);
            this.m_advisedClassFilterExpression = new AdvisedClassFilterExpressionVisitor(this, "N/A", namespace, subExpression);
            this.m_cflowAspectExpression = new CflowAspectExpressionVisitor(this, subExpression, namespace);
        }
        catch (Throwable e) {
            throw new DefinitionException("sub expression is not well-formed from [" + subExpression + "]: " + e.getMessage(), e);
        }
    }

    public ExpressionVisitor getExpression() {
        return this.m_expression;
    }

    public String getNamespace() {
        return this.m_expression.m_namespace;
    }

    public CflowAspectExpressionVisitor getCflowAspectExpression() {
        return this.m_cflowAspectExpression;
    }

    public AdvisedClassFilterExpressionVisitor getAdvisedClassFilterExpression() {
        return this.m_advisedClassFilterExpression;
    }

    public static ExpressionParser getParser() {
        return s_parser;
    }

    public String toString() {
        return this.m_expression.toString();
    }

    public void addArgument(String name, String className, ClassLoader loader) {
        String expression = this.toString();
        if (expression.indexOf(40) > 0 && !this.isJoinPointOrRtti(className, loader)) {
            if (this.toString().indexOf(name) < 0) {
                throw new DefinitionException("pointcut expression is missing a parameter that has been encountered in the advice: '" + this.toString() + "' - '" + name + "' of type '" + className + "' missing in '" + this.getExpression().m_namespace + "'");
            }
            if (this.m_possibleArguments == null) {
                this.m_possibleArguments = new ArrayList();
                new ExpressionValidateVisitor(this.toString(), this.getNamespace(), this.getExpression().m_root).populate(this.m_possibleArguments);
            }
            if (!this.m_possibleArguments.contains(name)) {
                throw new DefinitionException("pointcut expression is missing a parameter that has been encountered in the advice: '" + this.toString() + "' - '" + name + "' of type '" + className + "' missing in '" + this.getExpression().m_namespace + "'");
            }
        }
        this.m_argsTypeByName.put(name, className);
    }

    public void setSpecialArgumentName(String specialArgumentName) {
        this.m_specialArgumentName = specialArgumentName;
    }

    public String getSpecialArgumentName() {
        return this.m_specialArgumentName;
    }

    public String getArgumentType(String parameterName) {
        return (String)this.m_argsTypeByName.get(parameterName);
    }

    public int getArgumentIndex(String parameterName) {
        if (this.m_argsTypeByName.containsKey(parameterName)) {
            return ((SequencedHashMap)this.m_argsTypeByName).indexOf(parameterName);
        }
        return -1;
    }

    public String getArgumentNameAtIndex(int index) {
        if (index >= this.m_argsTypeByName.size()) {
            throw new ArrayIndexOutOfBoundsException("cannot get argument at index " + index + " in " + this.m_expression.toString());
        }
        return (String)this.m_argsTypeByName.keySet().toArray()[index];
    }

    public Set getArgumentNames() {
        return this.m_argsTypeByName.keySet();
    }

    private boolean isJoinPointOrRtti(String className, ClassLoader loader) {
        if (JOINPOINT_CLASS_NAME.equals(className) || STATIC_JOINPOINT_CLASS_NAME.equals(className) || JOINPOINT_ABBREVIATION.equals(className) || STATIC_JOINPOINT_ABBREVIATION.equals(className) || RTTI_ABBREVIATION.equals(className)) {
            return true;
        }
        if (className.equals("int") || className.equals("long") || className.equals("short") || className.equals("float") || className.equals("double") || className.equals("boolean") || className.equals("byte") || className.equals("char") || className.endsWith("]") || className.startsWith("java.")) {
            return false;
        }
        try {
            String fullClassName = (String)Pattern.ABBREVIATIONS.get(className);
            if (fullClassName != null) {
                className = fullClassName;
            }
            if (className.startsWith("java.")) {
                return false;
            }
            ClassInfo classInfo = AsmClassInfo.getClassInfo(className, loader);
            if (ClassInfoHelper.implementsInterface(classInfo, JOINPOINT_CLASS_NAME) || ClassInfoHelper.implementsInterface(classInfo, STATIC_JOINPOINT_CLASS_NAME)) {
                return true;
            }
        }
        catch (Throwable e) {
            throw new WrappedRuntimeException(e);
        }
        return false;
    }

    public void inheritPossibleArgumentFrom(ExpressionInfo expressionInfo) {
        this.m_specialArgumentName = expressionInfo.m_specialArgumentName;
        this.m_possibleArguments = expressionInfo.m_possibleArguments;
        this.m_argsTypeByName = expressionInfo.m_argsTypeByName;
    }
}

