/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.proxy;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassReader;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.AsmNullAdapter;

public class ProxyCompiler
implements TransformationConstants {
    public static InputStream getProxyResourceAsStream(ClassLoader loader, String proxyClassName) {
        String className = null;
        if (className != null) {
            byte[] proxy = ProxyCompiler.compileProxyFor(loader, className, proxyClassName);
            return new BufferedInputStream(new ByteArrayInputStream(proxy));
        }
        return null;
    }

    public static byte[] compileProxyFor(Class clazz, String proxyClassName) {
        return ProxyCompiler.compileProxyFor(clazz.getClassLoader(), clazz.getName(), proxyClassName);
    }

    public static byte[] compileProxyFor(ClassLoader loader, String className, String proxyClassName) {
        ClassReader classReader;
        String targetClassName = className.replace('.', '/');
        ClassWriter proxyWriter = AsmHelper.newClassWriter(true);
        InputStream in = null;
        try {
            in = loader != null ? loader.getResourceAsStream(targetClassName + ".class") : ClassLoader.getSystemClassLoader().getResourceAsStream(targetClassName + ".class");
            classReader = new ClassReader(in);
        }
        catch (IOException e) {
            throw new WrappedRuntimeException("Cannot compile proxy for " + className, e);
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable t) {}
        }
        ProxyCompilerClassVisitor createProxy = new ProxyCompilerClassVisitor(proxyWriter, proxyClassName.replace('.', '/'));
        classReader.accept(createProxy, true);
        return proxyWriter.toByteArray();
    }

    private static class ProxyCompilerClassVisitor
    extends AsmNullAdapter.NullClassAdapter {
        private final ClassVisitor m_proxyCv;
        private final String m_proxyClassName;
        private String m_className;

        public ProxyCompilerClassVisitor(ClassVisitor proxyCv, String proxyClassName) {
            this.m_proxyCv = proxyCv;
            this.m_proxyClassName = proxyClassName;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (Modifier.isFinal(access)) {
                throw new RuntimeException("Cannot create a proxy from final class " + name);
            }
            this.m_className = name;
            this.m_proxyCv.visit(version, 4129, this.m_proxyClassName.replace('.', '/'), signature, name, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!(Modifier.isFinal(access) || Modifier.isPrivate(access) || Modifier.isNative(access) || "<clinit>".equals(name))) {
                if ("<init>".equals(name)) {
                    MethodVisitor proxyCode = this.m_proxyCv.visitMethod(access + 4096, "<init>", desc, signature, exceptions);
                    proxyCode.visitVarInsn(25, 0);
                    AsmHelper.loadArgumentTypes(proxyCode, Type.getArgumentTypes(desc), false);
                    proxyCode.visitMethodInsn(183, this.m_className, "<init>", desc);
                    proxyCode.visitInsn(177);
                    proxyCode.visitMaxs(0, 0);
                } else {
                    MethodVisitor proxyCode = this.m_proxyCv.visitMethod(access + 4096, name, desc, signature, exceptions);
                    if (Modifier.isStatic(access)) {
                        AsmHelper.loadArgumentTypes(proxyCode, Type.getArgumentTypes(desc), true);
                        proxyCode.visitMethodInsn(184, this.m_className, name, desc);
                        AsmHelper.addReturnStatement(proxyCode, Type.getReturnType(desc));
                        proxyCode.visitMaxs(0, 0);
                    } else {
                        proxyCode.visitVarInsn(25, 0);
                        AsmHelper.loadArgumentTypes(proxyCode, Type.getArgumentTypes(desc), false);
                        proxyCode.visitMethodInsn(183, this.m_className, name, desc);
                        AsmHelper.addReturnStatement(proxyCode, Type.getReturnType(desc));
                        proxyCode.visitMaxs(0, 0);
                    }
                }
            }
            return AsmNullAdapter.NullMethodAdapter.NULL_METHOD_ADAPTER;
        }
    }
}

