/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;

public class ReflectHelper {
    private static final Method OBJECT_EQUALS;
    private static final Method OBJECT_HASH_CODE;
    private static final Method OBJECT_GET_CLASS;
    private static final Method OBJECT_TO_STRING;
    private static final Method OBJECT_CLONE;
    private static final Method OBJECT_WAIT_1;
    private static final Method OBJECT_WAIT_2;
    private static final Method OBJECT_WAIT_3;
    private static final Method OBJECT_NOTIFY;
    private static final Method OBJECT_NOTIFY_ALL;
    private static final Method OBJECT_FINALIZE;

    private static boolean isDeclaredByInterface(Method method, List interfaceDeclaredMethods) {
        boolean match = false;
        for (Method methodIt : interfaceDeclaredMethods) {
            if (!method.getName().equals(methodIt.getName()) || method.getParameterTypes().length != methodIt.getParameterTypes().length) continue;
            boolean matchArgs = true;
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                Class<?> parameterType = method.getParameterTypes()[i];
                if (parameterType.getName().equals(methodIt.getParameterTypes()[i].getName())) continue;
                matchArgs = false;
                break;
            }
            if (!matchArgs) continue;
            match = true;
            break;
        }
        return match;
    }

    private static boolean isUserDefinedMethod(Method method) {
        return !method.equals(OBJECT_EQUALS) && !method.equals(OBJECT_HASH_CODE) && !method.equals(OBJECT_GET_CLASS) && !method.equals(OBJECT_TO_STRING) && !method.equals(OBJECT_CLONE) && !method.equals(OBJECT_WAIT_1) && !method.equals(OBJECT_WAIT_2) && !method.equals(OBJECT_WAIT_3) && !method.equals(OBJECT_NOTIFY) && !method.equals(OBJECT_NOTIFY_ALL) && !method.getName().startsWith("aw$") && !method.getName().startsWith("aw$original$_AW_$") && !method.getName().startsWith("___AW_");
    }

    public static int getModifiersAsInt(String[] modifiers) {
        int accessFlags = 0;
        for (int i = 0; i < modifiers.length; ++i) {
            if (modifiers[i].equals("abstract")) {
                accessFlags |= 0x400;
                continue;
            }
            if (modifiers[i].equals("final")) {
                accessFlags |= 0x10;
                continue;
            }
            if (modifiers[i].equals("interface")) {
                accessFlags |= 0x200;
                continue;
            }
            if (modifiers[i].equals("native")) {
                accessFlags |= 0x100;
                continue;
            }
            if (modifiers[i].equals("private")) {
                accessFlags |= 2;
                continue;
            }
            if (modifiers[i].equals("protected")) {
                accessFlags |= 4;
                continue;
            }
            if (modifiers[i].equals("public")) {
                accessFlags |= 1;
                continue;
            }
            if (modifiers[i].equals("static")) {
                accessFlags |= 8;
                continue;
            }
            if (modifiers[i].equals("strict")) {
                accessFlags |= 0x800;
                continue;
            }
            if (modifiers[i].equals("synchronized")) {
                accessFlags |= 0x20;
                continue;
            }
            if (modifiers[i].equals("transient")) {
                accessFlags |= 0x80;
                continue;
            }
            if (!modifiers[i].equals("volatile")) continue;
            accessFlags |= 0x40;
        }
        return accessFlags;
    }

    public static int calculateHash(Class klass) {
        return klass.getName().hashCode();
    }

    public static int calculateHash(Method method) {
        int hash = 17;
        hash = 37 * hash + method.getName().hashCode();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> type = method.getParameterTypes()[i];
            hash = 37 * hash + type.getName().hashCode();
        }
        return hash;
    }

    public static int calculateHash(Constructor constructor) {
        int hash = 17;
        hash = 37 * hash + "<init>".hashCode();
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            Class<?> type = constructor.getParameterTypes()[i];
            hash = 37 * hash + type.getName().replace('/', '.').hashCode();
        }
        return hash;
    }

    public static int calculateHash(Field field) {
        int hash = 17;
        hash = 37 * hash + field.getName().hashCode();
        Class<?> type = field.getType();
        hash = 37 * hash + type.getName().hashCode();
        return hash;
    }

    public static Class getPrimitiveClass(String className) {
        if (className.equals("void")) {
            return Void.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getClassSignature(Class cl) {
        StringBuffer sbuf = new StringBuffer();
        while (cl.isArray()) {
            sbuf.append('[');
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            if (cl == Integer.TYPE) {
                sbuf.append('I');
                return sbuf.toString();
            } else if (cl == Byte.TYPE) {
                sbuf.append('B');
                return sbuf.toString();
            } else if (cl == Long.TYPE) {
                sbuf.append('J');
                return sbuf.toString();
            } else if (cl == Float.TYPE) {
                sbuf.append('F');
                return sbuf.toString();
            } else if (cl == Double.TYPE) {
                sbuf.append('D');
                return sbuf.toString();
            } else if (cl == Short.TYPE) {
                sbuf.append('S');
                return sbuf.toString();
            } else if (cl == Character.TYPE) {
                sbuf.append('C');
                return sbuf.toString();
            } else if (cl == Boolean.TYPE) {
                sbuf.append('Z');
                return sbuf.toString();
            } else {
                if (cl != Void.TYPE) throw new InternalError();
                sbuf.append('V');
            }
            return sbuf.toString();
        } else {
            sbuf.append('L' + cl.getName().replace('.', '/') + ';');
        }
        return sbuf.toString();
    }

    public static String getConstructorSignature(Constructor constructor) {
        return ReflectHelper.getMethodSignature(constructor.getParameterTypes(), Void.TYPE);
    }

    public static String getFieldSignature(Field field) {
        return ReflectHelper.getClassSignature(field.getType());
    }

    public static String getMethodSignature(Method method) {
        return ReflectHelper.getMethodSignature(method.getParameterTypes(), method.getReturnType());
    }

    private static String getMethodSignature(Class[] paramTypes, Class retType) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        for (int i = 0; i < paramTypes.length; ++i) {
            sbuf.append(ReflectHelper.getClassSignature(paramTypes[i]));
        }
        sbuf.append(')');
        sbuf.append(ReflectHelper.getClassSignature(retType));
        return sbuf.toString();
    }

    static {
        Class<Object> clazz = Object.class;
        try {
            OBJECT_EQUALS = clazz.getDeclaredMethod("equals", clazz);
            OBJECT_HASH_CODE = clazz.getDeclaredMethod("hashCode", new Class[0]);
            OBJECT_GET_CLASS = clazz.getDeclaredMethod("getClass", new Class[0]);
            OBJECT_CLONE = clazz.getDeclaredMethod("clone", new Class[0]);
            OBJECT_TO_STRING = clazz.getDeclaredMethod("toString", new Class[0]);
            OBJECT_WAIT_1 = clazz.getDeclaredMethod("wait", new Class[0]);
            OBJECT_WAIT_2 = clazz.getDeclaredMethod("wait", Long.TYPE);
            OBJECT_WAIT_3 = clazz.getDeclaredMethod("wait", Long.TYPE, Integer.TYPE);
            OBJECT_NOTIFY = clazz.getDeclaredMethod("notify", new Class[0]);
            OBJECT_NOTIFY_ALL = clazz.getDeclaredMethod("notifyAll", new Class[0]);
            OBJECT_FINALIZE = clazz.getDeclaredMethod("finalize", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new WrappedRuntimeException(e);
        }
    }
}

