/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.aspect.AdviceInfo;
import org.codehaus.aspectwerkz.aspect.AdviceType;
import org.codehaus.aspectwerkz.cflow.CflowCompiler;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.joinpoint.management.AdviceInfoContainer;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Opcodes;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.transform.JoinPointCompiler;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.AdviceMethodInfo;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.AspectInfo;
import org.codehaus.aspectwerkz.transform.inlining.compiler.AbstractJoinPointCompiler;
import org.codehaus.aspectwerkz.transform.inlining.compiler.CompilationInfo;
import org.codehaus.aspectwerkz.transform.inlining.compiler.CompilerInput;
import org.codehaus.aspectwerkz.transform.inlining.spi.AspectModel;

public class AspectWerkzAspectModel
implements AspectModel,
Opcodes,
TransformationConstants {
    protected final List m_customProceedMethodStructs;
    public static final String TYPE = AspectWerkzAspectModel.class.getName();

    public AspectWerkzAspectModel() {
        this.m_customProceedMethodStructs = null;
    }

    private AspectWerkzAspectModel(CompilationInfo.Model compilationModel) {
        this.m_customProceedMethodStructs = new ArrayList(0);
        this.collectCustomProceedMethods(compilationModel, compilationModel.getAdviceInfoContainer());
    }

    public AspectModel getInstance(CompilationInfo.Model compilationModel) {
        return new AspectWerkzAspectModel(compilationModel);
    }

    public String getAspectModelType() {
        return TYPE;
    }

    public void defineAspect(ClassInfo aspectClassInfo, AspectDefinition aspectDef, ClassLoader loader) {
    }

    public AspectModel.AroundClosureClassInfo getAroundClosureClassInfo() {
        if (this.m_customProceedMethodStructs.isEmpty()) {
            return new AspectModel.AroundClosureClassInfo("java/lang/Object", new String[0]);
        }
        HashSet<String> interfaces = new HashSet<String>();
        Iterator it = this.m_customProceedMethodStructs.iterator();
        while (it.hasNext()) {
            MethodInfo methodInfo = ((CustomProceedMethodStruct)it.next()).customProceed;
            interfaces.add(methodInfo.getDeclaringType().getName().replace('.', '/'));
        }
        return new AspectModel.AroundClosureClassInfo("java/lang/Object", interfaces.toArray(new String[0]));
    }

    public void createMandatoryMethods(ClassWriter cw, JoinPointCompiler compiler) {
        this.createCustomProceedMethods(cw, (AbstractJoinPointCompiler)compiler);
    }

    public void createInvocationOfAroundClosureSuperClass(MethodVisitor cv) {
    }

    public void createAndStoreStaticAspectInstantiation(ClassVisitor cw, MethodVisitor cv, AspectInfo aspectInfo, String joinPointClassName) {
        String aspectClassSignature = aspectInfo.getAspectClassSignature();
        String aspectClassName = aspectInfo.getAspectClassName();
        DeploymentModel deploymentModel = aspectInfo.getDeploymentModel();
        if (CflowCompiler.isCflowClass(aspectClassName)) {
            cw.visitField(10, aspectInfo.getAspectFieldName(), aspectClassSignature, null, null);
            cv.visitMethodInsn(184, aspectClassName, "aspectOf", "()" + aspectClassSignature);
            cv.visitFieldInsn(179, joinPointClassName, aspectInfo.getAspectFieldName(), aspectClassSignature);
        } else if (deploymentModel.equals(DeploymentModel.PER_JVM)) {
            cw.visitField(10, aspectInfo.getAspectFieldName(), aspectClassSignature, null, null);
            cv.visitMethodInsn(184, aspectInfo.getAspectFactoryClassName(), "aspectOf", "()" + aspectClassSignature);
            cv.visitFieldInsn(179, joinPointClassName, aspectInfo.getAspectFieldName(), aspectClassSignature);
        } else if (deploymentModel.equals(DeploymentModel.PER_CLASS)) {
            cw.visitField(10, aspectInfo.getAspectFieldName(), aspectClassSignature, null, null);
            cv.visitFieldInsn(178, joinPointClassName, "THIS_CLASS", "Ljava/lang/Class;");
            cv.visitMethodInsn(184, aspectInfo.getAspectFactoryClassName(), "aspectOf", "(Ljava/lang/Class;)" + aspectClassSignature);
            cv.visitFieldInsn(179, joinPointClassName, aspectInfo.getAspectFieldName(), aspectClassSignature);
        } else if (AbstractJoinPointCompiler.requiresCallerOrCallee(deploymentModel)) {
            cw.visitField(2, aspectInfo.getAspectFieldName(), aspectClassSignature, null, null);
        } else {
            throw new UnsupportedOperationException("unsupported deployment model - " + aspectInfo.getAspectClassName() + " " + deploymentModel);
        }
    }

    public void createAndStoreRuntimeAspectInstantiation(MethodVisitor cv, CompilerInput input, AspectInfo aspectInfo) {
        if (!DeploymentModel.PER_INSTANCE.equals(aspectInfo.getDeploymentModel())) {
            if (DeploymentModel.PER_THIS.equals(aspectInfo.getDeploymentModel()) && input.callerIndex >= 0) {
                Label hasAspectCheck = this.pushPerXCondition(cv, input.callerIndex, aspectInfo);
                this.storeAspectInstance(cv, input, aspectInfo, input.callerIndex);
                cv.visitLabel(hasAspectCheck);
            } else if (DeploymentModel.PER_TARGET.equals(aspectInfo.getDeploymentModel()) && input.calleeIndex >= 0) {
                Label hasAspectCheck = this.pushPerXCondition(cv, input.calleeIndex, aspectInfo);
                this.storeAspectInstance(cv, input, aspectInfo, input.calleeIndex);
                cv.visitLabel(hasAspectCheck);
            }
        }
        if (aspectInfo.getDeploymentModel() == DeploymentModel.PER_INSTANCE) {
            AbstractJoinPointCompiler.loadJoinPointInstance(cv, input);
            if (input.callerIndex >= 0) {
                cv.visitVarInsn(25, input.callerIndex);
            }
            cv.visitMethodInsn(184, aspectInfo.getAspectFactoryClassName(), "aspectOf", "(Ljava/lang/Object;)" + aspectInfo.getAspectClassSignature());
            cv.visitFieldInsn(181, input.joinPointClassName, aspectInfo.getAspectFieldName(), aspectInfo.getAspectClassSignature());
        }
    }

    public void loadAspect(MethodVisitor cv, CompilerInput input, AspectInfo aspectInfo) {
        DeploymentModel deploymentModel = aspectInfo.getDeploymentModel();
        if (DeploymentModel.PER_JVM.equals(deploymentModel) || DeploymentModel.PER_CLASS.equals(deploymentModel)) {
            cv.visitFieldInsn(178, input.joinPointClassName, aspectInfo.getAspectFieldName(), aspectInfo.getAspectClassSignature());
        } else if (DeploymentModel.PER_INSTANCE.equals(deploymentModel)) {
            AbstractJoinPointCompiler.loadJoinPointInstance(cv, input);
            cv.visitFieldInsn(180, input.joinPointClassName, aspectInfo.getAspectFieldName(), aspectInfo.getAspectClassSignature());
        } else if (DeploymentModel.PER_THIS.equals(deploymentModel)) {
            AbstractJoinPointCompiler.loadJoinPointInstance(cv, input);
            cv.visitFieldInsn(180, input.joinPointClassName, aspectInfo.getAspectFieldName(), aspectInfo.getAspectClassSignature());
            Label nullCheck = new Label();
            cv.visitJumpInsn(199, nullCheck);
            this.storeAspectInstance(cv, input, aspectInfo, input.callerIndex);
            cv.visitLabel(nullCheck);
            AbstractJoinPointCompiler.loadJoinPointInstance(cv, input);
            cv.visitFieldInsn(180, input.joinPointClassName, aspectInfo.getAspectFieldName(), aspectInfo.getAspectClassSignature());
        } else if (DeploymentModel.PER_TARGET.equals(deploymentModel)) {
            AbstractJoinPointCompiler.loadJoinPointInstance(cv, input);
            cv.visitFieldInsn(180, input.joinPointClassName, aspectInfo.getAspectFieldName(), aspectInfo.getAspectClassSignature());
            Label nullCheck = new Label();
            cv.visitJumpInsn(199, nullCheck);
            this.storeAspectInstance(cv, input, aspectInfo, input.calleeIndex);
            cv.visitLabel(nullCheck);
            AbstractJoinPointCompiler.loadJoinPointInstance(cv, input);
            cv.visitFieldInsn(180, input.joinPointClassName, aspectInfo.getAspectFieldName(), aspectInfo.getAspectClassSignature());
        } else {
            throw new DefinitionException("deployment model [" + deploymentModel + "] is not supported");
        }
    }

    public void createAroundAdviceArgumentHandling(MethodVisitor cv, CompilerInput input, Type[] joinPointArgumentTypes, AdviceMethodInfo adviceMethodInfo) {
        AspectWerkzAspectModel.defaultCreateAroundAdviceArgumentHandling(cv, input, joinPointArgumentTypes, adviceMethodInfo);
    }

    public void createBeforeOrAfterAdviceArgumentHandling(MethodVisitor cv, CompilerInput input, Type[] joinPointArgumentTypes, AdviceMethodInfo adviceMethodInfo, int specialArgIndex) {
        AspectWerkzAspectModel.defaultCreateBeforeOrAfterAdviceArgumentHandling(cv, input, joinPointArgumentTypes, adviceMethodInfo, specialArgIndex);
    }

    public boolean requiresReflectiveInfo() {
        return this.m_customProceedMethodStructs.size() > 0;
    }

    private Label pushPerXCondition(MethodVisitor cv, int perInstanceIndex, AspectInfo aspectInfo) {
        Label hasAspectCheck = new Label();
        cv.visitVarInsn(25, perInstanceIndex);
        cv.visitMethodInsn(184, aspectInfo.getAspectFactoryClassName(), "hasAspect", "(Ljava/lang/Object;)Z");
        cv.visitJumpInsn(153, hasAspectCheck);
        return hasAspectCheck;
    }

    private void storeAspectInstance(MethodVisitor cv, CompilerInput input, AspectInfo aspectInfo, int perInstanceIndex) {
        AbstractJoinPointCompiler.loadJoinPointInstance(cv, input);
        if (perInstanceIndex >= 0) {
            cv.visitVarInsn(25, perInstanceIndex);
        }
        cv.visitMethodInsn(184, aspectInfo.getAspectFactoryClassName(), "aspectOf", "(Ljava/lang/Object;)" + aspectInfo.getAspectClassSignature());
        cv.visitFieldInsn(181, input.joinPointClassName, aspectInfo.getAspectFieldName(), aspectInfo.getAspectClassSignature());
    }

    private void createCustomProceedMethods(ClassWriter cw, AbstractJoinPointCompiler compiler) {
        HashSet<String> addedMethodSignatures = new HashSet<String>();
        for (CustomProceedMethodStruct customProceedStruct : this.m_customProceedMethodStructs) {
            MethodInfo methodInfo = customProceedStruct.customProceed;
            String desc = methodInfo.getSignature();
            if (addedMethodSignatures.contains(desc)) continue;
            addedMethodSignatures.add(desc);
            MethodVisitor cv = cw.visitMethod(17, "proceed", desc, null, new String[]{"java/lang/Throwable"});
            int argStackIndex = 1;
            for (int i = 1; i < customProceedStruct.adviceToTargetArgs.length; ++i) {
                int targetArg = customProceedStruct.adviceToTargetArgs[i];
                if (targetArg >= 0) {
                    String fieldName = compiler.m_fieldNames[targetArg];
                    cv.visitVarInsn(25, 0);
                    Type type = compiler.m_argumentTypes[targetArg];
                    argStackIndex = AsmHelper.loadType(cv, argStackIndex, type);
                    cv.visitFieldInsn(181, compiler.m_joinPointClassName, fieldName, type.getDescriptor());
                    continue;
                }
                if (targetArg == -3) {
                    cv.visitVarInsn(25, 0);
                    argStackIndex = AsmHelper.loadType(cv, argStackIndex, Type.getType(compiler.m_calleeClassSignature));
                    cv.visitFieldInsn(181, compiler.m_joinPointClassName, "CALLEE", compiler.m_calleeClassSignature);
                    continue;
                }
                if (targetArg != -4) continue;
                cv.visitVarInsn(25, 0);
                argStackIndex = AsmHelper.loadType(cv, argStackIndex, Type.getType(compiler.m_callerClassSignature));
                cv.visitFieldInsn(181, compiler.m_joinPointClassName, "CALLER", compiler.m_callerClassSignature);
            }
            Type returnType = Type.getType(customProceedStruct.customProceed.getReturnType().getSignature());
            if (AsmHelper.isPrimitive(returnType)) {
                cv.visitVarInsn(25, 0);
                cv.visitMethodInsn(183, compiler.m_joinPointClassName, "proceed", "()Ljava/lang/Object;");
                AsmHelper.unwrapType(cv, returnType);
            } else {
                cv.visitVarInsn(25, 0);
                cv.visitMethodInsn(183, compiler.m_joinPointClassName, "proceed", "()Ljava/lang/Object;");
                if (!returnType.getClassName().equals("Ljava/lang/Object;")) {
                    cv.visitTypeInsn(192, returnType.getInternalName());
                }
            }
            AsmHelper.addReturnStatement(cv, returnType);
            cv.visitMaxs(0, 0);
        }
    }

    private void collectCustomProceedMethods(CompilationInfo.Model model, AdviceInfoContainer advices) {
        ClassLoader loader = model.getThisClassInfo().getClassLoader();
        AdviceInfo[] beforeAdviceInfos = advices.getBeforeAdviceInfos();
        for (int i = 0; i < beforeAdviceInfos.length; ++i) {
            this.collectCustomProceedMethods(beforeAdviceInfos[i], loader);
        }
        AdviceInfo[] aroundAdviceInfos = advices.getAroundAdviceInfos();
        for (int i = 0; i < aroundAdviceInfos.length; ++i) {
            this.collectCustomProceedMethods(aroundAdviceInfos[i], loader);
        }
        AdviceInfo[] afterFinallyAdviceInfos = advices.getAfterFinallyAdviceInfos();
        for (int i = 0; i < afterFinallyAdviceInfos.length; ++i) {
            this.collectCustomProceedMethods(afterFinallyAdviceInfos[i], loader);
        }
        AdviceInfo[] afterReturningAdviceInfos = advices.getAfterReturningAdviceInfos();
        for (int i = 0; i < afterReturningAdviceInfos.length; ++i) {
            this.collectCustomProceedMethods(afterReturningAdviceInfos[i], loader);
        }
        AdviceInfo[] afterThrowingAdviceInfos = advices.getAfterThrowingAdviceInfos();
        for (int i = 0; i < afterThrowingAdviceInfos.length; ++i) {
            this.collectCustomProceedMethods(afterThrowingAdviceInfos[i], loader);
        }
    }

    private void collectCustomProceedMethods(AdviceInfo adviceInfo, ClassLoader loader) {
        ClassInfo classInfo;
        Type firstParam;
        Type[] paramTypes = adviceInfo.getMethodParameterTypes();
        if (paramTypes.length != 0 && (firstParam = paramTypes[0]).getSort() == 10 && !firstParam.getClassName().equals("org.codehaus.aspectwerkz.joinpoint.JoinPoint") && !firstParam.getClassName().equals("org.codehaus.aspectwerkz.joinpoint.StaticJoinPoint") && (ClassInfoHelper.implementsInterface(classInfo = AsmClassInfo.getClassInfo(firstParam.getClassName(), loader), "org.codehaus.aspectwerkz.joinpoint.JoinPoint") || ClassInfoHelper.implementsInterface(classInfo, "org.codehaus.aspectwerkz.joinpoint.StaticJoinPoint"))) {
            MethodInfo[] methods = classInfo.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                MethodInfo method = methods[j];
                if (!method.getName().equals("proceed")) continue;
                this.m_customProceedMethodStructs.add(new CustomProceedMethodStruct(method, adviceInfo.getMethodToArgIndexes()));
            }
        }
    }

    public static void defaultCreateBeforeOrAfterAdviceArgumentHandling(MethodVisitor cv, CompilerInput input, Type[] joinPointArgumentTypes, AdviceMethodInfo adviceMethodInfo, int specialArgIndex) {
        int[] argIndexes = adviceMethodInfo.getAdviceMethodArgIndexes();
        for (int j = 0; j < argIndexes.length; ++j) {
            Type argumentType;
            int argIndex = argIndexes[j];
            if (argIndex >= 0) {
                argumentType = joinPointArgumentTypes[argIndex];
                int argStackIndex = AsmHelper.getRegisterIndexOf(joinPointArgumentTypes, argIndex) + input.argStartIndex;
                AsmHelper.loadType(cv, argStackIndex, argumentType);
                continue;
            }
            if (argIndex == -1 || argIndex == -2) {
                AbstractJoinPointCompiler.loadJoinPointInstance(cv, input);
                continue;
            }
            if (argIndex == -3) {
                AbstractJoinPointCompiler.loadCallee(cv, input);
                if (!adviceMethodInfo.getAdviceInfo().hasTargetWithRuntimeCheck()) continue;
                cv.visitTypeInsn(192, adviceMethodInfo.getAdviceInfo().getMethodParameterTypes()[j].getInternalName());
                continue;
            }
            if (argIndex == -4) {
                AbstractJoinPointCompiler.loadCaller(cv, input);
                continue;
            }
            if (argIndex == -6 && specialArgIndex != -1) {
                argumentType = adviceMethodInfo.getAdviceInfo().getMethodParameterTypes()[j];
                AsmHelper.loadType(cv, specialArgIndex, argumentType);
                if (!AdviceType.AFTER_THROWING.equals(adviceMethodInfo.getAdviceInfo().getAdviceDefinition().getType()) && !AdviceType.AFTER_RETURNING.equals(adviceMethodInfo.getAdviceInfo().getAdviceDefinition().getType())) continue;
                cv.visitTypeInsn(192, argumentType.getInternalName());
                continue;
            }
            throw new Error("magic index is not supported: " + argIndex);
        }
    }

    public static void defaultCreateAroundAdviceArgumentHandling(MethodVisitor cv, CompilerInput input, Type[] joinPointArgumentTypes, AdviceMethodInfo adviceMethodInfo) {
        int[] argIndexes = adviceMethodInfo.getAdviceMethodArgIndexes();
        for (int j = 0; j < argIndexes.length; ++j) {
            int argIndex = argIndexes[j];
            if (argIndex >= 0) {
                Type argumentType = joinPointArgumentTypes[argIndex];
                cv.visitVarInsn(25, 0);
                cv.visitFieldInsn(180, input.joinPointClassName, "ARGUMENT_" + argIndex, argumentType.getDescriptor());
                continue;
            }
            if (argIndex == -1 || argIndex == -2 || argIndex == -5 || argIndex == -7) {
                cv.visitVarInsn(25, 0);
                continue;
            }
            if (argIndex == -3) {
                AbstractJoinPointCompiler.loadCallee(cv, input);
                if (!adviceMethodInfo.getAdviceInfo().hasTargetWithRuntimeCheck()) continue;
                cv.visitTypeInsn(192, adviceMethodInfo.getAdviceInfo().getMethodParameterTypes()[j].getInternalName());
                continue;
            }
            if (argIndex == -4) {
                AbstractJoinPointCompiler.loadCaller(cv, input);
                continue;
            }
            throw new Error("advice method argument index type is not supported: " + argIndex);
        }
    }

    private static class CustomProceedMethodStruct {
        MethodInfo customProceed;
        int[] adviceToTargetArgs;

        public CustomProceedMethodStruct(MethodInfo customProceed, int[] adviceToTargetArgs) {
            this.customProceed = customProceed;
            this.adviceToTargetArgs = adviceToTargetArgs;
        }
    }
}

