/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.org.objectweb.asm.AnnotationVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.TransformationUtil;
import org.codehaus.aspectwerkz.transform.inlining.AsmCopyAdapter;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AlreadyAddedMethodAdapter;

public class MethodExecutionVisitor
extends ClassAdapter
implements TransformationConstants {
    private final ClassInfo m_classInfo;
    private final ContextImpl m_ctx;
    private String m_declaringTypeName;
    private final Set m_addedMethods;

    public MethodExecutionVisitor(ClassVisitor cv, ClassInfo classInfo, Context ctx, Set addedMethods) {
        super(cv);
        this.m_classInfo = classInfo;
        this.m_ctx = (ContextImpl)ctx;
        this.m_addedMethods = addedMethods;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.m_declaringTypeName = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name) || "<clinit>".equals(name) || name.startsWith("___AW_") || name.startsWith("aw$") || name.startsWith("aw$") || "aw_addAdvice".equals(name) && "(Ljava/lang/String;Lorg/codehaus/aspectwerkz/intercept/Advice;)V".equals(desc) || "aw_removeAdvice".equals(name) && "(Ljava/lang/String;Ljava/lang/Class;)V".equals(desc)) {
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
        int hash = AsmHelper.calculateMethodHash(name, desc);
        MethodInfo methodInfo = this.m_classInfo.getMethod(hash);
        if (methodInfo == null) {
            System.err.println("AW::WARNING metadata structure could not be build for method [" + this.m_classInfo.getName().replace('/', '.') + '.' + name + ':' + desc + ']');
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
        ExpressionContext ctx = new ExpressionContext(PointcutType.EXECUTION, methodInfo, methodInfo);
        if (MethodExecutionVisitor.methodFilter(this.m_ctx.getDefinitions(), ctx, methodInfo)) {
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
        String prefixedOriginalName = TransformationUtil.getPrefixedOriginalMethodName(name, this.m_declaringTypeName);
        if (this.m_addedMethods.contains(AlreadyAddedMethodAdapter.getMethodKey(prefixedOriginalName, desc))) {
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
        this.m_ctx.markAsAdvised();
        final MethodVisitor proxyMethod = this.createProxyMethod(access, name, desc, signature, exceptions, methodInfo);
        int modifiers = 4096;
        if (Modifier.isStatic(access)) {
            modifiers |= 8;
        }
        return new MethodAdapter(this.cv.visitMethod(modifiers, prefixedOriginalName, desc, signature, exceptions)){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return new AsmCopyAdapter.CopyAnnotationAdapter(super.visitAnnotation(desc, visible), proxyMethod.visitAnnotation(desc, visible));
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                return new AsmCopyAdapter.CopyAnnotationAdapter(super.visitParameterAnnotation(parameter, desc, visible), proxyMethod.visitParameterAnnotation(parameter, desc, visible));
            }

            public void visitAttribute(Attribute attr) {
                super.visitAttribute(attr);
                proxyMethod.visitAttribute(attr);
            }
        };
    }

    private MethodVisitor createProxyMethod(int access, String name, String desc, String signature, String[] exceptions, MethodInfo methodInfo) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (!Modifier.isStatic(access)) {
            mv.visitVarInsn(25, 0);
        }
        AsmHelper.loadArgumentTypes(mv, Type.getArgumentTypes(desc), Modifier.isStatic(access));
        if (Modifier.isStatic(access)) {
            mv.visitInsn(1);
        } else {
            mv.visitVarInsn(25, 0);
        }
        int joinPointHash = AsmHelper.calculateMethodHash(name, desc);
        String joinPointClassName = TransformationUtil.getJoinPointClassName(this.m_declaringTypeName, name, desc, this.m_declaringTypeName, 1, joinPointHash);
        mv.visitMethodInsn(184, joinPointClassName, "invoke", TransformationUtil.getInvokeSignatureForCodeJoinPoints(access, desc, this.m_declaringTypeName, this.m_declaringTypeName));
        AsmHelper.addReturnStatement(mv, Type.getReturnType(desc));
        mv.visitMaxs(0, 0);
        this.m_ctx.addEmittedJoinPoint(new EmittedJoinPoint(1, this.m_declaringTypeName, name, desc, access, this.m_declaringTypeName, name, desc, access, joinPointHash, joinPointClassName, EmittedJoinPoint.NO_LINE_NUMBER));
        return mv;
    }

    public static boolean methodFilter(Set definitions, ExpressionContext ctx, MethodInfo methodInfo) {
        if (Modifier.isAbstract(methodInfo.getModifiers()) || Modifier.isNative(methodInfo.getModifiers()) || methodInfo.getName().equals("<init>") || methodInfo.getName().equals("<clinit>") || methodInfo.getName().startsWith("aw$original$_AW_$")) {
            return true;
        }
        Iterator it = definitions.iterator();
        while (it.hasNext()) {
            if (!((SystemDefinition)it.next()).hasPointcut(ctx)) continue;
            return false;
        }
        return true;
    }
}

