/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.reader.bytecode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AnnotationElement
implements Serializable {
    public static final String DEFAULT_VALUE_NAME = "value";

    public static interface NestedAnnotationElement {
        public void addElement(String var1, Object var2);

        public List getElements();
    }

    public static class Enum
    extends AnnotationElement {
        static final long serialVersionUID = 1136400223420236391L;
        private final String m_desc;
        private final String m_value;

        public Enum(String desc, String value) {
            this.m_desc = desc;
            this.m_value = value;
        }

        public String getDesc() {
            return this.m_desc;
        }

        public String getValue() {
            return this.m_value;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.m_desc.substring(1, this.m_desc.length() - 1).replace('/', '.'));
            buf.append('.');
            buf.append(this.m_value);
            return buf.toString();
        }
    }

    public static class NamedValue
    extends AnnotationElement {
        static final long serialVersionUID = 4284696449802391088L;
        private final String m_name;
        private final Object m_value;
        private final Type m_type;
        private boolean m_isResolved = false;
        private Object m_resolvedValue;

        public NamedValue(String name, Object value) {
            this.m_name = name == null ? AnnotationElement.DEFAULT_VALUE_NAME : name;
            this.m_value = value;
            if (value instanceof Enum) {
                this.m_type = Type.ENUM;
            } else if (value instanceof Byte) {
                this.m_type = Type.BYTE;
            } else if (value instanceof Boolean) {
                this.m_type = Type.BOOLEAN;
            } else if (value instanceof Character) {
                this.m_type = Type.CHAR;
            } else if (value instanceof Short) {
                this.m_type = Type.SHORT;
            } else if (value instanceof Integer) {
                this.m_type = Type.INTEGER;
            } else if (value instanceof Long) {
                this.m_type = Type.LONG;
            } else if (value instanceof Float) {
                this.m_type = Type.FLOAT;
            } else if (value instanceof Double) {
                this.m_type = Type.DOUBLE;
            } else if (value instanceof String) {
                this.m_type = Type.STRING;
            } else if (value instanceof org.codehaus.backport175.org.objectweb.asm.Type) {
                this.m_type = Type.TYPE;
            } else if (value instanceof Array) {
                this.m_type = Type.ARRAY;
            } else if (value instanceof Annotation) {
                this.m_type = Type.ANNOTATION;
            } else {
                throw new IllegalArgumentException("not valid type for named value in annotation [" + value.toString() + "]");
            }
        }

        public String getName() {
            return this.m_name;
        }

        public Object getValue() {
            return this.m_value;
        }

        public Type getType() {
            return this.m_type;
        }

        public void setResolvedValue(Object value) {
            this.m_isResolved = true;
            this.m_resolvedValue = value;
        }

        public boolean isResolved() {
            return this.m_isResolved;
        }

        public Object getResolvedValue() {
            return this.m_resolvedValue;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (!this.m_name.equals(AnnotationElement.DEFAULT_VALUE_NAME)) {
                buf.append(this.m_name);
                buf.append('=');
            }
            if (this.m_type.equals(Type.TYPE)) {
                buf.append(((org.codehaus.backport175.org.objectweb.asm.Type)this.m_value).getClassName()).append(".class");
            } else {
                buf.append(this.m_value);
            }
            return buf.toString();
        }
    }

    public static class Array
    extends AnnotationElement
    implements NestedAnnotationElement {
        static final long serialVersionUID = -6792525450471409048L;
        private final List m_elements = new ArrayList();

        public void addElement(String name, Object element) {
            this.m_elements.add(new NamedValue(AnnotationElement.DEFAULT_VALUE_NAME, element));
        }

        public List getElements() {
            return this.m_elements;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("[");
            Iterator it = this.m_elements.iterator();
            while (it.hasNext()) {
                NamedValue namedValue = (NamedValue)it.next();
                buf.append(namedValue.toString());
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(']');
            return buf.toString();
        }
    }

    public static class Annotation
    extends AnnotationElement
    implements NestedAnnotationElement {
        static final long serialVersionUID = 8769673036736880936L;
        private final String m_className;
        private final List m_elements = new ArrayList();

        public Annotation(String className) {
            this.m_className = className;
        }

        public void addElement(String name, Object element) {
            this.m_elements.add(new NamedValue(name, element));
        }

        public String getInterfaceName() {
            return this.m_className;
        }

        public List getElements() {
            return this.m_elements;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            Iterator it = this.m_elements.iterator();
            while (it.hasNext()) {
                NamedValue namedValue = (NamedValue)it.next();
                buf.append(namedValue.toString());
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
            return buf.toString();
        }

        public void mergeDefaultedElement(NamedValue defaultedElement) {
            Iterator iterator = this.m_elements.iterator();
            while (iterator.hasNext()) {
                NamedValue namedValue = (NamedValue)iterator.next();
                if (!namedValue.getName().equals(defaultedElement.getName())) continue;
                return;
            }
            this.m_elements.add(defaultedElement);
        }
    }

    public static final class Type {
        public static final Type ANNOTATION = new Type("ANNOTATION");
        public static final Type ARRAY = new Type("ARRAY");
        public static final Type ENUM = new Type("ENUM");
        public static final Type TYPE = new Type("TYPE");
        public static final Type STRING = new Type("STRING");
        public static final Type LONG = new Type("LONG");
        public static final Type INTEGER = new Type("INTEGER");
        public static final Type SHORT = new Type("SHORT");
        public static final Type DOUBLE = new Type("DOUBLE");
        public static final Type FLOAT = new Type("FLOAT");
        public static final Type BYTE = new Type("BYTE");
        public static final Type BOOLEAN = new Type("BOOLEAN");
        public static final Type CHAR = new Type("CHAR");
        private final String m_name;

        private Type(String name) {
            this.m_name = name;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

