/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;

public class HazelcastComponentHelper {
    private final HashMap<String, Integer> mapping = new HashMap();

    public HazelcastComponentHelper() {
        this.init();
    }

    public static void copyHeaders(Exchange ex) {
        Map headers = ex.getIn().getHeaders();
        if (headers.containsKey("hazelcast.objectId")) {
            headers.remove("hazelcast.objectId");
        }
        if (headers.containsKey("hazelcast.operation.type")) {
            headers.remove("hazelcast.operation.type");
        }
        ex.getOut().setHeaders(headers);
    }

    public static void setListenerHeaders(Exchange ex, String listenerType, String listenerAction, String cacheName) {
        ex.getOut().setHeader("hazelcast.cache.name", (Object)cacheName);
        HazelcastComponentHelper.setListenerHeaders(ex, listenerType, listenerAction);
    }

    public static void setListenerHeaders(Exchange ex, String listenerType, String listenerAction) {
        ex.getOut().setHeader("hazelcast.listener.action", (Object)listenerAction);
        ex.getOut().setHeader("hazelcast.listener.type", (Object)listenerType);
        ex.getOut().setHeader("hazelcast.listener.time", (Object)new Date().getTime());
    }

    public int lookupOperationNumber(String operation) {
        if (this.mapping.containsKey(operation)) {
            return this.mapping.get(operation);
        }
        throw new IllegalArgumentException(String.format("Operation '%s' is not supported by this component.", operation));
    }

    private void init() {
        this.mapping.put("put", 1);
        this.mapping.put("delete", 2);
        this.mapping.put("get", 3);
        this.mapping.put("update", 4);
        this.mapping.put("query", 5);
        this.mapping.put("removevalue", 10);
        this.mapping.put("increment", 20);
        this.mapping.put("decrement", 21);
        this.mapping.put("setvalue", 22);
        this.mapping.put("destroy", 23);
        this.mapping.put("add", 31);
        this.mapping.put("offer", 32);
        this.mapping.put("peek", 33);
        this.mapping.put("poll", 34);
    }
}

