/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.codehaus.aspectwerkz.aspect.AdviceInfo;
import org.codehaus.aspectwerkz.cflow.CflowBinding;
import org.codehaus.aspectwerkz.cflow.CflowCompiler;
import org.codehaus.aspectwerkz.compiler.CompileException;
import org.codehaus.aspectwerkz.compiler.Utility;
import org.codehaus.aspectwerkz.compiler.VerifierClassLoader;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;
import org.codehaus.aspectwerkz.hook.ClassPreProcessor;
import org.codehaus.aspectwerkz.joinpoint.management.AdviceInfoContainer;
import org.codehaus.aspectwerkz.joinpoint.management.JoinPointManager;
import org.codehaus.aspectwerkz.transform.AspectWerkzPreProcessor;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.util.ContextClassLoader;

public class AspectWerkzC {
    private static final String COMMAND_LINE_OPTION_DASH = "-";
    private static final String COMMAND_LINE_OPTION_VERBOSE = "-verbose";
    private static final String COMMAND_LINE_OPTION_DETAILS = "-details";
    private static final String COMMAND_LINE_OPTION_GENJP = "-genjp";
    private static final String COMMAND_LINE_OPTION_HALT = "-haltOnError";
    private static final String COMMAND_LINE_OPTION_VERIFY = "-verify";
    private static final String COMMAND_LINE_OPTION_CLASSPATH = "-cp";
    private static final String COMMAND_LINE_OPTION_TARGETS = "compile.targets";
    private static final String PRE_PROCESSOR_CLASSNAME_PROPERTY = "aspectwerkz.classloader.preprocessor";
    private static final String AW_TRANSFORM_DETAILS = "aspectwerkz.transform.details";
    private static final String PRE_PROCESSOR_CLASSNAME_DEFAULT = "org.codehaus.aspectwerkz.transform.AspectWerkzPreProcessor";
    private static final String MF_CUSTOM_DATE = "X-AspectWerkzC-created";
    private static final String MF_CUSTOM_PP = "X-AspectWerkzC-preprocessor";
    private static final String MF_CUSTOM_COMMENT = "X-AspectWerkzC-comment";
    private static final String MF_CUSTOM_COMMENT_VALUE = "AspectWerkzC - AspectWerkz compiler, aspectwerkz.codehaus.org";
    private static final SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String BACKUP_DIR = "_aspectwerkzc";
    private boolean verify = false;
    private boolean genJp = false;
    private boolean haltOnError = false;
    private String backupDir = "_aspectwerkzc";
    private URLClassLoader compilationLoader = null;
    private ClassPreProcessor preprocessor = null;
    private boolean isAspectWerkzPreProcessor = false;
    private int sourceIndex = 0;
    private Map backupMap = new HashMap();
    private Map successMap = new HashMap();
    private long timer;
    private Utility utility = new Utility();

    public AspectWerkzC() {
        this.timer = System.currentTimeMillis();
    }

    public void setVerbose(boolean verbose) {
        this.utility.setVerbose(verbose);
    }

    public void setGenJp(boolean genpJp) {
        this.genJp = genpJp;
    }

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public void setDetails(boolean details) {
        if (details) {
            System.setProperty(AW_TRANSFORM_DETAILS, "true");
        }
    }

    public void setBackupDir(String backup) {
        this.backupDir = backup;
    }

    public Utility getUtility() {
        return this.utility;
    }

    public void setPreprocessor(String preprocessor) throws CompileException {
        try {
            Class<?> pp = Class.forName(preprocessor);
            this.preprocessor = (ClassPreProcessor)pp.newInstance();
            this.preprocessor.initialize();
            if (this.preprocessor instanceof AspectWerkzPreProcessor) {
                this.isAspectWerkzPreProcessor = true;
            }
        }
        catch (Exception e) {
            throw new CompileException("failed to instantiate preprocessor " + preprocessor, e);
        }
    }

    public void backup(File source, int index) {
        File dest = new File(this.backupDir + File.separator + index + File.separator + source.getName());
        this.utility.backupFile(source, dest);
        this.backupMap.put(source, dest);
    }

    public void restoreBackup() {
        for (File source : this.backupMap.keySet()) {
            if (this.successMap.containsKey(source)) continue;
            File dest = (File)this.backupMap.get(source);
            this.utility.backupFile(dest, source);
        }
    }

    public void postCompile(String message) {
        this.restoreBackup();
        this.utility.log(" [backup] removing backup");
        this.utility.deleteDir(new File(this.backupDir));
        long ms = Math.max(System.currentTimeMillis() - this.timer, 1000L);
        System.out.println("( " + (int)(ms / 1000L) + " s ) " + message);
        if (!this.haltOnError) {
            for (File source : this.backupMap.keySet()) {
                if (this.successMap.containsKey(source)) {
                    System.out.println("SUCCESS: " + source);
                    continue;
                }
                System.out.println("FAILED : " + source);
            }
        }
    }

    public void doCompile(File sourceFile, String prefixPackage) throws CompileException {
        if (sourceFile.isDirectory()) {
            File[] classes = sourceFile.listFiles();
            for (int i = 0; i < classes.length; ++i) {
                if (classes[i].isDirectory() && !this.backupDir.equals(classes[i].getName())) {
                    String packaging = prefixPackage != null ? prefixPackage + "." + classes[i].getName() : classes[i].getName();
                    this.doCompile(classes[i], packaging);
                    continue;
                }
                if (classes[i].getName().toLowerCase().endsWith(".class")) {
                    this.compileClass(classes[i], prefixPackage);
                    continue;
                }
                if (!AspectWerkzC.isJarFile(classes[i])) continue;
                this.compileJar(classes[i]);
            }
        } else if (sourceFile.getName().toLowerCase().endsWith(".class")) {
            this.compileClass(sourceFile, null);
        } else if (AspectWerkzC.isJarFile(sourceFile)) {
            this.compileJar(sourceFile);
        }
    }

    public void compileClass(File file, String packaging) throws CompileException {
        block23: {
            InputStream in = null;
            FileOutputStream fos = null;
            try {
                int length;
                this.utility.log(" [compile] " + file.getCanonicalPath());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                in = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                while (in.available() > 0 && (length = in.read(buffer)) != -1) {
                    bos.write(buffer, 0, length);
                }
                String className = file.getName().substring(0, file.getName().length() - 6);
                if (packaging != null) {
                    className = packaging + '.' + className;
                }
                AspectWerkzPreProcessor.Output out = null;
                try {
                    out = this.preProcess(this.preprocessor, className, bos.toByteArray(), this.compilationLoader);
                }
                catch (Throwable t) {
                    throw new CompileException("weaver failed for class: " + className, t);
                }
                fos = new FileOutputStream(file);
                fos.write(out.bytecode);
                fos.close();
                if (out.emittedJoinPoints != null && this.genJp) {
                    for (int i = 0; i < out.emittedJoinPoints.length; ++i) {
                        EmittedJoinPoint emittedJoinPoint = out.emittedJoinPoints[i];
                        String jpClassNoPackage = emittedJoinPoint.getJoinPointClassName();
                        if (jpClassNoPackage.indexOf(47) > 0) {
                            jpClassNoPackage = jpClassNoPackage.substring(jpClassNoPackage.lastIndexOf(47));
                        }
                        File jpFile = new File(file.getParent(), jpClassNoPackage + ".class");
                        this.utility.log(" [genjp] " + jpFile.getCanonicalPath());
                        FileOutputStream jpFos = new FileOutputStream(jpFile);
                        JoinPointManager.CompiledJoinPoint compiledJp = this.compileJoinPoint(emittedJoinPoint, this.compilationLoader);
                        jpFos.write(compiledJp.bytecode);
                        jpFos.close();
                        CflowCompiler.CompiledCflowAspect[] compiledCflowAspects = this.compileCflows(compiledJp);
                        if (compiledCflowAspects.length <= 0) continue;
                        String baseDirAbsolutePath = AspectWerkzC.getBaseDir(file.getCanonicalPath(), className);
                        for (int j = 0; j < compiledCflowAspects.length; ++j) {
                            CflowCompiler.CompiledCflowAspect compiledCflowAspect = compiledCflowAspects[j];
                            File cflowFile = new File(baseDirAbsolutePath + File.separatorChar + compiledCflowAspect.className.replace('/', File.separatorChar) + ".class");
                            new File(cflowFile.getParent()).mkdirs();
                            this.utility.log(" [genjp] (cflow) " + cflowFile.getCanonicalPath());
                            FileOutputStream cflowFos = new FileOutputStream(cflowFile);
                            cflowFos.write(compiledCflowAspect.bytecode);
                            cflowFos.close();
                        }
                    }
                }
                if (!this.verify) break block23;
                VerifierClassLoader verifier = new VerifierClassLoader(this.compilationLoader.getURLs(), ClassLoader.getSystemClassLoader());
                try {
                    this.utility.log(" [verify] " + className);
                    Class.forName(className, false, verifier);
                }
                catch (Throwable t) {
                    this.utility.log(" [verify] corrupted class: " + className);
                    throw new CompileException("corrupted class: " + className, t);
                }
            }
            catch (IOException e) {
                throw new CompileException("compile " + file.getAbsolutePath() + " failed", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable e) {}
                try {
                    fos.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    public void compileJar(File file) throws CompileException {
        this.utility.log(" [compilejar] " + file.getAbsolutePath());
        File workingFile = new File(file.getAbsolutePath() + ".aspectwerkzc");
        if (workingFile.exists()) {
            workingFile.delete();
        }
        ZipFile zip = null;
        ZipOutputStream zos = null;
        try {
            zip = new ZipFile(file);
            zos = new ZipOutputStream(new FileOutputStream(workingFile));
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                int length;
                ZipEntry ze = e.nextElement();
                InputStream in = zip.getInputStream(ze);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while (in.available() > 0 && (length = in.read(buffer)) != -1) {
                    bos.write(buffer, 0, length);
                }
                in.close();
                AspectWerkzPreProcessor.Output out = null;
                byte[] transformed = null;
                if (ze.getName().toLowerCase().endsWith(".class")) {
                    this.utility.log(" [compilejar] compile " + file.getName() + ":" + ze.getName());
                    String className = ze.getName().substring(0, ze.getName().length() - 6);
                    try {
                        out = this.preProcess(this.preprocessor, className, bos.toByteArray(), this.compilationLoader);
                        transformed = out.bytecode;
                    }
                    catch (Throwable t) {
                        throw new CompileException("weaver failed for class: " + className, t);
                    }
                } else {
                    out = null;
                    transformed = bos.toByteArray();
                }
                if (ze.getName().toLowerCase().equals("meta-inf/manifest.mf")) {
                    try {
                        Manifest mf = new Manifest(new ByteArrayInputStream(transformed));
                        Attributes at = mf.getMainAttributes();
                        at.putValue(MF_CUSTOM_DATE, DF.format(new Date()));
                        at.putValue(MF_CUSTOM_PP, this.preprocessor.getClass().getName());
                        at.putValue(MF_CUSTOM_COMMENT, MF_CUSTOM_COMMENT_VALUE);
                        bos.reset();
                        mf.write(bos);
                        transformed = bos.toByteArray();
                    }
                    catch (Exception emf) {
                        emf.printStackTrace();
                    }
                }
                ZipEntry transformedZe = new ZipEntry(ze.getName());
                transformedZe.setSize(transformed.length);
                CRC32 crc = new CRC32();
                crc.update(transformed);
                transformedZe.setCrc(crc.getValue());
                transformedZe.setMethod(ze.getMethod());
                zos.putNextEntry(transformedZe);
                zos.write(transformed, 0, transformed.length);
                if (!this.genJp || out == null || out.emittedJoinPoints == null) continue;
                for (int i = 0; i < out.emittedJoinPoints.length; ++i) {
                    EmittedJoinPoint emittedJoinPoint = out.emittedJoinPoints[i];
                    JoinPointManager.CompiledJoinPoint compiledJp = this.compileJoinPoint(emittedJoinPoint, this.compilationLoader);
                    this.utility.log(" [compilejar] (genjp) " + file.getName() + ":" + emittedJoinPoint.getJoinPointClassName());
                    ZipEntry jpZe = new ZipEntry(emittedJoinPoint.getJoinPointClassName() + ".class");
                    jpZe.setSize(compiledJp.bytecode.length);
                    CRC32 jpCrc = new CRC32();
                    jpCrc.update(compiledJp.bytecode);
                    jpZe.setCrc(jpCrc.getValue());
                    jpZe.setMethod(ze.getMethod());
                    zos.putNextEntry(jpZe);
                    zos.write(compiledJp.bytecode, 0, compiledJp.bytecode.length);
                    CflowCompiler.CompiledCflowAspect[] compiledCflowAspects = this.compileCflows(compiledJp);
                    if (compiledCflowAspects.length <= 0) continue;
                    for (int j = 0; j < compiledCflowAspects.length; ++j) {
                        CflowCompiler.CompiledCflowAspect compiledCflowAspect = compiledCflowAspects[j];
                        this.utility.log(" [compilejar] (genjp) (cflow) " + file.getName() + ":" + compiledCflowAspect.className);
                        ZipEntry cflowZe = new ZipEntry(compiledCflowAspect.className + ".class");
                        cflowZe.setSize(compiledCflowAspect.bytecode.length);
                        CRC32 cflowCrc = new CRC32();
                        cflowCrc.update(compiledCflowAspect.bytecode);
                        cflowZe.setCrc(cflowCrc.getValue());
                        cflowZe.setMethod(ze.getMethod());
                        zos.putNextEntry(cflowZe);
                        zos.write(compiledCflowAspect.bytecode, 0, compiledCflowAspect.bytecode.length);
                    }
                }
            }
            zip.close();
            zos.close();
            File swap = new File(file.getAbsolutePath() + ".swap.aspectwerkzc");
            this.utility.backupFile(file, swap);
            try {
                this.utility.backupFile(workingFile, new File(file.getAbsolutePath()));
                workingFile.delete();
                swap.delete();
            }
            catch (Exception e2) {
                this.utility.backupFile(swap, new File(file.getAbsolutePath()));
                workingFile.delete();
                throw new CompileException("compile " + file.getAbsolutePath() + " failed", e2);
            }
        }
        catch (IOException e) {
            throw new CompileException("compile " + file.getAbsolutePath() + " failed", e);
        }
        finally {
            try {
                zos.close();
            }
            catch (Throwable e) {}
            try {
                zip.close();
            }
            catch (Throwable e) {}
        }
    }

    public boolean compile(File source) {
        ++this.sourceIndex;
        this.backup(source, this.sourceIndex);
        try {
            this.doCompile(source, null);
        }
        catch (CompileException e) {
            this.utility.log(" [aspectwerkzc] compilation encountered an error");
            e.printStackTrace();
            return !this.haltOnError;
        }
        this.successMap.put(source, Boolean.TRUE);
        return true;
    }

    public void setCompilationPath(File[] targets, ClassLoader parentLoader) {
        URL[] urls = new URL[targets.length];
        int j = 0;
        for (int i = 0; i < targets.length; ++i) {
            try {
                urls[j] = targets[i].getCanonicalFile().toURL();
                ++j;
                continue;
            }
            catch (IOException e) {
                System.err.println("bad target " + targets[i]);
            }
        }
        this.compilationLoader = new URLClassLoader(urls, parentLoader);
    }

    public static boolean isJarFile(File source) {
        return source.isFile() && (source.getName().toLowerCase().endsWith(".jar") || source.getName().toLowerCase().endsWith(".zip"));
    }

    public static void doHelp() {
        System.out.println("--- AspectWerkzC compiler ---");
        System.out.println("Usage:");
        System.out.println("java -cp ... org.codehaus.aspectwerkz.compiler.AspectWerkzC [-verbose] [-haltOnError] [-verify]  <target 1> .. <target n>");
        System.out.println("  <target i> : exploded dir, jar, zip files to compile");
    }

    private static AspectWerkzC createCompiler(Map params) {
        AspectWerkzC compiler = new AspectWerkzC();
        for (Map.Entry param : params.entrySet()) {
            if (COMMAND_LINE_OPTION_VERBOSE.equals(param.getKey())) {
                compiler.setVerbose(Boolean.TRUE.equals(param.getValue()));
                continue;
            }
            if (COMMAND_LINE_OPTION_HALT.equals(param.getKey())) {
                compiler.setHaltOnError(Boolean.TRUE.equals(param.getValue()));
                continue;
            }
            if (COMMAND_LINE_OPTION_VERIFY.equals(param.getKey())) {
                compiler.setVerify(Boolean.TRUE.equals(param.getValue()));
                continue;
            }
            if (COMMAND_LINE_OPTION_GENJP.equals(param.getKey())) {
                compiler.setGenJp(Boolean.TRUE.equals(param.getValue()));
                continue;
            }
            if (!COMMAND_LINE_OPTION_DETAILS.equals(param.getKey())) continue;
            compiler.setDetails(Boolean.TRUE.equals(param.getValue()));
        }
        return compiler;
    }

    public static void compile(AspectWerkzC compiler, ClassLoader classLoader, String preProcessor, List classpath, List targets) {
        ArrayList fullPath = new ArrayList();
        if (classpath != null) {
            fullPath.addAll(classpath);
        }
        fullPath.addAll(targets);
        compiler.setCompilationPath(fullPath.toArray(new File[fullPath.size()]), classLoader);
        Thread.currentThread().setContextClassLoader(compiler.compilationLoader);
        SystemDefinitionContainer.disableSystemWideDefinition();
        SystemDefinitionContainer.deployDefinitions(compiler.compilationLoader, DefinitionLoader.getDefaultDefinition(compiler.compilationLoader));
        String preprocessorFqn = preProcessor == null ? PRE_PROCESSOR_CLASSNAME_DEFAULT : preProcessor;
        try {
            compiler.setPreprocessor(preprocessorFqn);
        }
        catch (CompileException e) {
            System.err.println("Cannot instantiate ClassPreProcessor: " + preprocessorFqn);
            e.printStackTrace();
            System.exit(-1);
        }
        AspectWerkzC.cleanBackupDir(compiler);
        Iterator i = targets.iterator();
        while (i.hasNext()) {
            if (compiler.compile((File)i.next())) continue;
            compiler.postCompile("*** An error occured ***");
            System.exit(-1);
        }
        compiler.postCompile("");
    }

    private static void cleanBackupDir(AspectWerkzC compiler) {
        try {
            File temp = new File(compiler.backupDir);
            if (temp.exists()) {
                compiler.getUtility().deleteDir(temp);
            }
            temp.mkdir();
            new File(temp, "" + System.currentTimeMillis() + ".timestamp").createNewFile();
        }
        catch (Exception e) {
            System.err.println("failed to prepare backup dir: " + compiler.backupDir);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            AspectWerkzC.doHelp();
            return;
        }
        Map options = AspectWerkzC.parseOptions(args);
        AspectWerkzC compiler = AspectWerkzC.createCompiler(options);
        compiler.setBackupDir(BACKUP_DIR);
        AspectWerkzC.compile(compiler, ClassLoader.getSystemClassLoader(), System.getProperty(PRE_PROCESSOR_CLASSNAME_PROPERTY, PRE_PROCESSOR_CLASSNAME_DEFAULT), (List)options.get(COMMAND_LINE_OPTION_CLASSPATH), (List)options.get(COMMAND_LINE_OPTION_TARGETS));
    }

    private static Map parseOptions(String[] args) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        ArrayList<File> targets = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            if (COMMAND_LINE_OPTION_VERBOSE.equals(args[i])) {
                options.put(COMMAND_LINE_OPTION_VERBOSE, Boolean.TRUE);
                continue;
            }
            if (COMMAND_LINE_OPTION_GENJP.equals(args[i])) {
                options.put(COMMAND_LINE_OPTION_GENJP, Boolean.TRUE);
                continue;
            }
            if (COMMAND_LINE_OPTION_DETAILS.equals(args[i])) {
                options.put(COMMAND_LINE_OPTION_DETAILS, Boolean.TRUE);
                continue;
            }
            if (COMMAND_LINE_OPTION_HALT.equals(args[i])) {
                options.put(COMMAND_LINE_OPTION_HALT, Boolean.TRUE);
                continue;
            }
            if (COMMAND_LINE_OPTION_VERIFY.equals(args[i])) {
                options.put(COMMAND_LINE_OPTION_VERIFY, Boolean.TRUE);
                continue;
            }
            if (COMMAND_LINE_OPTION_CLASSPATH.equals(args[i])) {
                if (i == args.length - 1) continue;
                options.put(COMMAND_LINE_OPTION_CLASSPATH, AspectWerkzC.toFileArray(args[++i], File.pathSeparator));
                continue;
            }
            if (args[i].startsWith(COMMAND_LINE_OPTION_DASH)) continue;
            File file = AspectWerkzC.toFile(args[i]);
            if (file == null) {
                System.err.println("Ignoring inexistant target: " + args[i]);
                continue;
            }
            targets.add(file);
        }
        options.put(COMMAND_LINE_OPTION_TARGETS, targets);
        return options;
    }

    private static List toFileArray(String str, String sep) {
        if (str == null || str.length() == 0) {
            return new ArrayList();
        }
        ArrayList<File> files = new ArrayList<File>();
        int start = 0;
        int idx = str.indexOf(sep, start);
        int len = sep.length();
        while (idx != -1) {
            files.add(new File(str.substring(start, idx)));
            start = idx + len;
            idx = str.indexOf(sep, start);
        }
        files.add(new File(str.substring(start)));
        return files;
    }

    private static File toFile(String path) {
        File file = new File(path);
        return file.exists() ? file : null;
    }

    private AspectWerkzPreProcessor.Output preProcess(ClassPreProcessor preProcessor, String className, byte[] bytecode, ClassLoader compilationLoader) {
        if (this.isAspectWerkzPreProcessor) {
            return ((AspectWerkzPreProcessor)preProcessor).preProcessWithOutput(className, bytecode, compilationLoader);
        }
        byte[] newBytes = preProcessor.preProcess(className, bytecode, compilationLoader);
        AspectWerkzPreProcessor.Output out = new AspectWerkzPreProcessor.Output();
        out.bytecode = newBytes;
        return out;
    }

    private JoinPointManager.CompiledJoinPoint compileJoinPoint(EmittedJoinPoint emittedJoinPoint, ClassLoader loader) throws IOException {
        try {
            Class callerClass = ContextClassLoader.forName(emittedJoinPoint.getCallerClassName().replace('/', '.'));
            Class calleeClass = ContextClassLoader.forName(emittedJoinPoint.getCalleeClassName().replace('/', '.'));
            JoinPointManager.CompiledJoinPoint jp = JoinPointManager.compileJoinPoint(emittedJoinPoint.getJoinPointType(), callerClass, emittedJoinPoint.getCallerMethodName(), emittedJoinPoint.getCallerMethodDesc(), emittedJoinPoint.getCallerMethodModifiers(), emittedJoinPoint.getCalleeClassName(), emittedJoinPoint.getCalleeMemberName(), emittedJoinPoint.getCalleeMemberDesc(), emittedJoinPoint.getCalleeMemberModifiers(), emittedJoinPoint.getJoinPointHash(), emittedJoinPoint.getJoinPointClassName(), calleeClass, loader);
            return jp;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not compile joinpoint : " + e.toString());
        }
    }

    private CflowCompiler.CompiledCflowAspect[] compileCflows(JoinPointManager.CompiledJoinPoint jp) {
        ArrayList allCflowBindings = new ArrayList();
        AdviceInfoContainer adviceInfoContainer = jp.compilationInfo.getInitialModel().getAdviceInfoContainer();
        AdviceInfo[] advices = adviceInfoContainer.getAllAdviceInfos();
        for (int i = 0; i < advices.length; ++i) {
            AdviceInfo adviceInfo = advices[i];
            List cflowBindings = CflowBinding.getCflowBindingsForCflowOf(adviceInfo.getExpressionInfo());
            allCflowBindings.addAll(cflowBindings);
        }
        ArrayList<CflowCompiler.CompiledCflowAspect> compiledCflows = new ArrayList<CflowCompiler.CompiledCflowAspect>();
        for (CflowBinding cflowBinding : allCflowBindings) {
            compiledCflows.add(CflowCompiler.compileCflowAspect(cflowBinding.getCflowID()));
        }
        return compiledCflows.toArray(new CflowCompiler.CompiledCflowAspect[0]);
    }

    private static String getBaseDir(String weavedClassFileFullPath, String weavedClassName) {
        String baseDirAbsolutePath = weavedClassFileFullPath;
        int parentEndIndex = baseDirAbsolutePath.lastIndexOf(File.separatorChar);
        for (int j = weavedClassName.toCharArray().length - 1; j >= 0; --j) {
            char c = weavedClassName.toCharArray()[j];
            if (c != '.' || parentEndIndex <= 0) continue;
            baseDirAbsolutePath = baseDirAbsolutePath.substring(0, parentEndIndex);
            parentEndIndex = baseDirAbsolutePath.lastIndexOf(File.separatorChar);
        }
        if (parentEndIndex > 0) {
            baseDirAbsolutePath = baseDirAbsolutePath.substring(0, parentEndIndex);
        }
        return baseDirAbsolutePath;
    }
}

