/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import org.codehaus.aspectwerkz.expression.ExpressionInfo;

public final class DeploymentScope {
    private final String m_name;
    private final String m_expression;
    public static final DeploymentScope MATCH_ALL = new DeploymentScope("___AW_DeploymentScopes", "within(*..*)");

    DeploymentScope(String name, String expression) {
        this.m_name = name;
        this.m_expression = expression;
    }

    public String getName() {
        return this.m_name;
    }

    public String getExpression() {
        return this.m_expression;
    }

    public ExpressionInfo newExpressionInfo(ExpressionInfo expression) {
        return new ExpressionInfo(new StringBuffer().append('(').append(expression.toString()).append(')').append(" && ").append(this.m_expression).toString(), expression.getNamespace());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeploymentScope)) {
            return false;
        }
        DeploymentScope deploymentScope = (DeploymentScope)o;
        if (!this.m_expression.equals(deploymentScope.m_expression)) {
            return false;
        }
        return this.m_name.equals(deploymentScope.m_name);
    }

    public int hashCode() {
        int result = this.m_name.hashCode();
        result = 29 * result + this.m_expression.hashCode();
        return result;
    }
}

