/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook.impl;

import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import org.codehaus.aspectwerkz.hook.ClassPreProcessor;

public class ClassPreProcessorHelper {
    private static ClassPreProcessor preProcessor;
    private static boolean preProcessorInitialized;
    private static String PRE_PROCESSOR_CLASSNAME_PROPERTY;
    private static String PRE_PROCESSOR_CLASSNAME_DEFAULT;
    private static final byte[] EMPTY_BYTEARRAY;
    private static final Class BYTE_ARRAY_CLASS;

    public static ClassPreProcessor getClassPreProcessor() {
        return preProcessor;
    }

    public static synchronized void initializePreProcessor() {
        if (preProcessorInitialized) {
            return;
        }
        preProcessorInitialized = true;
        Class<?> klass = null;
        String s = System.getProperty(PRE_PROCESSOR_CLASSNAME_PROPERTY, PRE_PROCESSOR_CLASSNAME_DEFAULT);
        try {
            klass = Class.forName(s, true, ClassPreProcessor.class.getClassLoader());
        }
        catch (ClassNotFoundException _ex) {
            System.err.println("AspectWerkz - WARN - Pre-processor class '" + s + "' not found");
        }
        if (klass != null) {
            try {
                preProcessor = (ClassPreProcessor)klass.newInstance();
                preProcessor.initialize();
            }
            catch (Throwable throwable) {
                System.err.println("AspectWerkz - WARN - Error initializing pre-processor class " + s + ':');
                throwable.printStackTrace();
            }
        }
    }

    public static byte[] defineClass0Pre(ClassLoader caller, String name, byte[] b, int off, int len, ProtectionDomain pd) {
        if (preProcessor == null) {
            byte[] obyte = new byte[len];
            System.arraycopy(b, off, obyte, 0, len);
            return obyte;
        }
        try {
            byte[] ibyte = new byte[len];
            System.arraycopy(b, off, ibyte, 0, len);
            return preProcessor.preProcess(name, ibyte, caller);
        }
        catch (Throwable throwable) {
            System.err.println("AspectWerkz - WARN - Error pre-processing class " + name + " in " + Thread.currentThread());
            throwable.printStackTrace();
            byte[] obyte = new byte[len];
            System.arraycopy(b, off, obyte, 0, len);
            return obyte;
        }
    }

    public static Object defineClass0Pre(ClassLoader caller, String name, Object byteBuffer, int off, int len, ProtectionDomain pd) {
        byte[] bytes = new byte[len];
        ClassPreProcessorHelper.byteBufferGet(byteBuffer, bytes, off, len);
        byte[] newbytes = ClassPreProcessorHelper.defineClass0Pre(caller, name, bytes, 0, bytes.length, pd);
        Object newBuffer = ClassPreProcessorHelper.byteBufferWrap(newbytes);
        return newBuffer;
    }

    private static void byteBufferGet(Object byteBuffer, byte[] dest, int offset, int length) {
        try {
            Class<?> cByteBuffer = Class.forName("java.nio.ByteBuffer");
            Method mGet = cByteBuffer.getDeclaredMethod("get", BYTE_ARRAY_CLASS, Integer.TYPE, Integer.TYPE);
            mGet.invoke(byteBuffer, dest, new Integer(offset), new Integer(length));
        }
        catch (Throwable t) {
            System.err.println("AW : java.nio not supported");
            throw new RuntimeException(t.toString());
        }
    }

    private static Object byteBufferWrap(byte[] bytes) {
        try {
            Class<?> cByteBuffer = Class.forName("java.nio.ByteBuffer");
            Method mGet = cByteBuffer.getDeclaredMethod("wrap", BYTE_ARRAY_CLASS);
            Object byteBuffer = mGet.invoke(null, new Object[]{bytes});
            return byteBuffer;
        }
        catch (Throwable t) {
            System.err.println("AW : java.nio not supported");
            throw new RuntimeException(t.toString());
        }
    }

    static {
        PRE_PROCESSOR_CLASSNAME_PROPERTY = "aspectwerkz.classloader.preprocessor";
        PRE_PROCESSOR_CLASSNAME_DEFAULT = "org.codehaus.aspectwerkz.transform.AspectWerkzPreProcessor";
        ClassPreProcessorHelper.initializePreProcessor();
        EMPTY_BYTEARRAY = new byte[0];
        BYTE_ARRAY_CLASS = EMPTY_BYTEARRAY.getClass();
    }
}

