/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;

public class ClassInfoHelper {
    private static final ArrayList EMPTY_ARRAY_LIST = new ArrayList();
    private static final String OBJECT_CLASS_NAME = "java.lang.Object";

    public static boolean instanceOf(ClassInfo classInfo, String superclassName) {
        return ClassInfoHelper.implementsInterface(classInfo, superclassName) || ClassInfoHelper.extendsSuperClass(classInfo, superclassName);
    }

    public static boolean implementsInterface(ClassInfo classInfo, String interfaceName) {
        if (classInfo == null || interfaceName == null) {
            return false;
        }
        ClassInfo[] interfaces = classInfo.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            ClassInfo anInterface = interfaces[i];
            if (interfaceName.equals(anInterface.getName())) {
                return true;
            }
            if (!ClassInfoHelper.implementsInterface(anInterface, interfaceName)) continue;
            return true;
        }
        return ClassInfoHelper.implementsInterface(classInfo.getSuperclass(), interfaceName);
    }

    public static boolean extendsSuperClass(ClassInfo classInfo, String className) {
        if (classInfo == null || className == null) {
            return false;
        }
        if (className.equals(classInfo.getName())) {
            return true;
        }
        return ClassInfoHelper.extendsSuperClass(classInfo.getSuperclass(), className);
    }

    public static List createMethodList(ClassInfo klass) {
        if (klass == null) {
            return EMPTY_ARRAY_LIST;
        }
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        MethodInfo[] methodInfos = klass.getMethods();
        for (int i = 0; i < methodInfos.length; ++i) {
            MethodInfo methodInfo = methodInfos[i];
            if (!ClassInfoHelper.isUserDefinedMethod(methodInfo)) continue;
            methods.add(methodInfo);
        }
        ClassInfo superClass = klass.getSuperclass();
        if (!superClass.getName().equals(OBJECT_CLASS_NAME)) {
            List parentMethods = ClassInfoHelper.createMethodList(superClass);
            for (MethodInfo parentMethod : parentMethods) {
                if (methods.contains(parentMethod)) continue;
                methods.add(parentMethod);
            }
        }
        return methods;
    }

    public static List collectMethodsFromInterface(ClassInfo interfaceClassInfo) {
        ArrayList<MethodInfo> interfaceDeclaredMethods = new ArrayList<MethodInfo>();
        List sortedMethodList = ClassInfoHelper.createMethodList(interfaceClassInfo);
        for (MethodInfo methodInfo : sortedMethodList) {
            if (methodInfo.getDeclaringType().getName().equals(OBJECT_CLASS_NAME)) continue;
            interfaceDeclaredMethods.add(methodInfo);
        }
        ClassInfo superClass = interfaceClassInfo.getSuperclass();
        if (superClass != null && !superClass.getName().equals(OBJECT_CLASS_NAME)) {
            interfaceDeclaredMethods.addAll(ClassInfoHelper.collectMethodsFromInterfacesImplementedBy(superClass));
        }
        return interfaceDeclaredMethods;
    }

    public static List collectMethodsFromInterfacesImplementedBy(ClassInfo classInfo) {
        ArrayList<MethodInfo> interfaceDeclaredMethods = new ArrayList<MethodInfo>();
        ClassInfo[] interfaces = classInfo.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            List sortedMethodList = ClassInfoHelper.createMethodList(interfaces[i]);
            for (MethodInfo methodInfo : sortedMethodList) {
                if (methodInfo.getDeclaringType().getName().equals(OBJECT_CLASS_NAME)) continue;
                interfaceDeclaredMethods.add(methodInfo);
            }
        }
        ClassInfo superClass = classInfo.getSuperclass();
        if (superClass != null && !superClass.getName().equals(OBJECT_CLASS_NAME)) {
            interfaceDeclaredMethods.addAll(ClassInfoHelper.collectMethodsFromInterfacesImplementedBy(superClass));
        }
        return interfaceDeclaredMethods;
    }

    public static List createInterfaceDefinedMethodList(ClassInfo klass, List interfaceDeclaredMethods) {
        if (klass == null) {
            throw new IllegalArgumentException("class to sort method on can not be null");
        }
        ArrayList<MethodInfo> methodList = new ArrayList<MethodInfo>();
        for (MethodInfo methodInfo : ClassInfoHelper.createMethodList(klass)) {
            if (!ClassInfoHelper.isDeclaredByInterface(methodInfo, interfaceDeclaredMethods)) continue;
            methodList.add(methodInfo);
        }
        return methodList;
    }

    private static boolean isUserDefinedMethod(MethodInfo method) {
        return !method.getName().startsWith("aw$") && !method.getName().startsWith("aw$original$_AW_$") && !method.getName().startsWith("___AW_");
    }

    private static boolean isDeclaredByInterface(MethodInfo method, List interfaceDeclaredMethods) {
        boolean match = false;
        for (MethodInfo methodIt : interfaceDeclaredMethods) {
            if (!method.getName().equals(methodIt.getName()) || method.getParameterTypes().length != methodIt.getParameterTypes().length) continue;
            boolean matchArgs = true;
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                ClassInfo parameterType = method.getParameterTypes()[i];
                if (parameterType.getName().equals(methodIt.getParameterTypes()[i].getName())) continue;
                matchArgs = false;
                break;
            }
            if (!matchArgs) continue;
            match = true;
            break;
        }
        return match;
    }

    public static List collectInterfaces(ClassInfo classInfo) {
        ArrayList<ClassInfo> interfaceList = new ArrayList<ClassInfo>();
        HashSet<String> interfaceNames = new HashSet<String>();
        for (int i = 0; i < classInfo.getInterfaces().length; ++i) {
            ClassInfo interfaceInfo = classInfo.getInterfaces()[i];
            interfaceList.add(interfaceInfo);
            interfaceNames.add(interfaceInfo.getName());
        }
        for (ClassInfo superClass = classInfo.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (int i = 0; i < superClass.getInterfaces().length; ++i) {
                ClassInfo interfaceInfo = superClass.getInterfaces()[i];
                if (interfaceNames.contains(interfaceInfo.getName())) continue;
                interfaceList.add(interfaceInfo);
                interfaceNames.add(interfaceInfo.getName());
            }
        }
        return interfaceList;
    }

    public static boolean hasMethodClash(Set interfacesToAdd, ClassLoader loader) {
        HashMap methodMap = new HashMap();
        Iterator<Object> it = interfacesToAdd.iterator();
        while (it.hasNext()) {
            ClassInfo classInfo = AsmClassInfo.getClassInfo((String)it.next(), loader);
            List methods = ClassInfoHelper.collectMethodsFromInterface(classInfo);
            for (MethodInfo methodInfo : methods) {
                String key = methodInfo.getName() + ':' + methodInfo.getSignature();
                if (!methodMap.containsKey(key)) {
                    methodMap.put(key, new ArrayList());
                }
                ((List)methodMap.get(key)).add(classInfo.getName());
            }
        }
        for (Map.Entry entry : methodMap.entrySet()) {
            String key = (String)entry.getKey();
            List interfaceNames = (List)entry.getValue();
            if (interfaceNames.size() <= 1) continue;
            StringBuffer msg = new StringBuffer();
            msg.append("can not add interfaces [");
            Iterator it2 = interfaceNames.iterator();
            while (it2.hasNext()) {
                String interfaceName = (String)it2.next();
                msg.append(interfaceName);
                if (!it2.hasNext()) continue;
                msg.append(',');
            }
            msg.append("] since they all have method [");
            msg.append(key);
            msg.append(']');
            System.out.println("AW::WARNING - " + msg.toString());
            return true;
        }
        return false;
    }
}

