/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect.impl.asm;

import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfoRepository;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmMemberInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.FieldStruct;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.backport175.reader.bytecode.AnnotationElement;

public class AsmFieldInfo
extends AsmMemberInfo
implements FieldInfo {
    private String m_typeName;
    private ClassInfo m_type = null;

    AsmFieldInfo(FieldStruct field, String declaringType, ClassLoader loader) {
        super(field, declaringType, loader);
        this.m_typeName = Type.getType(field.desc).getClassName();
    }

    public static FieldInfo getFieldInfo(String fieldName, String fieldDesc, byte[] bytecode, ClassLoader loader) {
        String className = AsmClassInfo.retrieveClassNameFromBytecode(bytecode);
        AsmClassInfoRepository repository = AsmClassInfoRepository.getRepository(loader);
        ClassInfo classInfo = repository.getClassInfo(className);
        if (classInfo == null) {
            classInfo = AsmClassInfo.getClassInfo(bytecode, loader);
        }
        return classInfo.getField(AsmHelper.calculateFieldHash(fieldName, fieldDesc));
    }

    public String getSignature() {
        return AsmHelper.getFieldDescriptor(this);
    }

    public ClassInfo getType() {
        if (this.m_type == null) {
            this.m_type = AsmClassInfo.getClassInfo(this.m_typeName, (ClassLoader)this.m_loaderRef.get());
        }
        return this.m_type;
    }

    public AnnotationElement.Annotation[] getAnnotations() {
        return this.getDeclaringType().getAnnotationReader().getFieldAnnotationElements(this.m_member.name, this.m_member.desc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldInfo)) {
            return false;
        }
        FieldInfo fieldInfo = (FieldInfo)o;
        if (!this.m_declaringTypeName.equals(fieldInfo.getDeclaringType().getName())) {
            return false;
        }
        if (!this.m_member.name.equals(fieldInfo.getName())) {
            return false;
        }
        return this.m_typeName.equals(fieldInfo.getType().getName());
    }

    public int hashCode() {
        int result = 29;
        result = 29 * result + this.m_declaringTypeName.hashCode();
        result = 29 * result + this.m_member.name.hashCode();
        result = 29 * result + this.m_typeName.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_declaringTypeName);
        sb.append('.').append(this.m_member.name).append(' ');
        sb.append(this.m_member.desc);
        return sb.toString();
    }
}

