/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect.impl.java;

import java.lang.reflect.Member;
import java.util.List;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.MemberInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfoRepository;

public abstract class JavaMemberInfo
implements MemberInfo {
    protected final Member m_member;
    protected final ClassInfo m_declaringType;
    protected List m_annotations = null;
    protected final JavaClassInfoRepository m_classInfoRepository;

    JavaMemberInfo(Member member, JavaClassInfo declaringType) {
        if (member == null) {
            throw new IllegalArgumentException("member can not be null");
        }
        if (declaringType == null) {
            throw new IllegalArgumentException("declaring type can not be null");
        }
        this.m_member = member;
        this.m_declaringType = declaringType;
        this.m_classInfoRepository = JavaClassInfoRepository.getRepository(member.getDeclaringClass().getClassLoader());
    }

    public String getName() {
        return this.m_member.getName();
    }

    public int getModifiers() {
        return this.m_member.getModifiers();
    }

    public ClassInfo getDeclaringType() {
        return this.m_declaringType;
    }
}

