/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.compiler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.aspect.AdviceInfo;
import org.codehaus.aspectwerkz.aspect.container.AspectFactoryManager;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.joinpoint.management.AdviceInfoContainer;
import org.codehaus.aspectwerkz.joinpoint.management.JoinPointType;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.transform.AspectWerkzPreProcessor;
import org.codehaus.aspectwerkz.transform.JoinPointCompiler;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.AdviceMethodInfo;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.AspectInfo;
import org.codehaus.aspectwerkz.transform.inlining.AspectModelManager;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.transform.inlining.compiler.CompilationInfo;
import org.codehaus.aspectwerkz.transform.inlining.compiler.CompilerInput;
import org.codehaus.aspectwerkz.transform.inlining.compiler.RuntimeCheckVisitor;
import org.codehaus.aspectwerkz.transform.inlining.spi.AspectModel;

public abstract class AbstractJoinPointCompiler
implements JoinPointCompiler,
TransformationConstants {
    public static final boolean DUMP_JIT_CLASSES = AspectWerkzPreProcessor.DUMP_AFTER;
    protected final String m_callerClassName;
    protected final String m_calleeClassName;
    protected final String m_callerClassSignature;
    protected final String m_calleeClassSignature;
    protected final String m_joinPointClassName;
    protected final int m_joinPointType;
    protected final int m_joinPointHash;
    protected final String m_callerMethodName;
    protected final String m_callerMethodDesc;
    protected final int m_callerMethodModifiers;
    protected final String m_calleeMemberName;
    protected final String m_calleeMemberDesc;
    protected final int m_calleeMemberModifiers;
    private final CompilationInfo.Model m_model;
    protected ClassWriter m_cw;
    protected AspectInfo[] m_aspectInfos;
    protected AspectModel[] m_aspectModels;
    protected AdviceMethodInfo[] m_aroundAdviceMethodInfos;
    protected AdviceMethodInfo[] m_beforeAdviceMethodInfos;
    protected AdviceMethodInfo[] m_afterFinallyAdviceMethodInfos;
    protected AdviceMethodInfo[] m_afterReturningAdviceMethodInfos;
    protected AdviceMethodInfo[] m_afterThrowingAdviceMethodInfos;
    protected boolean m_hasAroundAdvices = false;
    protected boolean m_requiresThisOrTarget = false;
    protected boolean m_requiresJoinPoint = false;
    protected boolean m_requiresProceedMethod = false;
    protected String[] m_fieldNames;
    protected Type[] m_argumentTypes;
    protected Type m_returnType;
    protected boolean m_isThisAdvisable = false;
    private CompilerInput m_input;

    public AbstractJoinPointCompiler(CompilationInfo.Model model) {
        this.m_model = model;
        this.m_joinPointClassName = model.getJoinPointClassName();
        EmittedJoinPoint emittedJoinPoint = model.getEmittedJoinPoint();
        this.m_joinPointHash = emittedJoinPoint.getJoinPointHash();
        this.m_joinPointType = emittedJoinPoint.getJoinPointType();
        this.m_callerMethodName = emittedJoinPoint.getCallerMethodName();
        this.m_callerMethodDesc = emittedJoinPoint.getCallerMethodDesc();
        this.m_callerMethodModifiers = emittedJoinPoint.getCallerMethodModifiers();
        this.m_calleeMemberName = emittedJoinPoint.getCalleeMemberName();
        this.m_calleeMemberDesc = emittedJoinPoint.getCalleeMemberDesc();
        this.m_calleeMemberModifiers = emittedJoinPoint.getCalleeMemberModifiers();
        this.m_callerClassName = emittedJoinPoint.getCallerClassName().replace('.', '/');
        this.m_calleeClassName = emittedJoinPoint.getCalleeClassName().replace('.', '/');
        this.m_callerClassSignature = "L" + emittedJoinPoint.getCallerClassName().replace('.', '/') + ";";
        this.m_calleeClassSignature = "L" + emittedJoinPoint.getCalleeClassName().replace('.', '/') + ";";
        this.m_argumentTypes = this.getJoinPointArgumentTypes();
        this.m_returnType = this.getJoinPointReturnType();
        this.initialize(model);
        this.initializeCompilerInput();
    }

    public String getCallerClassName() {
        return this.m_callerClassName;
    }

    public String getCalleeClassName() {
        return this.m_calleeClassName;
    }

    public String getCallerClassSignature() {
        return this.m_callerClassSignature;
    }

    public String getCalleeClassSignature() {
        return this.m_calleeClassSignature;
    }

    public String getJoinPointClassName() {
        return this.m_joinPointClassName;
    }

    private void initialize(CompilationInfo.Model model) {
        AdviceInfoContainer advices = model.getAdviceInfoContainer();
        this.collectAdviceInfo(advices);
        this.setupReferencedAspectModels();
        this.m_hasAroundAdvices = this.m_aroundAdviceMethodInfos.length > 0;
        this.m_isThisAdvisable = this.isCallerAdvisable(model);
        this.m_requiresThisOrTarget = this.requiresThisOrTarget();
        this.m_requiresJoinPoint = this.requiresJoinPoint();
        this.m_requiresProceedMethod = this.requiresProceedMethod();
        this.m_cw = AsmHelper.newClassWriter(true);
    }

    private void initializeCompilerInput() {
        this.m_input = new CompilerInput();
        this.m_input.calleeClassSignature = this.m_calleeClassSignature;
        this.m_input.callerClassSignature = this.m_callerClassSignature;
        this.m_input.joinPointClassName = this.m_joinPointClassName;
        this.m_input.calleeIndex = -1;
        this.m_input.argStartIndex = 0;
        if (!Modifier.isStatic(this.m_calleeMemberModifiers) && this.m_joinPointType != 4 && this.m_joinPointType != 7) {
            this.m_input.calleeIndex = 0;
            ++this.m_input.argStartIndex;
        } else {
            this.m_input.calleeIndex = -1;
        }
        this.m_input.callerIndex = this.m_input.argStartIndex + AsmHelper.getRegisterDepth(this.m_argumentTypes);
        if (this.m_joinPointType == 7) {
            this.m_input.calleeIndex = 0;
            this.m_input.callerIndex = 2;
            this.m_input.argStartIndex = 1;
        }
        this.m_input.isOptimizedJoinPoint = !this.m_requiresJoinPoint && !this.m_requiresProceedMethod;
        this.m_input.joinPointInstanceIndex = this.m_input.isOptimizedJoinPoint ? -1 : this.m_input.callerIndex + 1;
    }

    private void collectAdviceInfo(AdviceInfoContainer advices) {
        HashMap aspectInfoByQualifiedName = new HashMap();
        this.m_beforeAdviceMethodInfos = this.getAdviceMethodInfos(aspectInfoByQualifiedName, advices.getBeforeAdviceInfos());
        this.m_aroundAdviceMethodInfos = this.getAdviceMethodInfos(aspectInfoByQualifiedName, advices.getAroundAdviceInfos());
        this.m_afterReturningAdviceMethodInfos = this.getAdviceMethodInfos(aspectInfoByQualifiedName, advices.getAfterReturningAdviceInfos());
        this.m_afterFinallyAdviceMethodInfos = this.getAdviceMethodInfos(aspectInfoByQualifiedName, advices.getAfterFinallyAdviceInfos());
        this.m_afterThrowingAdviceMethodInfos = this.getAdviceMethodInfos(aspectInfoByQualifiedName, advices.getAfterThrowingAdviceInfos());
        this.m_aspectInfos = aspectInfoByQualifiedName.values().toArray(new AspectInfo[aspectInfoByQualifiedName.size()]);
    }

    private boolean isCallerAdvisable(CompilationInfo.Model model) {
        if (!Modifier.isStatic(this.m_callerMethodModifiers)) {
            ClassInfo[] interfaces = model.getThisClassInfo().getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].getName().equals("org.codehaus.aspectwerkz.intercept.Advisable")) continue;
                return true;
            }
        }
        return false;
    }

    private void setupReferencedAspectModels() {
        HashMap<String, AspectModel> aspectModelInstanceByType = new HashMap<String, AspectModel>();
        for (int i = 0; i < this.m_aspectInfos.length; ++i) {
            AspectModel aspectModel;
            AspectDefinition aspectDef = this.m_aspectInfos[i].getAspectDefinition();
            if (!aspectModelInstanceByType.containsKey(aspectDef.getAspectModel())) {
                aspectModel = AspectModelManager.getModelFor(aspectDef.getAspectModel()).getInstance(this.m_model);
                aspectModelInstanceByType.put(aspectDef.getAspectModel(), aspectModel);
            }
            if ((aspectModel = (AspectModel)aspectModelInstanceByType.get(aspectDef.getAspectModel())) == null) {
                throw new Error("Could not find AspectModel " + aspectDef.getAspectModel() + " for " + this.m_aspectInfos[i].getAspectQualifiedName());
            }
            this.m_aspectInfos[i].setAspectModel(aspectModel);
        }
        this.m_aspectModels = aspectModelInstanceByType.values().toArray(new AspectModel[0]);
    }

    private String getJoinPointInterface() {
        String joinPointInterface = this.m_requiresProceedMethod || this.m_requiresJoinPoint ? "org/codehaus/aspectwerkz/joinpoint/JoinPoint" : "org/codehaus/aspectwerkz/joinpoint/StaticJoinPoint";
        return joinPointInterface;
    }

    private AdviceMethodInfo[] getAdviceMethodInfos(Map aspectInfoByQualifiedName, AdviceInfo[] adviceInfos) {
        ArrayList<AdviceMethodInfo> adviceMethodInfosSet = new ArrayList<AdviceMethodInfo>();
        for (int i = 0; i < adviceInfos.length; ++i) {
            AspectInfo aspectInfo;
            AdviceInfo adviceInfo = adviceInfos[i];
            DeploymentModel deploymentModel = adviceInfo.getAspectDeploymentModel();
            if (AbstractJoinPointCompiler.requiresCallerInstance(deploymentModel) && Modifier.isStatic(this.m_callerMethodModifiers) || AbstractJoinPointCompiler.requiresCalleeInstance(deploymentModel) && Modifier.isStatic(this.m_calleeMemberModifiers)) continue;
            String aspectClassName = adviceInfo.getAspectClassName().replace('.', '/');
            if (!aspectInfoByQualifiedName.containsKey(adviceInfo.getAspectQualifiedName())) {
                aspectInfo = new AspectInfo(adviceInfo.getAdviceDefinition().getAspectDefinition(), "ASPECT_" + aspectInfoByQualifiedName.size(), aspectClassName, "L" + aspectClassName + ";");
                aspectInfoByQualifiedName.put(adviceInfo.getAspectQualifiedName(), aspectInfo);
            } else {
                aspectInfo = (AspectInfo)aspectInfoByQualifiedName.get(adviceInfo.getAspectQualifiedName());
            }
            AdviceMethodInfo adviceMethodInfo = new AdviceMethodInfo(aspectInfo, adviceInfo, this.m_callerClassSignature, this.m_calleeClassSignature, this.m_joinPointClassName, this.m_calleeMemberDesc);
            adviceMethodInfosSet.add(adviceMethodInfo);
        }
        return adviceMethodInfosSet.toArray(new AdviceMethodInfo[adviceMethodInfosSet.size()]);
    }

    protected abstract void createJoinPointSpecificFields();

    protected abstract void createSignature(MethodVisitor var1);

    protected abstract void createInlinedJoinPointInvocation(MethodVisitor var1, CompilerInput var2);

    protected abstract void createJoinPointInvocation(MethodVisitor var1);

    protected abstract Type getJoinPointReturnType();

    protected abstract Type[] getJoinPointArgumentTypes();

    protected abstract void createGetRttiMethod();

    protected abstract void createGetSignatureMethod();

    public final byte[] compile() {
        try {
            this.createClassHeader();
            this.createFieldsCommonToAllJoinPoints();
            this.createJoinPointSpecificFields();
            this.createMandatoryMethodInAspectModels();
            this.createStaticInitializer();
            this.createClinit();
            this.createInit();
            this.createUtilityMethods();
            this.createGetSignatureMethod();
            this.createInvokeMethod();
            if (this.m_requiresProceedMethod) {
                this.createProceedMethod(this.m_input.getCopyForProceed());
            }
            if (this.m_requiresJoinPoint) {
                this.createGetRttiMethod();
            }
            this.m_cw.visitEnd();
            if (DUMP_JIT_CLASSES && AspectWerkzPreProcessor.DUMP_PATTERN.matches(this.m_joinPointClassName.replace('/', '.'))) {
                AsmHelper.dumpClass(AspectWerkzPreProcessor.DUMP_DIR_AFTER, this.m_joinPointClassName, this.m_cw);
            }
            return this.m_cw.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            StringBuffer buf = new StringBuffer();
            buf.append("could not compile join point instance for join point with hash [");
            buf.append(this.m_joinPointHash);
            buf.append("] and declaring class [");
            buf.append(this.m_callerClassName);
            buf.append("] due to: ");
            if (e instanceof InvocationTargetException) {
                buf.append(((InvocationTargetException)e).getTargetException().toString());
            } else {
                buf.append(e.toString());
            }
            throw new RuntimeException(buf.toString());
        }
    }

    private void createFieldsCommonToAllJoinPoints() {
        if (this.m_returnType.getSort() != 0) {
            this.m_cw.visitField(2, "RETURN_VALUE", this.m_returnType.getDescriptor(), null, null);
        }
        this.m_cw.visitField(10, "TARGET_CLASS", "Ljava/lang/Class;", null, null);
        this.m_cw.visitField(26, "THIS_CLASS", "Ljava/lang/Class;", null, null);
        this.m_cw.visitField(26, "ENCLOSINGSJP", "Lorg/codehaus/aspectwerkz/joinpoint/EnclosingStaticJoinPoint;", null, null);
        this.m_cw.visitField(10, "META_DATA", "Ljava/util/Map;", null, null);
        this.m_cw.visitField(10, "OPTIMIZED_JOIN_POINT", "L" + this.m_joinPointClassName + ";", null, null);
        this.m_cw.visitField(2, "CALLEE", this.m_calleeClassSignature, null, null);
        this.m_cw.visitField(2, "CALLER", this.m_callerClassSignature, null, null);
        this.m_cw.visitField(2, "STACK_FRAME_COUNTER", "I", null, null);
        if (this.m_isThisAdvisable) {
            this.m_cw.visitField(2, "INTERCEPTOR_INDEX", "I", null, null);
            this.m_cw.visitField(2, "AROUND_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AroundAdvice;", null, null);
            this.m_cw.visitField(2, "NR_OF_AROUND_INTERCEPTORS", "I", null, null);
            this.m_cw.visitField(2, "BEFORE_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/BeforeAdvice;", null, null);
            this.m_cw.visitField(2, "NR_OF_BEFORE_INTERCEPTORS", "I", null, null);
            this.m_cw.visitField(2, "AFTER_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterAdvice;", null, null);
            this.m_cw.visitField(2, "NR_OF_AFTER_INTERCEPTORS", "I", null, null);
            this.m_cw.visitField(2, "AFTER_RETURNING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterReturningAdvice;", null, null);
            this.m_cw.visitField(2, "NR_OF_AFTER_RETURNING_INTERCEPTORS", "I", null, null);
            this.m_cw.visitField(2, "AFTER_THROWING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterThrowingAdvice;", null, null);
            this.m_cw.visitField(2, "NR_OF_AFTER_THROWING_INTERCEPTORS", "I", null, null);
        }
    }

    private void createClinit() {
        MethodVisitor cv = this.m_cw.visitMethod(8, "<clinit>", "()V", null, null);
        cv.visitMethodInsn(184, this.m_joinPointClassName, "aw$staticinitialization", "()V");
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    private void createInit() {
        MethodVisitor cv = this.m_cw.visitMethod(2, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        boolean hasAroundClosureBaseClass = false;
        AspectModel aspectModel = null;
        for (int i = 0; i < this.m_aspectModels.length; ++i) {
            aspectModel = this.m_aspectModels[i];
            if (aspectModel.getAroundClosureClassInfo().getSuperClassName() == null || "java/lang/Object".equals(aspectModel.getAroundClosureClassInfo().getSuperClassName())) continue;
            hasAroundClosureBaseClass = true;
            break;
        }
        if (hasAroundClosureBaseClass) {
            aspectModel.createInvocationOfAroundClosureSuperClass(cv);
        } else {
            cv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        }
        this.resetStackFrameCounter(cv);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    private void createClassHeader() {
        int i;
        HashSet<String> interfaces = new HashSet<String>();
        String baseClass = "java/lang/Object";
        for (i = 0; i < this.m_aspectModels.length; ++i) {
            AspectModel aspectModel = this.m_aspectModels[i];
            AspectModel.AroundClosureClassInfo closureClassInfo = aspectModel.getAroundClosureClassInfo();
            String superClassName = closureClassInfo.getSuperClassName();
            String[] interfaceNames = closureClassInfo.getInterfaceNames();
            if (superClassName != null) {
                if (!baseClass.equals("java/lang/Object")) {
                    throw new RuntimeException("compiled join point can only subclass one around closure base class but more than registered aspect model requires a closure base class");
                }
                baseClass = superClassName;
            }
            if (interfaceNames.length == 0) continue;
            for (int j = 0; j < interfaceNames.length; ++j) {
                interfaces.add(interfaceNames[j]);
            }
        }
        i = 1;
        String[] interfaceArr = new String[interfaces.size() + 1];
        interfaceArr[0] = this.getJoinPointInterface();
        Iterator it = interfaces.iterator();
        while (it.hasNext()) {
            interfaceArr[i] = (String)it.next();
            ++i;
        }
        this.m_cw.visit(AsmHelper.JAVA_VERSION, 33, this.m_joinPointClassName, null, baseClass, interfaceArr);
    }

    private void createMandatoryMethodInAspectModels() {
        for (int i = 0; i < this.m_aspectModels.length; ++i) {
            this.m_aspectModels[i].createMandatoryMethods(this.m_cw, this);
        }
    }

    private void createStaticInitializer() {
        int i;
        MethodVisitor cv = this.m_cw.visitMethod(9, "aw$staticinitialization", "()V", null, null);
        Label tryLabel = new Label();
        cv.visitLabel(tryLabel);
        cv.visitLdcInsn(this.m_calleeClassName.replace('/', '.'));
        cv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        cv.visitFieldInsn(179, this.m_joinPointClassName, "TARGET_CLASS", "Ljava/lang/Class;");
        cv.visitLdcInsn(this.m_callerClassName.replace('/', '.'));
        cv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        cv.visitFieldInsn(179, this.m_joinPointClassName, "THIS_CLASS", "Ljava/lang/Class;");
        Label finallyLabel = new Label();
        cv.visitLabel(finallyLabel);
        Label gotoFinallyLabel = new Label();
        cv.visitJumpInsn(167, gotoFinallyLabel);
        Label catchLabel = new Label();
        cv.visitLabel(catchLabel);
        cv.visitVarInsn(58, 0);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(182, "java/lang/Throwable", "printStackTrace", "()V");
        cv.visitTypeInsn(187, "java/lang/RuntimeException");
        cv.visitInsn(89);
        cv.visitLdcInsn("could not load target class using Class.forName() in generated join point base class " + this.m_joinPointClassName);
        cv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
        cv.visitInsn(191);
        cv.visitLabel(gotoFinallyLabel);
        this.createEnclosingStaticJoinPoint(cv);
        cv.visitTypeInsn(187, "java/util/HashMap");
        cv.visitInsn(89);
        cv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        cv.visitFieldInsn(179, this.m_joinPointClassName, "META_DATA", "Ljava/util/Map;");
        this.createSignature(cv);
        cv.visitTypeInsn(187, this.m_joinPointClassName);
        cv.visitInsn(89);
        cv.visitMethodInsn(183, this.m_joinPointClassName, "<init>", "()V");
        cv.visitFieldInsn(179, this.m_joinPointClassName, "OPTIMIZED_JOIN_POINT", "L" + this.m_joinPointClassName + ";");
        for (i = 0; i < this.m_aspectInfos.length; ++i) {
            AspectInfo m_aspectInfo = this.m_aspectInfos[i];
            cv.visitLdcInsn(m_aspectInfo.getAspectFactoryClassName());
            cv.visitLdcInsn(m_aspectInfo.getAspectDefinition().getSystemDefinition().getUuid());
            cv.visitLdcInsn(m_aspectInfo.getAspectClassName());
            cv.visitLdcInsn(m_aspectInfo.getAspectQualifiedName());
            AsmHelper.loadStringConstant(cv, m_aspectInfo.getAspectDefinition().getContainerClassName());
            StringBuffer sb = new StringBuffer();
            boolean hasOne = false;
            boolean isFirst = true;
            for (Map.Entry entry : m_aspectInfo.getAspectDefinition().getParameters().entrySet()) {
                if (!isFirst) {
                    sb.append("$_AW_$");
                }
                isFirst = false;
                hasOne = true;
                sb.append(entry.getKey()).append("$_AW_$").append(entry.getValue());
            }
            if (hasOne) {
                cv.visitLdcInsn(sb.toString());
            } else {
                cv.visitInsn(1);
            }
            cv.visitFieldInsn(178, this.m_joinPointClassName, "THIS_CLASS", "Ljava/lang/Class;");
            cv.visitMethodInsn(182, "java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;");
            cv.visitLdcInsn(m_aspectInfo.getDeploymentModel().toString());
            cv.visitMethodInsn(184, Type.getInternalName(AspectFactoryManager.class), "loadAspectFactory", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/ClassLoader;Ljava/lang/String;)V");
        }
        for (i = 0; i < this.m_aspectInfos.length; ++i) {
            this.m_aspectInfos[i].getAspectModel().createAndStoreStaticAspectInstantiation(this.m_cw, cv, this.m_aspectInfos[i], this.m_joinPointClassName);
        }
        cv.visitInsn(177);
        cv.visitTryCatchBlock(tryLabel, finallyLabel, catchLabel, "java/lang/ClassNotFoundException");
        cv.visitMaxs(0, 0);
    }

    private void createEnclosingStaticJoinPoint(MethodVisitor cv) {
        cv.visitFieldInsn(178, this.m_joinPointClassName, "THIS_CLASS", "Ljava/lang/Class;");
        cv.visitLdcInsn(this.m_callerMethodName);
        cv.visitLdcInsn(this.m_callerMethodDesc);
        cv.visitMethodInsn(184, "org/codehaus/aspectwerkz/joinpoint/management/SignatureFactory", "newEnclosingStaticJoinPoint", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)Lorg/codehaus/aspectwerkz/joinpoint/EnclosingStaticJoinPoint;");
        cv.visitFieldInsn(179, this.m_joinPointClassName, "ENCLOSINGSJP", "Lorg/codehaus/aspectwerkz/joinpoint/EnclosingStaticJoinPoint;");
    }

    protected void createInvokeMethod() {
        String invokeDesc = this.buildInvokeMethodSignature();
        MethodVisitor cv = this.m_cw.visitMethod(25, "invoke", invokeDesc, null, new String[]{"java/lang/Throwable"});
        if (!this.m_input.isOptimizedJoinPoint) {
            this.createInvocationLocalJoinPointInstance(cv, this.m_input);
        }
        this.initializeInstanceLevelAspects(cv, this.m_input);
        this.createBeforeAdviceInvocations(cv, this.m_input);
        if (this.m_afterFinallyAdviceMethodInfos.length == 0 && this.m_afterThrowingAdviceMethodInfos.length == 0 && !this.m_isThisAdvisable) {
            this.createPartOfInvokeMethodWithoutAfterFinallyAndAfterThrowingAdviceTypes(cv, this.m_input);
        } else if (this.m_afterThrowingAdviceMethodInfos.length == 0 && !this.m_isThisAdvisable) {
            this.createPartOfInvokeMethodWithoutAfterThrowingAdviceTypes(cv, this.m_input);
        } else {
            this.createPartOfInvokeMethodWithAllAdviceTypes(cv, this.m_input);
        }
        cv.visitMaxs(0, 0);
    }

    private void initializeInstanceLevelAspects(MethodVisitor cv, CompilerInput input) {
        for (int i = 0; i < this.m_aspectInfos.length; ++i) {
            this.m_aspectInfos[i].getAspectModel().createAndStoreRuntimeAspectInstantiation(cv, input, this.m_aspectInfos[i]);
        }
    }

    private void createPartOfInvokeMethodWithAllAdviceTypes(MethodVisitor cv, CompilerInput input) {
        int returnValueIndex = input.joinPointInstanceIndex != -1 ? input.joinPointInstanceIndex + 1 : input.callerIndex + 1;
        int exceptionIndex1 = returnValueIndex + 1;
        int exceptionIndex2 = returnValueIndex + 2;
        cv.visitInsn(1);
        cv.visitVarInsn(58, returnValueIndex);
        Label tryLabel = new Label();
        cv.visitLabel(tryLabel);
        if (!this.m_requiresProceedMethod) {
            this.createInlinedJoinPointInvocation(cv, input);
            int stackIndex = returnValueIndex;
            AsmHelper.storeType(cv, stackIndex, this.m_returnType);
            this.addReturnedValueToJoinPoint(cv, input, returnValueIndex, false);
        } else {
            this.createInvocationToProceedMethod(cv, input.joinPointInstanceIndex, returnValueIndex);
        }
        this.createAfterReturningAdviceInvocations(cv, input);
        Label finallyLabel1 = new Label();
        cv.visitLabel(finallyLabel1);
        if (this.m_isThisAdvisable) {
            int registerDepth = input.callerIndex + 2;
            this.createAfterInterceptorInvocations(cv, input.joinPointInstanceIndex, registerDepth);
        }
        this.createAfterFinallyAdviceInvocations(cv, input);
        Label gotoFinallyLabel = new Label();
        cv.visitJumpInsn(167, gotoFinallyLabel);
        Label catchLabel = new Label();
        cv.visitLabel(catchLabel);
        cv.visitVarInsn(58, exceptionIndex1);
        if (this.m_isThisAdvisable) {
            this.createAfterThrowingInterceptorInvocations(cv, input.joinPointInstanceIndex, exceptionIndex1);
        }
        for (int i = this.m_afterThrowingAdviceMethodInfos.length - 1; i >= 0; --i) {
            AdviceMethodInfo advice = this.m_afterThrowingAdviceMethodInfos[i];
            advice.setSpecialArgumentIndex(exceptionIndex1);
            cv.visitVarInsn(25, exceptionIndex1);
            String specialArgTypeName = advice.getSpecialArgumentTypeName();
            if (specialArgTypeName != null) {
                cv.visitTypeInsn(193, specialArgTypeName);
                Label ifInstanceOfLabel = new Label();
                cv.visitJumpInsn(153, ifInstanceOfLabel);
                this.createAfterAdviceInvocation(cv, input, advice, exceptionIndex1);
                cv.visitLabel(ifInstanceOfLabel);
                continue;
            }
            this.createAfterAdviceInvocation(cv, input, advice, -1);
        }
        cv.visitVarInsn(25, exceptionIndex1);
        cv.visitInsn(191);
        Label exceptionLabel = new Label();
        cv.visitLabel(exceptionLabel);
        cv.visitVarInsn(58, exceptionIndex2);
        Label finallyLabel2 = new Label();
        cv.visitLabel(finallyLabel2);
        if (this.m_isThisAdvisable) {
            int registerDepth = input.callerIndex + 2;
            this.createAfterInterceptorInvocations(cv, input.joinPointInstanceIndex, registerDepth);
        }
        this.createAfterFinallyAdviceInvocations(cv, input);
        cv.visitVarInsn(25, exceptionIndex2);
        cv.visitInsn(191);
        cv.visitLabel(gotoFinallyLabel);
        if (this.m_returnType.getSort() != 0) {
            if (this.m_requiresProceedMethod) {
                cv.visitVarInsn(25, returnValueIndex);
                AsmHelper.unwrapType(cv, this.m_returnType);
            } else {
                AsmHelper.loadType(cv, returnValueIndex, this.m_returnType);
            }
        }
        AsmHelper.addReturnStatement(cv, this.m_returnType);
        cv.visitTryCatchBlock(tryLabel, finallyLabel1, catchLabel, "java/lang/Throwable");
        cv.visitTryCatchBlock(tryLabel, finallyLabel1, exceptionLabel, null);
        cv.visitTryCatchBlock(catchLabel, finallyLabel2, exceptionLabel, null);
    }

    private void createPartOfInvokeMethodWithoutAfterThrowingAdviceTypes(MethodVisitor cv, CompilerInput input) {
        int returnValueIndex = input.joinPointInstanceIndex != -1 ? input.joinPointInstanceIndex + 1 : input.callerIndex + 1;
        int exceptionIndex = returnValueIndex + 1;
        cv.visitInsn(1);
        cv.visitVarInsn(58, returnValueIndex);
        Label tryLabel = new Label();
        cv.visitLabel(tryLabel);
        if (!this.m_requiresProceedMethod) {
            this.createInlinedJoinPointInvocation(cv, input);
            int stackIndex = returnValueIndex;
            AsmHelper.storeType(cv, stackIndex, this.m_returnType);
            this.addReturnedValueToJoinPoint(cv, input, returnValueIndex, false);
        } else {
            this.createInvocationToProceedMethod(cv, input.joinPointInstanceIndex, returnValueIndex);
        }
        this.createAfterReturningAdviceInvocations(cv, input);
        Label finallyLabel1 = new Label();
        cv.visitLabel(finallyLabel1);
        this.createAfterFinallyAdviceInvocations(cv, input);
        Label gotoFinallyLabel = new Label();
        cv.visitJumpInsn(167, gotoFinallyLabel);
        Label exceptionLabel = new Label();
        cv.visitLabel(exceptionLabel);
        cv.visitVarInsn(58, exceptionIndex);
        Label finallyLabel2 = new Label();
        cv.visitLabel(finallyLabel2);
        this.createAfterFinallyAdviceInvocations(cv, input);
        cv.visitVarInsn(25, exceptionIndex);
        cv.visitInsn(191);
        cv.visitLabel(gotoFinallyLabel);
        if (this.m_returnType.getSort() != 0) {
            if (this.m_requiresProceedMethod) {
                cv.visitVarInsn(25, returnValueIndex);
                AsmHelper.unwrapType(cv, this.m_returnType);
            } else {
                AsmHelper.loadType(cv, returnValueIndex, this.m_returnType);
            }
        }
        AsmHelper.addReturnStatement(cv, this.m_returnType);
        cv.visitTryCatchBlock(tryLabel, finallyLabel1, exceptionLabel, null);
        cv.visitTryCatchBlock(exceptionLabel, finallyLabel2, exceptionLabel, null);
    }

    private void createPartOfInvokeMethodWithoutAfterFinallyAndAfterThrowingAdviceTypes(MethodVisitor cv, CompilerInput input) {
        int returnValueIndex;
        int n = returnValueIndex = input.joinPointInstanceIndex != -1 ? input.joinPointInstanceIndex + 1 : input.callerIndex + 1;
        if (!this.m_requiresProceedMethod) {
            this.createInlinedJoinPointInvocation(cv, input);
            int stackIndex = returnValueIndex;
            AsmHelper.storeType(cv, stackIndex, this.m_returnType);
            this.addReturnedValueToJoinPoint(cv, input, returnValueIndex, false);
        } else {
            this.createInvocationToProceedMethod(cv, input.joinPointInstanceIndex, returnValueIndex);
        }
        this.createAfterReturningAdviceInvocations(cv, input);
        if (this.m_returnType.getSort() != 0) {
            if (this.m_requiresProceedMethod) {
                cv.visitVarInsn(25, returnValueIndex);
                AsmHelper.unwrapType(cv, this.m_returnType);
            } else {
                AsmHelper.loadType(cv, returnValueIndex, this.m_returnType);
            }
        }
        AsmHelper.addReturnStatement(cv, this.m_returnType);
    }

    private void createInvocationToProceedMethod(MethodVisitor cv, int joinPointInstanceIndex, int returnValueIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitMethodInsn(182, this.m_joinPointClassName, "proceed", "()Ljava/lang/Object;");
        cv.visitVarInsn(58, returnValueIndex);
    }

    private void createInvocationLocalJoinPointInstance(MethodVisitor cv, CompilerInput input) {
        cv.visitTypeInsn(187, this.m_joinPointClassName);
        cv.visitInsn(89);
        cv.visitMethodInsn(183, this.m_joinPointClassName, "<init>", "()V");
        cv.visitVarInsn(58, input.joinPointInstanceIndex);
        int argStackIndex = input.argStartIndex;
        for (int i = 0; i < this.m_fieldNames.length; ++i) {
            String fieldName = this.m_fieldNames[i];
            cv.visitVarInsn(25, input.joinPointInstanceIndex);
            Type type = this.m_argumentTypes[i];
            argStackIndex = AsmHelper.loadType(cv, argStackIndex, type);
            cv.visitFieldInsn(181, this.m_joinPointClassName, fieldName, type.getDescriptor());
        }
        cv.visitVarInsn(25, input.joinPointInstanceIndex);
        cv.visitVarInsn(25, input.callerIndex);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "CALLER", this.m_callerClassSignature);
        cv.visitVarInsn(25, input.joinPointInstanceIndex);
        if (input.calleeIndex != -1) {
            cv.visitVarInsn(25, 0);
        } else {
            cv.visitInsn(1);
        }
        cv.visitFieldInsn(181, this.m_joinPointClassName, "CALLEE", this.m_calleeClassSignature);
        if (this.m_isThisAdvisable) {
            this.createInitializationForAdvisableManagement(cv, input.joinPointInstanceIndex, input.callerIndex);
        }
    }

    private void createProceedMethod(CompilerInput input) {
        int i;
        MethodVisitor cv = this.m_cw.visitMethod(17, "proceed", "()Ljava/lang/Object;", null, new String[]{"java/lang/Throwable"});
        if (this.m_isThisAdvisable) {
            this.createAroundInterceptorInvocations(cv);
        }
        this.incrementStackFrameCounter(cv);
        Label tryLabel = new Label();
        Label defaultCaseLabel = new Label();
        Label gotoLabel = new Label();
        Label handlerLabel = new Label();
        Label endLabel = new Label();
        int nrOfCases = this.m_aroundAdviceMethodInfos.length;
        if (this.m_isThisAdvisable) {
            ++nrOfCases;
        }
        Label[] caseLabels = new Label[nrOfCases];
        Label[] returnLabels = new Label[nrOfCases];
        int[] caseNumbers = new int[nrOfCases];
        for (i = 0; i < caseLabels.length; ++i) {
            caseLabels[i] = new Label();
            caseNumbers[i] = i;
        }
        for (i = 0; i < returnLabels.length; ++i) {
            returnLabels[i] = new Label();
        }
        cv.visitLabel(tryLabel);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "STACK_FRAME_COUNTER", "I");
        cv.visitLookupSwitchInsn(defaultCaseLabel, caseNumbers, caseLabels);
        for (i = 0; i < this.m_aroundAdviceMethodInfos.length; ++i) {
            cv.visitLabel(caseLabels[i]);
            AdviceMethodInfo adviceInfo = this.m_aroundAdviceMethodInfos[i];
            Label endInstanceOflabel = this.beginRuntimeCheck(cv, input, adviceInfo.getAdviceInfo());
            adviceInfo.getAspectInfo().getAspectModel().loadAspect(cv, input, adviceInfo.getAspectInfo());
            adviceInfo.getAspectInfo().getAspectModel().createAroundAdviceArgumentHandling(cv, input, this.m_argumentTypes, adviceInfo);
            cv.visitMethodInsn(182, adviceInfo.getAspectInfo().getAspectClassName(), adviceInfo.getAdviceInfo().getMethodName(), adviceInfo.getAdviceInfo().getMethodSignature());
            cv.visitVarInsn(58, 1);
            if (endInstanceOflabel != null) {
                Label elseInstanceOfLabel = new Label();
                cv.visitJumpInsn(167, elseInstanceOfLabel);
                this.endRuntimeCheck(cv, adviceInfo.getAdviceInfo(), endInstanceOflabel);
                cv.visitVarInsn(25, 0);
                cv.visitMethodInsn(183, this.m_joinPointClassName, "proceed", "()Ljava/lang/Object;");
                cv.visitVarInsn(58, 1);
                cv.visitLabel(elseInstanceOfLabel);
            }
            cv.visitLabel(returnLabels[i]);
            cv.visitVarInsn(25, 1);
            cv.visitInsn(176);
        }
        if (this.m_isThisAdvisable) {
            int delegationCaseIndex = caseLabels.length - 1;
            cv.visitLabel(caseLabels[delegationCaseIndex]);
            cv.visitVarInsn(25, 0);
            cv.visitInsn(3);
            cv.visitFieldInsn(181, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
            cv.visitVarInsn(25, 0);
            cv.visitMethodInsn(182, this.m_joinPointClassName, "proceed", "()Ljava/lang/Object;");
            cv.visitLabel(returnLabels[delegationCaseIndex]);
            cv.visitInsn(176);
        }
        cv.visitLabel(defaultCaseLabel);
        AsmHelper.prepareWrappingOfPrimitiveType(cv, Type.getReturnType(this.m_calleeMemberDesc));
        this.createJoinPointInvocation(cv);
        Type m_returnType = null;
        m_returnType = this.m_joinPointType != 4 ? Type.getReturnType(this.m_calleeMemberDesc) : Type.getType(this.m_calleeClassSignature);
        AsmHelper.wrapPrimitiveType(cv, m_returnType);
        cv.visitVarInsn(58, 1);
        this.addReturnedValueToJoinPoint(cv, input, 1, true);
        if (this.m_joinPointType == 4) {
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(25, 1);
            cv.visitFieldInsn(181, this.m_joinPointClassName, "CALLEE", this.m_calleeClassSignature);
        }
        cv.visitLabel(gotoLabel);
        cv.visitVarInsn(25, 1);
        cv.visitInsn(176);
        cv.visitLabel(handlerLabel);
        cv.visitVarInsn(58, 2);
        cv.visitLabel(endLabel);
        cv.visitVarInsn(25, 2);
        cv.visitInsn(191);
        cv.visitTryCatchBlock(tryLabel, returnLabels[0], handlerLabel, null);
        for (int i2 = 1; i2 < caseLabels.length; ++i2) {
            Label caseLabel = caseLabels[i2];
            Label returnLabel = returnLabels[i2];
            cv.visitTryCatchBlock(caseLabel, returnLabel, handlerLabel, null);
        }
        cv.visitTryCatchBlock(defaultCaseLabel, gotoLabel, handlerLabel, null);
        cv.visitTryCatchBlock(handlerLabel, endLabel, handlerLabel, null);
        cv.visitMaxs(0, 0);
    }

    private void createBeforeAdviceInvocations(MethodVisitor cv, CompilerInput input) {
        for (int i = 0; i < this.m_beforeAdviceMethodInfos.length; ++i) {
            AdviceMethodInfo adviceMethodInfo = this.m_beforeAdviceMethodInfos[i];
            AspectInfo aspectInfo = adviceMethodInfo.getAspectInfo();
            if (AbstractJoinPointCompiler.requiresCallerInstance(aspectInfo.getDeploymentModel()) && input.callerIndex < 0 || AbstractJoinPointCompiler.requiresCalleeInstance(aspectInfo.getDeploymentModel()) && input.calleeIndex < 0) continue;
            Label endInstanceOflabel = this.beginRuntimeCheck(cv, input, adviceMethodInfo.getAdviceInfo());
            AspectModel aspectModel = adviceMethodInfo.getAspectInfo().getAspectModel();
            aspectModel.loadAspect(cv, input, adviceMethodInfo.getAspectInfo());
            aspectModel.createBeforeOrAfterAdviceArgumentHandling(cv, input, this.m_argumentTypes, adviceMethodInfo, -1);
            cv.visitMethodInsn(182, adviceMethodInfo.getAspectInfo().getAspectClassName(), adviceMethodInfo.getAdviceInfo().getMethodName(), adviceMethodInfo.getAdviceInfo().getMethodSignature());
            this.endRuntimeCheck(cv, adviceMethodInfo.getAdviceInfo(), endInstanceOflabel);
        }
        if (this.m_isThisAdvisable) {
            this.createBeforeInterceptorInvocations(cv, input.joinPointInstanceIndex, input.callerIndex + 1);
        }
    }

    private void createAfterFinallyAdviceInvocations(MethodVisitor cv, CompilerInput input) {
        for (int i = this.m_afterFinallyAdviceMethodInfos.length - 1; i >= 0; --i) {
            AdviceMethodInfo advice = this.m_afterFinallyAdviceMethodInfos[i];
            this.createAfterAdviceInvocation(cv, input, advice, -1);
        }
    }

    private void createAfterReturningAdviceInvocations(MethodVisitor cv, CompilerInput input) {
        int returnValueIndex;
        int n = returnValueIndex = input.joinPointInstanceIndex != -1 ? input.joinPointInstanceIndex + 1 : input.callerIndex + 1;
        if (this.m_isThisAdvisable) {
            this.createAfterReturningInterceptorInvocations(cv, input.joinPointInstanceIndex, returnValueIndex);
        }
        boolean hasPoppedReturnValueFromStack = false;
        for (int i = this.m_afterReturningAdviceMethodInfos.length - 1; i >= 0; --i) {
            AdviceMethodInfo advice = this.m_afterReturningAdviceMethodInfos[i];
            advice.setSpecialArgumentIndex(returnValueIndex);
            String specialArgDesc = advice.getSpecialArgumentTypeDesc();
            if (specialArgDesc == null) {
                this.createAfterAdviceInvocation(cv, input, advice, -1);
                continue;
            }
            if (AsmHelper.isPrimitive(this.m_returnType)) {
                if (!this.m_returnType.getDescriptor().equals(specialArgDesc)) continue;
                this.createAfterAdviceInvocation(cv, input, advice, returnValueIndex);
                continue;
            }
            cv.visitVarInsn(25, returnValueIndex);
            cv.visitTypeInsn(193, advice.getSpecialArgumentTypeName());
            Label label = new Label();
            cv.visitJumpInsn(153, label);
            this.createAfterAdviceInvocation(cv, input, advice, returnValueIndex);
            cv.visitLabel(label);
        }
        if (!this.m_requiresProceedMethod && hasPoppedReturnValueFromStack) {
            cv.visitVarInsn(25, returnValueIndex);
        }
    }

    private void createAfterAdviceInvocation(MethodVisitor cv, CompilerInput input, AdviceMethodInfo adviceMethodInfo, int specialArgIndex) {
        AspectInfo aspectInfo = adviceMethodInfo.getAspectInfo();
        if (AbstractJoinPointCompiler.requiresCallerInstance(aspectInfo.getDeploymentModel()) && input.callerIndex < 0) {
            return;
        }
        if (AbstractJoinPointCompiler.requiresCalleeInstance(aspectInfo.getDeploymentModel()) && input.calleeIndex < 0) {
            return;
        }
        Label endInstanceOflabel = this.beginRuntimeCheck(cv, input, adviceMethodInfo.getAdviceInfo());
        AspectModel aspectModel = adviceMethodInfo.getAspectInfo().getAspectModel();
        aspectModel.loadAspect(cv, input, aspectInfo);
        aspectModel.createBeforeOrAfterAdviceArgumentHandling(cv, input, this.m_argumentTypes, adviceMethodInfo, specialArgIndex);
        cv.visitMethodInsn(182, adviceMethodInfo.getAspectInfo().getAspectClassName(), adviceMethodInfo.getAdviceInfo().getMethodName(), adviceMethodInfo.getAdviceInfo().getMethodSignature());
        this.endRuntimeCheck(cv, adviceMethodInfo.getAdviceInfo(), endInstanceOflabel);
    }

    private void addReturnedValueToJoinPoint(MethodVisitor cv, CompilerInput input, int returnValueIndex, boolean unwrap) {
        if (this.m_requiresJoinPoint && this.m_returnType.getSort() != 0 && (this.m_joinPointType == 1 || this.m_joinPointType == 2 || this.m_joinPointType == 4)) {
            AbstractJoinPointCompiler.loadJoinPointInstance(cv, input);
            if (unwrap && AsmHelper.isPrimitive(this.m_returnType)) {
                cv.visitVarInsn(25, returnValueIndex);
                AsmHelper.unwrapType(cv, this.m_returnType);
            } else {
                AsmHelper.loadType(cv, returnValueIndex, this.m_returnType);
            }
            cv.visitFieldInsn(181, this.m_joinPointClassName, "RETURN_VALUE", this.m_returnType.getDescriptor());
        }
    }

    static void loadJoinPointInstance(MethodVisitor cv, CompilerInput input) {
        if (input.isOptimizedJoinPoint) {
            cv.visitFieldInsn(178, input.joinPointClassName, "OPTIMIZED_JOIN_POINT", "L" + input.joinPointClassName + ";");
        } else {
            cv.visitVarInsn(25, input.joinPointInstanceIndex);
        }
    }

    protected final void loadArgumentMemberFields(MethodVisitor cv, int argStartIndex) {
        int argStackIndex = argStartIndex;
        for (int index = 0; index < this.m_argumentTypes.length; ++index) {
            Type argumentType = this.m_argumentTypes[index];
            argStackIndex = AsmHelper.loadType(cv, argStackIndex, argumentType);
        }
    }

    protected final void loadArguments(MethodVisitor cv) {
        for (int i = 0; i < this.m_fieldNames.length; ++i) {
            String fieldName = this.m_fieldNames[i];
            Type argumentType = this.m_argumentTypes[i];
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, fieldName, argumentType.getDescriptor());
        }
    }

    private void resetStackFrameCounter(MethodVisitor cv) {
        cv.visitVarInsn(25, 0);
        cv.visitInsn(2);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "STACK_FRAME_COUNTER", "I");
    }

    private void incrementStackFrameCounter(MethodVisitor cv) {
        cv.visitVarInsn(25, 0);
        cv.visitInsn(89);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "STACK_FRAME_COUNTER", "I");
        cv.visitInsn(4);
        cv.visitInsn(96);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "STACK_FRAME_COUNTER", "I");
    }

    public final void createArgumentArrayAt(MethodVisitor cv, int stackFreeIndex) {
        AsmHelper.loadIntegerConstant(cv, this.m_fieldNames.length);
        cv.visitTypeInsn(189, "java/lang/Object");
        cv.visitVarInsn(58, stackFreeIndex);
        for (int i = 0; i < this.m_argumentTypes.length; ++i) {
            cv.visitVarInsn(25, stackFreeIndex);
            AsmHelper.loadIntegerConstant(cv, i);
            AsmHelper.prepareWrappingOfPrimitiveType(cv, this.m_argumentTypes[i]);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "ARGUMENT_" + i, this.m_argumentTypes[i].getDescriptor());
            AsmHelper.wrapPrimitiveType(cv, this.m_argumentTypes[i]);
            cv.visitInsn(83);
        }
    }

    private void createUtilityMethods() {
        MethodVisitor cv = this.m_cw.visitMethod(1, "addMetaData", "(Ljava/lang/Object;Ljava/lang/Object;)V", null, null);
        cv.visitFieldInsn(178, this.m_joinPointClassName, "META_DATA", "Ljava/util/Map;");
        cv.visitVarInsn(25, 1);
        cv.visitVarInsn(25, 2);
        cv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        cv.visitInsn(87);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getMetaData", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        cv.visitFieldInsn(178, this.m_joinPointClassName, "META_DATA", "Ljava/util/Map;");
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getCallee", "()Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "CALLEE", this.m_calleeClassSignature);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getCaller", "()Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "CALLER", this.m_callerClassSignature);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getTarget", "()Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "CALLEE", this.m_calleeClassSignature);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getThis", "()Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "CALLER", this.m_callerClassSignature);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getCallerClass", "()Ljava/lang/Class;", null, null);
        cv.visitFieldInsn(178, this.m_joinPointClassName, "THIS_CLASS", "Ljava/lang/Class;");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getCalleeClass", "()Ljava/lang/Class;", null, null);
        cv.visitFieldInsn(178, this.m_joinPointClassName, "TARGET_CLASS", "Ljava/lang/Class;");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getTargetClass", "()Ljava/lang/Class;", null, null);
        cv.visitFieldInsn(178, this.m_joinPointClassName, "TARGET_CLASS", "Ljava/lang/Class;");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getType", "()Lorg/codehaus/aspectwerkz/joinpoint/management/JoinPointType;", null, null);
        AsmHelper.loadIntegerConstant(cv, this.m_joinPointType);
        cv.visitMethodInsn(184, Type.getType(JoinPointType.class).getInternalName(), "fromInt", "(I)" + Type.getType(JoinPointType.class).getDescriptor());
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getEnclosingStaticJoinPoint", "()Lorg/codehaus/aspectwerkz/joinpoint/EnclosingStaticJoinPoint;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(178, this.m_joinPointClassName, "ENCLOSINGSJP", "Lorg/codehaus/aspectwerkz/joinpoint/EnclosingStaticJoinPoint;");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
    }

    protected String buildInvokeMethodSignature() {
        StringBuffer invokeDescBuf = new StringBuffer();
        invokeDescBuf.append('(');
        if (this.m_joinPointType != 4 && !Modifier.isStatic(this.m_calleeMemberModifiers)) {
            invokeDescBuf.append(this.m_calleeClassSignature);
        }
        for (int i = 0; i < this.m_argumentTypes.length; ++i) {
            Type type = this.m_argumentTypes[i];
            invokeDescBuf.append(type.getDescriptor());
        }
        invokeDescBuf.append(this.m_callerClassSignature);
        invokeDescBuf.append(')');
        invokeDescBuf.append(this.m_returnType.getDescriptor());
        return invokeDescBuf.toString();
    }

    private boolean requiresThisOrTarget() {
        return this.m_isThisAdvisable || this.requiresThisOrTarget(this.m_aroundAdviceMethodInfos) || this.requiresThisOrTarget(this.m_beforeAdviceMethodInfos) || this.requiresThisOrTarget(this.m_afterFinallyAdviceMethodInfos) || this.requiresThisOrTarget(this.m_afterReturningAdviceMethodInfos) || this.requiresThisOrTarget(this.m_afterThrowingAdviceMethodInfos);
    }

    private boolean requiresJoinPoint() {
        if (this.m_isThisAdvisable || this.requiresJoinPoint(this.m_aroundAdviceMethodInfos) || this.requiresJoinPoint(this.m_beforeAdviceMethodInfos) || this.requiresJoinPoint(this.m_afterFinallyAdviceMethodInfos) || this.requiresJoinPoint(this.m_afterReturningAdviceMethodInfos) || this.requiresJoinPoint(this.m_afterThrowingAdviceMethodInfos)) {
            return true;
        }
        for (int i = 0; i < this.m_aspectModels.length; ++i) {
            if (!this.m_aspectModels[i].requiresReflectiveInfo()) continue;
            return true;
        }
        return false;
    }

    private boolean requiresThisOrTarget(AdviceMethodInfo[] adviceMethodInfos) {
        for (int i = 0; i < adviceMethodInfos.length; ++i) {
            if (!adviceMethodInfos[i].requiresThisOrTarget()) continue;
            return true;
        }
        return false;
    }

    private boolean requiresJoinPoint(AdviceMethodInfo[] adviceMethodInfos) {
        for (int i = 0; i < adviceMethodInfos.length; ++i) {
            if (!adviceMethodInfos[i].requiresJoinPoint()) continue;
            return true;
        }
        return false;
    }

    private Label beginRuntimeCheck(MethodVisitor cv, CompilerInput input, AdviceInfo adviceInfo) {
        Label endRuntimeCheckLabel = null;
        DeploymentModel deploymentModel = adviceInfo.getAspectDeploymentModel();
        if (adviceInfo.hasTargetWithRuntimeCheck() || adviceInfo.getAdviceDefinition().hasCflowOrCflowBelow() || DeploymentModel.PER_THIS.equals(deploymentModel) || DeploymentModel.PER_TARGET.equals(deploymentModel)) {
            int perObjectCheckType = -1;
            if (DeploymentModel.PER_THIS.equals(deploymentModel)) {
                perObjectCheckType = 1;
            } else if (DeploymentModel.PER_TARGET.equals(deploymentModel)) {
                perObjectCheckType = 2;
            }
            endRuntimeCheckLabel = new Label();
            RuntimeCheckVisitor runtimeCheckVisitor = new RuntimeCheckVisitor(cv, adviceInfo.getExpressionInfo(), input, perObjectCheckType, adviceInfo.getAspectQualifiedName());
            runtimeCheckVisitor.pushCheckOnStack(adviceInfo);
            cv.visitJumpInsn(153, endRuntimeCheckLabel);
        }
        return endRuntimeCheckLabel;
    }

    private void endRuntimeCheck(MethodVisitor cv, AdviceInfo adviceInfo, Label label) {
        DeploymentModel deployModel = adviceInfo.getAspectDeploymentModel();
        if (adviceInfo.hasTargetWithRuntimeCheck() || adviceInfo.getAdviceDefinition().hasCflowOrCflowBelow() || DeploymentModel.PER_THIS.equals(deployModel) || DeploymentModel.PER_TARGET.equals(deployModel)) {
            cv.visitLabel(label);
        }
    }

    public static void loadCallee(MethodVisitor cv, CompilerInput input) {
        if (input.isOptimizedJoinPoint) {
            cv.visitVarInsn(25, input.calleeIndex);
        } else {
            AbstractJoinPointCompiler.loadJoinPointInstance(cv, input);
            cv.visitFieldInsn(180, input.joinPointClassName, "CALLEE", input.calleeClassSignature);
        }
    }

    public static void loadCaller(MethodVisitor cv, CompilerInput input) {
        if (input.isOptimizedJoinPoint) {
            cv.visitVarInsn(25, input.callerIndex);
        } else {
            AbstractJoinPointCompiler.loadJoinPointInstance(cv, input);
            cv.visitFieldInsn(180, input.joinPointClassName, "CALLER", input.callerClassSignature);
        }
    }

    private void createInitializationForAdvisableManagement(MethodVisitor cv, int joinPointInstanceIndex, int advisableIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitInsn(2);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
        this.initializeAroundInterceptors(cv, joinPointInstanceIndex, advisableIndex);
        this.initializeBeforeInterceptors(cv, joinPointInstanceIndex, advisableIndex);
        this.initializeAfterInterceptors(cv, joinPointInstanceIndex, advisableIndex);
        this.initializeAfterReturningInterceptors(cv, joinPointInstanceIndex, advisableIndex);
        this.initializeAfterThrowingInterceptors(cv, joinPointInstanceIndex, advisableIndex);
    }

    private void initializeAroundInterceptors(MethodVisitor cv, int joinPointInstanceIndex, int advisableIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, advisableIndex);
        cv.visitTypeInsn(192, "org/codehaus/aspectwerkz/intercept/Advisable");
        cv.visitLdcInsn(new Integer(this.m_joinPointClassName.hashCode()));
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/Advisable", "aw$getAroundAdvice", "(I)[Lorg/codehaus/aspectwerkz/intercept/AroundAdvice;");
        cv.visitFieldInsn(181, this.m_joinPointClassName, "AROUND_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AroundAdvice;");
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AROUND_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AroundAdvice;");
        cv.visitInsn(190);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_AROUND_INTERCEPTORS", "I");
    }

    private void initializeBeforeInterceptors(MethodVisitor cv, int joinPointInstanceIndex, int advisableIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, advisableIndex);
        cv.visitTypeInsn(192, "org/codehaus/aspectwerkz/intercept/Advisable");
        cv.visitLdcInsn(new Integer(this.m_joinPointClassName.hashCode()));
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/Advisable", "aw$getBeforeAdvice", "(I)[Lorg/codehaus/aspectwerkz/intercept/BeforeAdvice;");
        cv.visitFieldInsn(181, this.m_joinPointClassName, "BEFORE_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/BeforeAdvice;");
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "BEFORE_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/BeforeAdvice;");
        cv.visitInsn(190);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_BEFORE_INTERCEPTORS", "I");
    }

    private void initializeAfterInterceptors(MethodVisitor cv, int joinPointInstanceIndex, int advisableIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, advisableIndex);
        cv.visitTypeInsn(192, "org/codehaus/aspectwerkz/intercept/Advisable");
        cv.visitLdcInsn(new Integer(this.m_joinPointClassName.hashCode()));
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/Advisable", "aw$getAfterAdvice", "(I)[Lorg/codehaus/aspectwerkz/intercept/AfterAdvice;");
        cv.visitFieldInsn(181, this.m_joinPointClassName, "AFTER_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterAdvice;");
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterAdvice;");
        cv.visitInsn(190);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_AFTER_INTERCEPTORS", "I");
    }

    private void initializeAfterReturningInterceptors(MethodVisitor cv, int joinPointInstanceIndex, int advisableIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, advisableIndex);
        cv.visitTypeInsn(192, "org/codehaus/aspectwerkz/intercept/Advisable");
        cv.visitLdcInsn(new Integer(this.m_joinPointClassName.hashCode()));
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/Advisable", "aw$getAfterReturningAdvice", "(I)[Lorg/codehaus/aspectwerkz/intercept/AfterReturningAdvice;");
        cv.visitFieldInsn(181, this.m_joinPointClassName, "AFTER_RETURNING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterReturningAdvice;");
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_RETURNING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterReturningAdvice;");
        cv.visitInsn(190);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_AFTER_RETURNING_INTERCEPTORS", "I");
    }

    private void initializeAfterThrowingInterceptors(MethodVisitor cv, int joinPointInstanceIndex, int advisableIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, advisableIndex);
        cv.visitTypeInsn(192, "org/codehaus/aspectwerkz/intercept/Advisable");
        cv.visitLdcInsn(new Integer(this.m_joinPointClassName.hashCode()));
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/Advisable", "aw$getAfterThrowingAdvice", "(I)[Lorg/codehaus/aspectwerkz/intercept/AfterThrowingAdvice;");
        cv.visitFieldInsn(181, this.m_joinPointClassName, "AFTER_THROWING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterThrowingAdvice;");
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_THROWING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterThrowingAdvice;");
        cv.visitInsn(190);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_AFTER_THROWING_INTERCEPTORS", "I");
    }

    private void createAroundInterceptorInvocations(MethodVisitor cv) {
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
        cv.visitInsn(2);
        Label ifStatementLabel = new Label();
        cv.visitJumpInsn(159, ifStatementLabel);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_AROUND_INTERCEPTORS", "I");
        cv.visitJumpInsn(162, ifStatementLabel);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AROUND_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AroundAdvice;");
        cv.visitVarInsn(25, 0);
        cv.visitInsn(89);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
        cv.visitInsn(90);
        cv.visitInsn(4);
        cv.visitInsn(96);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
        cv.visitInsn(50);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/AroundAdvice", "invoke", "(Lorg/codehaus/aspectwerkz/joinpoint/JoinPoint;)Ljava/lang/Object;");
        cv.visitInsn(176);
        cv.visitLabel(ifStatementLabel);
    }

    private void createBeforeInterceptorInvocations(MethodVisitor cv, int joinPointInstanceIndex, int registerDepth) {
        int loopIndex = registerDepth + 1;
        cv.visitInsn(3);
        cv.visitVarInsn(54, loopIndex);
        Label loopStartLabel = new Label();
        cv.visitLabel(loopStartLabel);
        cv.visitVarInsn(21, loopIndex);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_BEFORE_INTERCEPTORS", "I");
        Label loopCheckCondLabel = new Label();
        cv.visitJumpInsn(162, loopCheckCondLabel);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "BEFORE_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/BeforeAdvice;");
        cv.visitVarInsn(21, loopIndex);
        cv.visitInsn(50);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/BeforeAdvice", "invoke", "(Lorg/codehaus/aspectwerkz/joinpoint/JoinPoint;)V");
        cv.visitIincInsn(loopIndex, 1);
        cv.visitJumpInsn(167, loopStartLabel);
        cv.visitLabel(loopCheckCondLabel);
    }

    private void createAfterInterceptorInvocations(MethodVisitor cv, int joinPointInstanceIndex, int registerDepth) {
        int loopIndex = registerDepth + 1;
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_AFTER_INTERCEPTORS", "I");
        cv.visitInsn(4);
        cv.visitInsn(100);
        cv.visitVarInsn(54, loopIndex);
        Label loopLabel1 = new Label();
        cv.visitLabel(loopLabel1);
        cv.visitVarInsn(21, loopIndex);
        Label loopLabel2 = new Label();
        cv.visitJumpInsn(155, loopLabel2);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterAdvice;");
        cv.visitVarInsn(21, loopIndex);
        cv.visitInsn(50);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/AfterAdvice", "invoke", "(Lorg/codehaus/aspectwerkz/joinpoint/JoinPoint;)V");
        cv.visitIincInsn(loopIndex, -1);
        cv.visitJumpInsn(167, loopLabel1);
        cv.visitLabel(loopLabel2);
    }

    private void createAfterReturningInterceptorInvocations(MethodVisitor cv, int joinPointInstanceIndex, int returnValueInstanceIndex) {
        int loopIndex = returnValueInstanceIndex + 1;
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_AFTER_RETURNING_INTERCEPTORS", "I");
        cv.visitInsn(4);
        cv.visitInsn(100);
        cv.visitVarInsn(54, loopIndex);
        Label loopLabel1 = new Label();
        cv.visitLabel(loopLabel1);
        cv.visitVarInsn(21, loopIndex);
        Label loopLabel2 = new Label();
        cv.visitJumpInsn(155, loopLabel2);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_RETURNING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterReturningAdvice;");
        cv.visitVarInsn(21, loopIndex);
        cv.visitInsn(50);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, returnValueInstanceIndex);
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/AfterReturningAdvice", "invoke", "(Lorg/codehaus/aspectwerkz/joinpoint/JoinPoint;Ljava/lang/Object;)V");
        cv.visitIincInsn(loopIndex, -1);
        cv.visitJumpInsn(167, loopLabel1);
        cv.visitLabel(loopLabel2);
    }

    private void createAfterThrowingInterceptorInvocations(MethodVisitor cv, int joinPointInstanceIndex, int exceptionInstanceIndex) {
        int loopIndex = exceptionInstanceIndex + 1;
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_AFTER_THROWING_INTERCEPTORS", "I");
        cv.visitInsn(4);
        cv.visitInsn(100);
        cv.visitVarInsn(54, loopIndex);
        Label loopLabel1 = new Label();
        cv.visitLabel(loopLabel1);
        cv.visitVarInsn(21, loopIndex);
        Label loopLabel2 = new Label();
        cv.visitJumpInsn(155, loopLabel2);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_THROWING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterThrowingAdvice;");
        cv.visitVarInsn(21, loopIndex);
        cv.visitInsn(50);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, exceptionInstanceIndex);
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/AfterThrowingAdvice", "invoke", "(Lorg/codehaus/aspectwerkz/joinpoint/JoinPoint;Ljava/lang/Throwable;)V");
        cv.visitIincInsn(loopIndex, -1);
        cv.visitJumpInsn(167, loopLabel1);
        cv.visitLabel(loopLabel2);
    }

    private boolean requiresProceedMethod() {
        return this.m_hasAroundAdvices || this.m_isThisAdvisable;
    }

    static boolean requiresCallerInstance(DeploymentModel deployModel) {
        return DeploymentModel.PER_INSTANCE.equals(deployModel) || DeploymentModel.PER_THIS.equals(deployModel);
    }

    static boolean requiresCalleeInstance(DeploymentModel deployModel) {
        return DeploymentModel.PER_TARGET.equals(deployModel);
    }

    static boolean requiresCallerOrCallee(DeploymentModel deploymentModel) {
        return AbstractJoinPointCompiler.requiresCallerInstance(deploymentModel) || AbstractJoinPointCompiler.requiresCalleeInstance(deploymentModel);
    }

    public final AspectModel[] getAspectModels() {
        return this.m_aspectModels;
    }
}

