/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.definition.MixinDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AlreadyAddedMethodVisitor;

public class AddMixinMethodsVisitor
extends ClassAdapter
implements TransformationConstants {
    private final ContextImpl m_ctx;
    private String m_declaringTypeName;
    private final ClassInfo m_classInfo;
    private final Set m_addedMethods;
    private ExpressionContext m_expressionContext;
    private boolean m_hasClinit = false;
    private Map m_mixinFields;
    private boolean m_isAdvised = false;

    public AddMixinMethodsVisitor(ClassVisitor cv, ClassInfo classInfo, Context ctx, Set addedMethods) {
        super(cv);
        this.m_classInfo = classInfo;
        this.m_ctx = (ContextImpl)ctx;
        this.m_addedMethods = addedMethods;
        this.m_expressionContext = new ExpressionContext(PointcutType.WITHIN, this.m_classInfo, this.m_classInfo);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        ExpressionContext ctx = new ExpressionContext(PointcutType.WITHIN, this.m_classInfo, this.m_classInfo);
        if (!AddMixinMethodsVisitor.classFilter(this.m_classInfo, ctx, this.m_ctx.getDefinitions())) {
            this.m_declaringTypeName = name;
            this.m_mixinFields = new HashMap();
            for (int i = 0; i < this.m_classInfo.getFields().length; ++i) {
                FieldInfo fieldInfo = this.m_classInfo.getFields()[i];
                if (!fieldInfo.getName().startsWith("aw$MIXIN_")) continue;
                this.m_mixinFields.put(fieldInfo.getType(), fieldInfo);
            }
            this.addMixinMembers();
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    private void addMixinMembers() {
        int index = 0;
        Iterator it = this.m_ctx.getDefinitions().iterator();
        while (it.hasNext()) {
            List mixinDefs = ((SystemDefinition)it.next()).getMixinDefinitions(this.m_expressionContext);
            HashSet interfaceSet = new HashSet();
            Iterator it2 = mixinDefs.iterator();
            while (it2.hasNext()) {
                interfaceSet.addAll(((MixinDefinition)it2.next()).getInterfaceClassNames());
            }
            for (MixinDefinition mixinDef : mixinDefs) {
                ClassInfo mixinImpl = mixinDef.getMixinImpl();
                DeploymentModel deploymentModel = mixinDef.getDeploymentModel();
                if (this.m_mixinFields.containsKey(mixinImpl)) continue;
                MixinFieldInfo fieldInfo = new MixinFieldInfo();
                fieldInfo.fieldName = "aw$MIXIN_" + index;
                fieldInfo.mixinClassInfo = mixinImpl;
                this.addMixinField(fieldInfo, deploymentModel, mixinDef);
                this.addMixinMethods(fieldInfo, mixinDef);
                ++index;
                this.m_isAdvised = true;
            }
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.m_isAdvised) {
            if (name.equals("<clinit>")) {
                this.m_hasClinit = true;
                PrependToClinitMethodCodeAdapter mv = new PrependToClinitMethodCodeAdapter(this.cv.visitMethod(access, name, desc, signature, exceptions));
                mv.visitMaxs(0, 0);
                return mv;
            }
            if (name.equals("<init>")) {
                AppendToInitMethodCodeAdapter mv = new AppendToInitMethodCodeAdapter(this.cv.visitMethod(access, name, desc, signature, exceptions));
                mv.visitMaxs(0, 0);
                return mv;
            }
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitEnd() {
        if (this.m_isAdvised && !this.m_hasClinit) {
            MethodVisitor mv = this.cv.visitMethod(8, "<clinit>", "()V", null, null);
            for (MixinFieldInfo fieldInfo : this.m_mixinFields.values()) {
                if (!fieldInfo.isStatic) continue;
                this.initializeStaticMixinField(mv, fieldInfo);
            }
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }
        super.visitEnd();
    }

    private void initializeStaticMixinField(MethodVisitor mv, MixinFieldInfo fieldInfo) {
        mv.visitLdcInsn(fieldInfo.mixinClassInfo.getName().replace('/', '.'));
        if (fieldInfo.isPerJVM) {
            mv.visitFieldInsn(178, this.m_declaringTypeName, "aw$clazz", "Ljava/lang/Class;");
            mv.visitMethodInsn(182, "java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;");
            mv.visitMethodInsn(184, "org/codehaus/aspectwerkz/aspect/management/Mixins", "mixinOf", "(Ljava/lang/String;Ljava/lang/ClassLoader;)Ljava/lang/Object;");
        } else {
            mv.visitFieldInsn(178, this.m_declaringTypeName, "aw$clazz", "Ljava/lang/Class;");
            mv.visitMethodInsn(184, "org/codehaus/aspectwerkz/aspect/management/Mixins", "mixinOf", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;");
        }
        mv.visitTypeInsn(192, fieldInfo.mixinClassInfo.getName().replace('.', '/'));
        mv.visitFieldInsn(179, this.m_declaringTypeName, fieldInfo.fieldName, fieldInfo.mixinClassInfo.getSignature());
    }

    private void initializeMemberMixinField(MethodVisitor mv, MixinFieldInfo fieldInfo) {
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(fieldInfo.mixinClassInfo.getName().replace('/', '.'));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "org/codehaus/aspectwerkz/aspect/management/Mixins", "mixinOf", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, fieldInfo.mixinClassInfo.getName().replace('.', '/'));
        mv.visitFieldInsn(181, this.m_declaringTypeName, fieldInfo.fieldName, fieldInfo.mixinClassInfo.getSignature());
    }

    private void addMixinField(MixinFieldInfo fieldInfo, DeploymentModel deploymentModel, MixinDefinition mixinDef) {
        String signature = fieldInfo.mixinClassInfo.getSignature();
        int modifiers = 0;
        if (deploymentModel.equals(DeploymentModel.PER_CLASS) || deploymentModel.equals(DeploymentModel.PER_JVM)) {
            fieldInfo.isStatic = true;
            fieldInfo.isPerJVM = deploymentModel.equals(DeploymentModel.PER_JVM);
            modifiers = 4122;
        } else if (deploymentModel.equals(DeploymentModel.PER_INSTANCE)) {
            fieldInfo.isStatic = false;
            modifiers = 4114;
        } else {
            throw new DefinitionException("deployment model [" + mixinDef.getDeploymentModel() + "] for mixin [" + mixinDef.getMixinImpl().getName() + "] is not supported");
        }
        if (mixinDef.isTransient()) {
            modifiers += 128;
        }
        this.cv.visitField(modifiers, fieldInfo.fieldName, signature, null, null);
        this.m_mixinFields.put(mixinDef.getMixinImpl(), fieldInfo);
    }

    private void addMixinMethods(MixinFieldInfo fieldInfo, MixinDefinition mixinDef) {
        for (MethodInfo methodInfo : mixinDef.getMethodsToIntroduce()) {
            String methodSignature;
            String methodName = methodInfo.getName();
            if (this.m_addedMethods.contains(AlreadyAddedMethodVisitor.getMethodKey(methodName, methodSignature = methodInfo.getSignature()))) continue;
            MethodVisitor mv = this.cv.visitMethod(4097, methodName, methodSignature, null, null);
            if (fieldInfo.isStatic) {
                mv.visitFieldInsn(178, this.m_declaringTypeName, fieldInfo.fieldName, fieldInfo.mixinClassInfo.getSignature());
            } else {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.m_declaringTypeName, fieldInfo.fieldName, fieldInfo.mixinClassInfo.getSignature());
            }
            AsmHelper.loadArgumentTypes(mv, Type.getArgumentTypes(methodSignature), false);
            mv.visitMethodInsn(182, fieldInfo.mixinClassInfo.getName().replace('.', '/'), methodName, methodSignature);
            AsmHelper.addReturnStatement(mv, Type.getReturnType(methodSignature));
            mv.visitMaxs(0, 0);
        }
    }

    public static boolean classFilter(ClassInfo classInfo, ExpressionContext ctx, Set definitions) {
        for (SystemDefinition systemDef : definitions) {
            if (classInfo.isInterface()) {
                return true;
            }
            String className = classInfo.getName().replace('/', '.');
            if (systemDef.inExcludePackage(className)) {
                return true;
            }
            if (!systemDef.inIncludePackage(className)) {
                return true;
            }
            if (!systemDef.hasMixin(ctx)) continue;
            return false;
        }
        return true;
    }

    private static class MixinFieldInfo {
        private String fieldName;
        private ClassInfo mixinClassInfo;
        private boolean isStatic;
        private boolean isPerJVM = false;

        private MixinFieldInfo() {
        }
    }

    public class AppendToInitMethodCodeAdapter
    extends MethodAdapter {
        public AppendToInitMethodCodeAdapter(MethodVisitor ca) {
            super(ca);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                for (MixinFieldInfo fieldInfo : AddMixinMethodsVisitor.this.m_mixinFields.values()) {
                    if (fieldInfo.isStatic) continue;
                    AddMixinMethodsVisitor.this.initializeMemberMixinField(this.mv, fieldInfo);
                }
            }
            super.visitInsn(opcode);
        }
    }

    public class PrependToClinitMethodCodeAdapter
    extends MethodAdapter {
        public PrependToClinitMethodCodeAdapter(MethodVisitor ca) {
            super(ca);
            for (MixinFieldInfo fieldInfo : AddMixinMethodsVisitor.this.m_mixinFields.values()) {
                if (!fieldInfo.isStatic) continue;
                AddMixinMethodsVisitor.this.initializeStaticMixinField(ca, fieldInfo);
            }
        }
    }
}

