/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.codehaus.backport175.com.thoughtworks.qdox.model.DocletTag;
import org.codehaus.backport175.com.thoughtworks.qdox.model.JavaClass;
import org.codehaus.backport175.com.thoughtworks.qdox.model.JavaField;
import org.codehaus.backport175.com.thoughtworks.qdox.model.JavaMethod;
import org.codehaus.backport175.compiler.AnnotationInterfaceRepository;
import org.codehaus.backport175.compiler.CompilerException;
import org.codehaus.backport175.compiler.MessageHandler;
import org.codehaus.backport175.compiler.bytecode.AnnotationEnhancer;
import org.codehaus.backport175.compiler.javadoc.JavaDocParser;
import org.codehaus.backport175.compiler.javadoc.RawAnnotation;
import org.codehaus.backport175.compiler.javadoc.SourceParseException;
import org.codehaus.backport175.compiler.parser.ParseException;

public class AnnotationC {
    private static final String COMMAND_LINE_OPTION_DASH = "-";
    private static final String COMMAND_LINE_OPTION_VERBOSE = "-verbose";
    private static final String COMMAND_LINE_OPTION_IGNOREUNKNOWN = "-ignoreUnknown";
    private static final String COMMAND_LINE_OPTION_CONFIG = "-config";
    private static final String COMMAND_LINE_OPTION_SRC = "-src";
    private static final String COMMAND_LINE_OPTION_SRCFILES = "-srcfiles";
    private static final String COMMAND_LINE_OPTION_SRCINCLUDES = "-srcincludes";
    private static final String COMMAND_LINE_OPTION_CLASSES = "-classes";
    private static final String COMMAND_LINE_OPTION_DEST = "-dest";
    private static final String FILE_SEPARATOR = File.separator;
    private final MessageHandler m_handler;
    private final ClassLoader m_loader;
    private final boolean m_ignoreUnknown;
    private final JavaDocParser m_javaDocParser;
    private final AnnotationInterfaceRepository m_repository;
    static /* synthetic */ Class class$org$codehaus$backport175$compiler$AnnotationC;

    private AnnotationC(ClassLoader loader, JavaDocParser parser, AnnotationInterfaceRepository repository, MessageHandler handler, boolean ignoreUnknown) {
        this.m_loader = loader;
        this.m_javaDocParser = parser;
        this.m_repository = repository;
        this.m_handler = handler;
        this.m_ignoreUnknown = ignoreUnknown;
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            AnnotationC.printUsage();
        }
        Map commandLineOptions = AnnotationC.parseCommandLineOptions(args);
        String propertiesFilesPath = (String)commandLineOptions.get(COMMAND_LINE_OPTION_CONFIG);
        ArrayList<String> propertiesFilesList = new ArrayList<String>();
        if (propertiesFilesPath != null) {
            StringTokenizer st = new StringTokenizer(propertiesFilesPath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                propertiesFilesList.add(st.nextToken());
            }
        }
        String[] propertiesFiles = propertiesFilesList.toArray(new String[0]);
        AnnotationC.compile("true".equals(commandLineOptions.get(COMMAND_LINE_OPTION_VERBOSE)), "true".equals(commandLineOptions.get(COMMAND_LINE_OPTION_IGNOREUNKNOWN)), (String)commandLineOptions.get(COMMAND_LINE_OPTION_SRC), (String)commandLineOptions.get(COMMAND_LINE_OPTION_SRCFILES), (String)commandLineOptions.get(COMMAND_LINE_OPTION_SRCINCLUDES), (String)commandLineOptions.get(COMMAND_LINE_OPTION_CLASSES), (String)commandLineOptions.get(COMMAND_LINE_OPTION_DEST), propertiesFiles);
    }

    private static void compile(boolean verbose, boolean ignoreUnknown, String srcDirList, String srcFileList, String srcFileIncludes, String classPath, String destDir, String[] annotationPropetiesFiles) {
        if (srcDirList == null && srcFileList == null && srcFileIncludes == null) {
            throw new IllegalArgumentException("one of src or srcfiles or srcincludes must be not null");
        }
        if (srcDirList != null && srcFileList != null || srcDirList != null && srcFileIncludes != null || srcFileList != null && srcFileIncludes != null) {
            throw new IllegalArgumentException("maximum one of src, srcfiles or srcincludes must be not null");
        }
        if (classPath == null) {
            throw new IllegalArgumentException("class path can not be null");
        }
        if (destDir == null) {
            destDir = classPath;
        }
        String[] srcDirs = new String[]{};
        String[] srcFiles = new String[]{};
        if (srcDirList != null) {
            srcDirs = AnnotationC.split(srcDirList, File.pathSeparator);
        } else {
            srcFiles = srcFileList != null ? AnnotationC.split(srcFileList, FILE_SEPARATOR) : AnnotationC.loadSourceList(srcFileIncludes);
        }
        AnnotationC.compile(srcDirs, srcFiles, AnnotationC.split(classPath, File.pathSeparator), destDir, annotationPropetiesFiles, new MessageHandler.PrintWriter(verbose), ignoreUnknown);
    }

    public static void compile(String[] srcDirs, String[] srcFiles, String[] classpath, String destDir, String[] annotationPropertiesFiles, MessageHandler messageHandler, boolean ignoreUnknown) {
        URLClassLoader compilationLoader;
        URL[] classPath = new URL[classpath.length];
        try {
            for (int i = 0; i < classpath.length; ++i) {
                classPath[i] = new File(classpath[i]).toURL();
            }
            compilationLoader = new URLClassLoader(classPath, (class$org$codehaus$backport175$compiler$AnnotationC == null ? (class$org$codehaus$backport175$compiler$AnnotationC = AnnotationC.class$("org.codehaus.backport175.compiler.AnnotationC")) : class$org$codehaus$backport175$compiler$AnnotationC).getClassLoader());
        }
        catch (MalformedURLException e) {
            String message = "URL [" + classPath + "] is not valid: " + e.toString();
            messageHandler.error(new CompilerException(message, e));
            return;
        }
        String destDirToUse = destDir;
        if (destDir == null) {
            if (classpath.length != 1) {
                messageHandler.error(new CompilerException("destDir must be specified since classpath is composite"));
                return;
            }
            destDirToUse = classpath[0];
        }
        JavaDocParser javaDocParser = new JavaDocParser();
        try {
            int i;
            javaDocParser.addClassLoaderToSearchPath(compilationLoader);
            StringBuffer logDirs = new StringBuffer("parsing source dirs:");
            for (i = 0; i < srcDirs.length; ++i) {
                logDirs.append("\n\t" + srcDirs[i]);
            }
            messageHandler.info(logDirs.toString());
            javaDocParser.addSourceTrees(srcDirs);
            logDirs = new StringBuffer();
            for (i = 0; i < srcFiles.length; ++i) {
                logDirs.append("\n\t" + srcFiles[i]);
                javaDocParser.addSource(srcFiles[i]);
            }
            if (srcFiles.length > 0) {
                messageHandler.info(logDirs.toString());
            }
            AnnotationInterfaceRepository repository = new AnnotationInterfaceRepository(messageHandler);
            repository.registerPropertiesFiles(annotationPropertiesFiles, compilationLoader);
            AnnotationC compiler = new AnnotationC(compilationLoader, javaDocParser, repository, messageHandler, ignoreUnknown);
            compiler.doCompile(classPath, destDirToUse);
            if (ignoreUnknown) {
                Iterator iterator = repository.getIgnoredDocletNames().iterator();
                while (iterator.hasNext()) {
                    String doclet = (String)iterator.next();
                    messageHandler.info("ignored: @" + doclet);
                }
            }
        }
        catch (SourceParseException e) {
            messageHandler.error(e);
            return;
        }
        catch (CompilerException e) {
            messageHandler.error(e);
            return;
        }
        catch (Throwable t) {
            messageHandler.error(new CompilerException("unexpected exception: " + t.toString(), t));
            return;
        }
    }

    private void doCompile(URL[] classPath, String destDir) {
        this.logInfo("compiling annotations...");
        JavaClass[] classes = this.m_javaDocParser.getJavaClasses();
        for (int i = 0; i < classes.length; ++i) {
            JavaClass clazz = classes[i];
            this.logInfo("parsing class [" + clazz.getFullyQualifiedName() + ']');
            try {
                AnnotationEnhancer enhancer = new AnnotationEnhancer(this.m_handler);
                if (!enhancer.initialize(clazz.getFullyQualifiedName(), classPath)) continue;
                this.handleClassAnnotations(enhancer, clazz);
                JavaMethod[] methods = clazz.getMethods();
                for (int j = 0; j < methods.length; ++j) {
                    JavaMethod method = methods[j];
                    if (method.isConstructor()) {
                        this.handleConstructorAnnotations(enhancer, method);
                        continue;
                    }
                    this.handleMethodAnnotations(enhancer, method);
                }
                JavaField[] fields = clazz.getFields();
                for (int j = 0; j < fields.length; ++j) {
                    this.handleFieldAnnotations(enhancer, fields[j]);
                }
                enhancer.write(destDir);
                continue;
            }
            catch (ParseException pe) {
                this.m_handler.error(pe);
                continue;
            }
            catch (CompilerException ce) {
                this.m_handler.error(ce);
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.m_handler.error(new CompilerException("could not compile annotations for class [" + clazz.getFullyQualifiedName() + "] due to: " + t.toString()));
                return;
            }
        }
        this.logInfo("compiled classes written to " + destDir);
        this.logInfo("compilation successful");
    }

    private void handleClassAnnotations(AnnotationEnhancer enhancer, JavaClass clazz) {
        DocletTag[] tags = clazz.getTags();
        for (int i = 0; i < tags.length; ++i) {
            RawAnnotation rawAnnotation = this.getRawAnnotation(tags[i], enhancer.getClassName(), enhancer.getClassFileName());
            if (rawAnnotation == null) continue;
            enhancer.insertClassAnnotation(rawAnnotation);
            this.logInfo("\tprocessing class annotation [" + rawAnnotation.getName() + " @ " + clazz.getFullyQualifiedName() + ']');
        }
    }

    private void handleMethodAnnotations(AnnotationEnhancer enhancer, JavaMethod method) {
        DocletTag[] tags = method.getTags();
        for (int i = 0; i < tags.length; ++i) {
            RawAnnotation rawAnnotation = this.getRawAnnotation(tags[i], enhancer.getClassName(), enhancer.getClassFileName());
            if (rawAnnotation == null) continue;
            enhancer.insertMethodAnnotation(method, rawAnnotation);
            this.logInfo("\tprocessing method annotation [" + rawAnnotation.getName() + " @ " + method.getParentClass().getName() + '.' + method.getName() + ']');
        }
    }

    private void handleConstructorAnnotations(AnnotationEnhancer enhancer, JavaMethod constructor) {
        DocletTag[] tags = constructor.getTags();
        for (int i = 0; i < tags.length; ++i) {
            RawAnnotation rawAnnotation = this.getRawAnnotation(tags[i], enhancer.getClassName(), enhancer.getClassFileName());
            if (rawAnnotation == null) continue;
            enhancer.insertConstructorAnnotation(constructor, rawAnnotation);
            this.logInfo("\tprocessing constructor annotation [" + rawAnnotation.getName() + " @ " + constructor.getParentClass().getName() + '.' + constructor.getName() + ']');
        }
    }

    private void handleFieldAnnotations(AnnotationEnhancer enhancer, JavaField field) {
        DocletTag[] tags = field.getTags();
        for (int i = 0; i < tags.length; ++i) {
            RawAnnotation rawAnnotation = this.getRawAnnotation(tags[i], enhancer.getClassName(), enhancer.getClassFileName());
            if (rawAnnotation == null) continue;
            enhancer.insertFieldAnnotation(field, rawAnnotation);
            this.logInfo("\tprocessing field annotation [" + rawAnnotation.getName() + " @ " + field.getName() + ']');
        }
    }

    private RawAnnotation getRawAnnotation(DocletTag tag, String enclosingClassName, String enclosingClassFileName) {
        Class annotationInterface;
        String annotationName = tag.getName();
        int index = annotationName.indexOf(40);
        if (index != -1) {
            annotationName = annotationName.substring(0, index);
        }
        if ((annotationInterface = this.m_repository.getAnnotationInterfaceFor(annotationName, this.m_loader)) == null) {
            if (!this.m_ignoreUnknown) {
                this.logInfo("JavaDoc tag [" + annotationName + "] is not treated as an annotation - class could not be resolved" + " at " + enclosingClassName + " in " + enclosingClassFileName + ", line " + tag.getLineNumber());
            }
            return null;
        }
        return JavaDocParser.getRawAnnotation(annotationInterface, annotationName, tag, enclosingClassName, enclosingClassFileName);
    }

    private static void printUsage() {
        System.out.println("backport175 (c) 2002-2005 Jonas Bon\u00e9r, Alexandre Vasseur");
        System.out.println("usage: java [options...] org.codehaus.backport175.compiler.AnnotationC [-verbose] [-ignoreUnknown] -src <path to src dir> | -srcfiles <list of files> | -srcincludes <path to file> -classes <path to classes dir> [-dest <path to destination dir>] [-config <property file>]");
        System.out.println("       -src <path to src dir> - provides the list of source directories separated by 'File.pathSeparator'");
        System.out.println("       -srcfiles <list of files> - provides a comma separated list of source files");
        System.out.println("       -srcincludes <path to file> - provides the path to a file containing the list of source files (one name per line)");
        System.out.println("       -dest <path to destination dir> - optional, if omitted the compiled classes will be written to the initial directory");
        System.out.println("       -config <property file with aliases to the FQN of the annotation interfaces> - optional");
        System.out.println("       -verbose - activates compilation status information");
        System.out.println("       -ignoreUnknown - turn off traces for unknown annotations and print a summary at the end instead if -verbose is set");
        System.out.println("");
        System.out.println("Note: only one of -src -srcpath and -srcincludes may be used");
        System.exit(0);
    }

    private static Map parseCommandLineOptions(String[] args) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(COMMAND_LINE_OPTION_VERBOSE)) {
                    arguments.put(COMMAND_LINE_OPTION_VERBOSE, "true");
                    continue;
                }
                if (args[i].equals(COMMAND_LINE_OPTION_IGNOREUNKNOWN)) {
                    arguments.put(COMMAND_LINE_OPTION_IGNOREUNKNOWN, "true");
                    continue;
                }
                if (!args[i].startsWith(COMMAND_LINE_OPTION_DASH)) continue;
                String option = args[i];
                String value = args[++i];
                arguments.put(option, value);
            }
        }
        catch (Exception e) {
            System.err.println("options list to compiler is not valid");
            System.exit(1);
        }
        return arguments;
    }

    public void logInfo(String message) {
        this.m_handler.info(message);
    }

    private static String[] split(String str, String sep) {
        if (str == null || str.length() == 0) {
            return new String[0];
        }
        int start = 0;
        int idx = str.indexOf(sep, start);
        int len = sep.length();
        ArrayList<String> strings = new ArrayList<String>();
        while (idx != -1) {
            strings.add(str.substring(start, idx));
            start = idx + len;
            idx = str.indexOf(sep, start);
        }
        strings.add(str.substring(start));
        return strings.toArray(new String[strings.size()]);
    }

    private static String[] loadSourceList(String srcIncludes) {
        File currentDir = new File(".");
        ArrayList<String> files = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(srcIncludes));
            String line = reader.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    File tmpFile = new File(currentDir, line);
                    if (!tmpFile.isFile()) {
                        System.err.println("file not found: [" + tmpFile + "]");
                    } else {
                        files.add(tmpFile.getAbsolutePath());
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioe) {
            throw new CompilerException("an error occured while reading from pattern file: " + srcIncludes, ioe);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {}
            }
        }
        return files.toArray(new String[files.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

