/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api.clock;

import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.api.clock.PrimitiveClock;
import org.multiverse.instrumentation.InstrumentationStamp;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class StrictPrimitiveClock
implements PrimitiveClock {
    private final AtomicLong clock = new AtomicLong();

    public StrictPrimitiveClock() {
        this(0L);
    }

    public StrictPrimitiveClock(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        this.clock.set(time);
    }

    @Override
    public long strictTick() {
        return this.tick();
    }

    @Override
    public long tick() {
        return this.clock.incrementAndGet();
    }

    @Override
    public long tickTo(long version) {
        long current;
        do {
            if (version >= (current = this.clock.get())) continue;
            return current;
        } while (!this.clock.compareAndSet(current, version));
        return version;
    }

    @Override
    public long getVersion() {
        return this.clock.get();
    }

    public String toString() {
        return String.format("StrictPrimitiveClock(time=%s)", this.clock.get());
    }
}

