/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldgranularity;

import org.multiverse.instrumentation.AbstractInstrumentationPhase;
import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.Environment;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.repackaged.org.objectweb.asm.tree.ClassNode;
import org.multiverse.stms.alpha.instrumentation.fieldgranularity.FieldGranularityTransformer;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class FieldGranularityInstrumentationPhase
extends AbstractInstrumentationPhase {
    public FieldGranularityInstrumentationPhase() {
        super("FieldGranularityInstrumentationPhase");
    }

    @Override
    protected Clazz doInstrument(Environment environment, Clazz originalClazz) {
        ClassMetadata metadata = environment.getMetadataRepository().loadClassMetadata(originalClazz.getClassLoader(), originalClazz.getName());
        if (!metadata.hasManagedFieldsWithFieldGranularity()) {
            return originalClazz;
        }
        ClassNode originalNode = AsmUtils.loadAsClassNode(originalClazz.getBytecode());
        FieldGranularityTransformer transformer = new FieldGranularityTransformer(originalClazz.getClassLoader(), originalNode, environment.getMetadataRepository());
        ClassNode transformed = transformer.transform();
        return new Clazz(originalClazz, AsmUtils.toBytecode(transformed));
    }
}

