/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.transactionalobject;

import org.multiverse.instrumentation.AbstractInstrumentationPhase;
import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.Environment;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.repackaged.org.objectweb.asm.tree.ClassNode;
import org.multiverse.stms.alpha.instrumentation.transactionalobject.TransactionalObjectTransformer;
import org.multiverse.stms.alpha.mixins.BasicMixin;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class TransactionalObjectInstrumentationPhase
extends AbstractInstrumentationPhase {
    public TransactionalObjectInstrumentationPhase() {
        super("TransactionalObjectInstrumentationPhase");
    }

    @Override
    protected Clazz doInstrument(Environment environment, Clazz originalClazz) {
        ClassMetadata classMetadata = environment.getMetadataRepository().loadClassMetadata(originalClazz.getClassLoader(), originalClazz.getName());
        if (!classMetadata.isTransactionalObjectWithObjectGranularFields()) {
            environment.getLog().lessImportant("%s is not a real transactional object", originalClazz.getName());
            return originalClazz;
        }
        environment.getLog().lessImportant("%s is a real transactional object", originalClazz.getName());
        ClassNode mixinClassNode = AsmUtils.loadAsClassNode(BasicMixin.class);
        ClassNode originalClassNode = AsmUtils.loadAsClassNode(originalClazz.getBytecode());
        TransactionalObjectTransformer transformer = new TransactionalObjectTransformer(originalClazz.getClassLoader(), originalClassNode, mixinClassNode, environment.getMetadataRepository());
        ClassNode result = transformer.transform();
        return new Clazz(originalClazz, AsmUtils.toBytecode(result));
    }
}

