/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.multiverse.MultiverseConstants;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.TransactionStatus;
import org.multiverse.api.backoff.BackoffPolicy;
import org.multiverse.api.exceptions.ControlFlowError;
import org.multiverse.api.exceptions.NoTransactionAllowedException;
import org.multiverse.api.exceptions.NoTransactionFoundException;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.api.exceptions.RetryTimeoutException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.api.latches.StandardLatch;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.templates.InvisibleCheckedException;
import org.multiverse.templates.TransactionalCallable;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class TransactionBoilerplate
implements MultiverseConstants {
    private final boolean threadLocalAware;
    private final TransactionFactory transactionFactory;
    private final TransactionLifecycleListener listener;

    public TransactionBoilerplate() {
        this(GlobalStmInstance.getGlobalStmInstance());
    }

    public TransactionBoilerplate(Stm stm) {
        this(stm.getTransactionFactoryBuilder().build());
    }

    public TransactionBoilerplate(TransactionFactory transactionFactory) {
        this(transactionFactory, null, true);
    }

    public TransactionBoilerplate(TransactionFactory transactionFactory, TransactionLifecycleListener listener, boolean threadLocalAware) {
        if (transactionFactory == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
        this.transactionFactory = transactionFactory;
        this.threadLocalAware = threadLocalAware;
    }

    public boolean isThreadLocalAware() {
        return this.threadLocalAware;
    }

    public TransactionLifecycleListener getTransactionLifecycleListener() {
        return this.listener;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    protected void onStart(Transaction tx) {
    }

    public <E> E execute(TransactionalCallable<E> callable) {
        if (callable == null) {
            throw new NullPointerException("callable can't be null");
        }
        try {
            return this.executeChecked(callable);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new InvisibleCheckedException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E executeChecked(TransactionalCallable<E> callable) throws Exception {
        if (callable == null) {
            throw new NullPointerException("callable can't be null");
        }
        Transaction tx = this.threadLocalAware ? ThreadLocalTransaction.getThreadLocalTransaction() : null;
        switch (this.transactionFactory.getTransactionConfiguration().getPropagationLevel()) {
            case Requires: {
                if (!TransactionBoilerplate.isDead(tx)) {
                    return callable.call(tx);
                }
                if (this.sameTransactionFactory(tx)) {
                    tx.reset();
                    tx.setAttempt(0);
                    tx.setRemainingTimeoutNs(tx.getConfiguration().getTimeoutNs());
                } else {
                    tx = this.transactionFactory.create();
                }
                if (this.threadLocalAware) {
                    ThreadLocalTransaction.setThreadLocalTransaction(tx);
                }
                return this.executeWithTransaction(tx, callable);
            }
            case Mandatory: {
                if (TransactionBoilerplate.isDead(tx)) {
                    throw new NoTransactionFoundException();
                }
                return callable.call(tx);
            }
            case RequiresNew: {
                Transaction suspendedTx = tx;
                try {
                    tx = this.transactionFactory.create();
                    if (this.threadLocalAware) {
                        ThreadLocalTransaction.setThreadLocalTransaction(tx);
                    }
                    E e = this.executeWithTransaction(tx, callable);
                    return e;
                }
                finally {
                    if (this.threadLocalAware) {
                        ThreadLocalTransaction.setThreadLocalTransaction(suspendedTx);
                    }
                }
            }
            case Never: {
                if (!TransactionBoilerplate.isDead(tx)) {
                    throw new NoTransactionAllowedException();
                }
                return callable.call(null);
            }
            case Supports: {
                if (TransactionBoilerplate.isDead(tx)) {
                    return callable.call(null);
                }
                return callable.call(tx);
            }
        }
        throw new IllegalStateException();
    }

    private boolean sameTransactionFactory(Transaction tx) {
        return tx != null && tx.getTransactionFactory() == this.transactionFactory;
    }

    private <E> E executeWithTransaction(Transaction tx, TransactionalCallable<E> callable) throws Exception {
        Throwable lastFailureCause = null;
        if (this.listener != null) {
            this.listener.notify(tx, TransactionLifecycleEvent.PostStart);
        }
        while (true) {
            E e;
            tx.setAttempt(tx.getAttempt() + 1);
            try {
                TransactionBoilerplate.logStart(tx);
                if (this.listener != null) {
                    tx.registerLifecycleListener(this.listener);
                }
                this.onStart(tx);
                E result = callable.call(tx);
                tx.commit();
                e = result;
            }
            catch (Retry e2) {
                try {
                    TransactionBoilerplate.handleRetry(tx);
                    continue;
                }
                catch (SpeculativeConfigurationFailure ex) {
                    tx = this.handleSpeculativeConfigurationFailure(tx);
                    continue;
                }
                catch (ControlFlowError er) {
                    TransactionBoilerplate.handleControlFlowError(tx, er);
                }
                if (tx.getAttempt() - 1 < tx.getConfiguration().getMaxRetries()) continue;
                String msg = String.format("Too many retries on transaction '%s', maxRetries = %s", tx.getConfiguration().getFamilyName(), tx.getConfiguration().getMaxRetries());
                throw new TooManyRetriesException(msg, lastFailureCause);
            }
            return e;
            break;
        }
        finally {
            if (tx != null && tx.getStatus() != TransactionStatus.Committed) {
                tx.abort();
            }
        }
    }

    private static void logStart(Transaction tx) {
        if (___TRACING_ENABLED && tx.getConfiguration().getTraceLevel().isLogableFrom(TraceLevel.course)) {
            System.out.println(tx.getConfiguration().getFamilyName() + " starting");
        }
    }

    private static void handleControlFlowError(Transaction tx, ControlFlowError er) {
        if (___TRACING_ENABLED && tx.getConfiguration().getTraceLevel().isLogableFrom(TraceLevel.course)) {
            System.out.println(tx.getConfiguration().getFamilyName() + " " + er.getDescription());
        }
        BackoffPolicy backoffPolicy = tx.getConfiguration().getBackoffPolicy();
        backoffPolicy.delayedUninterruptible(tx);
        tx.reset();
    }

    private Transaction handleSpeculativeConfigurationFailure(Transaction oldTx) {
        if (___TRACING_ENABLED && oldTx.getConfiguration().getTraceLevel().isLogableFrom(TraceLevel.course)) {
            System.out.println(oldTx.getConfiguration().getFamilyName() + " speculative configuration failure");
        }
        oldTx.abort();
        Object newTx = this.transactionFactory.create();
        newTx.setAttempt(oldTx.getAttempt());
        newTx.setRemainingTimeoutNs(oldTx.getRemainingTimeoutNs());
        if (this.threadLocalAware) {
            ThreadLocalTransaction.setThreadLocalTransaction(newTx);
        }
        return newTx;
    }

    private static void handleRetry(Transaction tx) throws InterruptedException {
        if (___TRACING_ENABLED && tx.getConfiguration().getTraceLevel().isLogableFrom(TraceLevel.course)) {
            System.out.println(tx.getConfiguration().getFamilyName() + " retry (blocking)");
        }
        if (tx.getAttempt() - 1 < tx.getConfiguration().getMaxRetries()) {
            Latch latch = tx.getRemainingTimeoutNs() == Long.MAX_VALUE ? new CheapLatch() : new StandardLatch();
            tx.registerRetryLatch(latch);
            tx.abort();
            if (tx.getRemainingTimeoutNs() == Long.MAX_VALUE) {
                if (tx.getConfiguration().isInterruptible()) {
                    latch.await();
                } else {
                    latch.awaitUninterruptible();
                }
            } else {
                long beginNs = System.nanoTime();
                boolean timeout = tx.getConfiguration().isInterruptible() ? !latch.tryAwaitNs(tx.getRemainingTimeoutNs()) : !latch.tryAwaitNs(tx.getRemainingTimeoutNs());
                long durationNs = System.nanoTime() - beginNs;
                tx.setRemainingTimeoutNs(tx.getRemainingTimeoutNs() - durationNs);
                if (timeout) {
                    String msg = String.format("Transaction %s has timed with a total timeout of %s ns", tx.getConfiguration().getFamilyName(), tx.getConfiguration().getTimeoutNs());
                    throw new RetryTimeoutException(msg);
                }
            }
            tx.reset();
        }
    }

    private static boolean isDead(Transaction t) {
        return t == null || t.getStatus().isDead();
    }
}

