/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.executors;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.multiverse.MultiverseConstants;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Listeners;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.ConstructorCantRetryException;
import org.multiverse.api.exceptions.ControlFlowError;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.latches.Latch;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.stms.alpha.AlphaStmUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.RegisterRetryListenerResult;
import org.multiverse.stms.alpha.instrumentation.transactionalmethod.TransactionLogicDonor;
import org.multiverse.stms.alpha.mixins.BasicMixin;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.transactional.collections.TransactionalLinkedList;
import org.multiverse.transactional.collections.TransactionalQueue;
import org.multiverse.transactional.executors.TransactionalThreadPoolExecutor__Tranlocal;
import org.multiverse.utils.Bugshaker;
import org.multiverse.utils.TodoException;

@TransactionalObject
@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class TransactionalThreadPoolExecutor
extends AbstractExecutorService
implements MultiverseConstants,
AlphaTransactionalObject {
    public TransactionalQueue<Runnable> workQueue;
    public TransactionalLinkedList<Thread> threads;
    public AtomicLong workerIdGenerator;
    private static final AtomicReferenceFieldUpdater<BasicMixin, Transaction> ___LOCKOWNER_UPDATER;
    private static final AtomicReferenceFieldUpdater<BasicMixin, Listeners> ___LISTENERS_UPDATER;
    private volatile Transaction ___lockOwner;
    private volatile AlphaTranlocal ___tranlocal;
    private volatile Listeners ___listeners;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349449877254;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349450117822;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349450284535;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349450452498;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349450616677;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349450838587;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349451031670;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349451199724;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349451376667;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349451550602;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349451718297;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349451883078;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349452049613;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349452224967;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349452399843;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349452566981;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349452731468;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349452906028;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349453077996;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349453256323;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349453416217;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349453574412;
    public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349453734244;

    public TransactionalThreadPoolExecutor() {
        AlphaTransaction tx = (AlphaTransaction)ThreadLocalTransaction.getThreadLocalTransaction();
        if (TransactionLogicDonor.isActiveTransaction(tx)) {
            this(tx);
            return;
        }
        tx = TransactionLogicDonor.createTransaction(tx, ___transactionFactory_2002349449877254);
        tx.setAttempt(1);
        ThreadLocalTransaction.setThreadLocalTransaction(tx);
        try {
            this(tx);
            tx.commit();
            tx = null;
        }
        catch (Throwable throwable) {
            tx.abort();
            if (throwable instanceof ControlFlowError) {
                throw new ConstructorCantRetryException();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw (Exception)throwable;
        }
        finally {
            ThreadLocalTransaction.clearThreadLocalTransaction();
        }
    }

    public TransactionalThreadPoolExecutor(AlphaTransaction transaction) {
        this(new TransactionalLinkedList(1000000, true, transaction), 1, transaction);
    }

    public TransactionalThreadPoolExecutor(int arg1) {
        AlphaTransaction tx = (AlphaTransaction)ThreadLocalTransaction.getThreadLocalTransaction();
        if (TransactionLogicDonor.isActiveTransaction(tx)) {
            this(arg1, tx);
            return;
        }
        tx = TransactionLogicDonor.createTransaction(tx, ___transactionFactory_2002349450117822);
        tx.setAttempt(1);
        ThreadLocalTransaction.setThreadLocalTransaction(tx);
        try {
            this(arg1, tx);
            tx.commit();
            tx = null;
        }
        catch (Throwable throwable) {
            tx.abort();
            if (throwable instanceof ControlFlowError) {
                throw new ConstructorCantRetryException();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw (Exception)throwable;
        }
        finally {
            ThreadLocalTransaction.clearThreadLocalTransaction();
        }
    }

    public TransactionalThreadPoolExecutor(int poolSize, AlphaTransaction transaction) {
        this(new TransactionalLinkedList(1000000, true, transaction), poolSize, transaction);
    }

    public TransactionalThreadPoolExecutor(TransactionalQueue<Runnable> arg1) {
        AlphaTransaction tx = (AlphaTransaction)ThreadLocalTransaction.getThreadLocalTransaction();
        if (TransactionLogicDonor.isActiveTransaction(tx)) {
            this(arg1, tx);
            return;
        }
        tx = TransactionLogicDonor.createTransaction(tx, ___transactionFactory_2002349450284535);
        tx.setAttempt(1);
        ThreadLocalTransaction.setThreadLocalTransaction(tx);
        try {
            this(arg1, tx);
            tx.commit();
            tx = null;
        }
        catch (Throwable throwable) {
            tx.abort();
            if (throwable instanceof ControlFlowError) {
                throw new ConstructorCantRetryException();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw (Exception)throwable;
        }
        finally {
            ThreadLocalTransaction.clearThreadLocalTransaction();
        }
    }

    public TransactionalThreadPoolExecutor(TransactionalQueue workQueue, AlphaTransaction transaction) {
        this(workQueue, 1, transaction);
    }

    public TransactionalThreadPoolExecutor(TransactionalQueue<Runnable> arg1, int arg2) {
        AlphaTransaction tx = (AlphaTransaction)ThreadLocalTransaction.getThreadLocalTransaction();
        if (TransactionLogicDonor.isActiveTransaction(tx)) {
            this(arg1, arg2, tx);
            return;
        }
        tx = TransactionLogicDonor.createTransaction(tx, ___transactionFactory_2002349450452498);
        tx.setAttempt(1);
        ThreadLocalTransaction.setThreadLocalTransaction(tx);
        try {
            this(arg1, arg2, tx);
            tx.commit();
            tx = null;
        }
        catch (Throwable throwable) {
            tx.abort();
            if (throwable instanceof ControlFlowError) {
                throw new ConstructorCantRetryException();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw (Exception)throwable;
        }
        finally {
            ThreadLocalTransaction.clearThreadLocalTransaction();
        }
    }

    public TransactionalThreadPoolExecutor(TransactionalQueue workQueue, int corePoolSize, AlphaTransaction transaction) {
        transaction.openForConstruction(this);
        this.threads = new TransactionalLinkedList(transaction);
        this.workerIdGenerator = new AtomicLong();
        if (workQueue == null) {
            throw new NullPointerException();
        }
        if (corePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        ((TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this)).corePoolSize = corePoolSize;
        this.workQueue = workQueue;
        ((TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this)).state = State.unstarted;
        ((TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this)).threadFactory = new ThreadFactory(){
            final AtomicLong idGenerator = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "worker-" + this.idGenerator.incrementAndGet());
            }
        };
    }

    /*
     * Exception decompiling
     */
    public int getCorePoolSize() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getCorePoolSize___ro(AlphaTransaction alphaTransaction) {
        return this.getCorePoolSize___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public int getCorePoolSize___up(AlphaTransaction alphaTransaction) {
        return this.getCorePoolSize___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public int getCorePoolSize___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return tranlocalThis.corePoolSize;
    }

    public int getCorePoolSize___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).corePoolSize;
    }

    /*
     * Exception decompiling
     */
    public void setCorePoolSize(int arg1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setCorePoolSize___ro(int n, AlphaTransaction alphaTransaction) {
        this.setCorePoolSize___ro(n, alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void setCorePoolSize___up(int n, AlphaTransaction alphaTransaction) {
        this.setCorePoolSize___up(n, alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void setCorePoolSize___ro(int newCorePoolSize, AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        if (newCorePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        switch (tranlocalThis.state) {
            case unstarted: {
                (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).corePoolSize = newCorePoolSize;
                break;
            }
            case started: {
                int extra = newCorePoolSize - tranlocalThis.corePoolSize;
                if (extra == 0) {
                    return;
                }
                if (extra > 0) {
                    this.createAndRegisterWorkers___ro(extra, transaction, tranlocalThis);
                }
                (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).corePoolSize = newCorePoolSize;
                break;
            }
            case shutdown: {
                throw new IllegalStateException();
            }
            case terminated: {
                throw new IllegalStateException();
            }
        }
    }

    public void setCorePoolSize___up(int newCorePoolSize, AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        if (newCorePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        switch ((!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state) {
            case unstarted: {
                (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).corePoolSize = newCorePoolSize;
                break;
            }
            case started: {
                int extra = newCorePoolSize - (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).corePoolSize;
                if (extra == 0) {
                    return;
                }
                if (extra > 0) {
                    this.createAndRegisterWorkers___up(extra, transaction, tranlocalThis);
                }
                (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).corePoolSize = newCorePoolSize;
                break;
            }
            case shutdown: {
                throw new IllegalStateException();
            }
            case terminated: {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public int getCurrentPoolSize() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getCurrentPoolSize___ro(AlphaTransaction alphaTransaction) {
        return this.getCurrentPoolSize___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public int getCurrentPoolSize___up(AlphaTransaction alphaTransaction) {
        return this.getCurrentPoolSize___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public int getCurrentPoolSize___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return this.threads.size___ro(transaction);
    }

    public int getCurrentPoolSize___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return this.threads.size___up(transaction);
    }

    /*
     * Exception decompiling
     */
    public BlockingQueue<Runnable> getWorkQueue() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BlockingQueue getWorkQueue___ro(AlphaTransaction alphaTransaction) {
        return this.getWorkQueue___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public BlockingQueue getWorkQueue___up(AlphaTransaction alphaTransaction) {
        return this.getWorkQueue___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public BlockingQueue getWorkQueue___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return this.workQueue;
    }

    public BlockingQueue getWorkQueue___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return this.workQueue;
    }

    /*
     * Exception decompiling
     */
    public State getState() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public State getState___ro(AlphaTransaction alphaTransaction) {
        return this.getState___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public State getState___up(AlphaTransaction alphaTransaction) {
        return this.getState___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public State getState___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return tranlocalThis.state;
    }

    public State getState___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state;
    }

    /*
     * Exception decompiling
     */
    public void setThreadFactory(ThreadFactory arg1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setThreadFactory___ro(ThreadFactory threadFactory, AlphaTransaction alphaTransaction) {
        this.setThreadFactory___ro(threadFactory, alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void setThreadFactory___up(ThreadFactory threadFactory, AlphaTransaction alphaTransaction) {
        this.setThreadFactory___up(threadFactory, alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void setThreadFactory___ro(ThreadFactory threadFactory, AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).threadFactory = threadFactory;
    }

    public void setThreadFactory___up(ThreadFactory threadFactory, AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).threadFactory = threadFactory;
    }

    /*
     * Exception decompiling
     */
    public ThreadFactory getThreadFactory() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ThreadFactory getThreadFactory___ro(AlphaTransaction alphaTransaction) {
        return this.getThreadFactory___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public ThreadFactory getThreadFactory___up(AlphaTransaction alphaTransaction) {
        return this.getThreadFactory___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public ThreadFactory getThreadFactory___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return tranlocalThis.threadFactory;
    }

    public ThreadFactory getThreadFactory___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).threadFactory;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void shutdown() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void shutdown___ro(AlphaTransaction alphaTransaction) {
        this.shutdown___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void shutdown___up(AlphaTransaction alphaTransaction) {
        this.shutdown___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void shutdown___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        switch (tranlocalThis.state) {
            case unstarted: {
                (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.terminated;
                break;
            }
            case started: {
                (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.shutdown;
                break;
            }
            case shutdown: {
                break;
            }
            case terminated: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void shutdown___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        switch ((!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state) {
            case unstarted: {
                (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.terminated;
                break;
            }
            case started: {
                (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.shutdown;
                break;
            }
            case shutdown: {
                break;
            }
            case terminated: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Runnable> shutdownNow() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List shutdownNow___ro(AlphaTransaction alphaTransaction) {
        return this.shutdownNow___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public List shutdownNow___up(AlphaTransaction alphaTransaction) {
        return this.shutdownNow___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public List shutdownNow___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        switch (tranlocalThis.state) {
            case unstarted: {
                (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.terminated;
                return Collections.EMPTY_LIST;
            }
            case started: 
            case shutdown: {
                LinkedList sink = new LinkedList();
                this.workQueue.drainTo___ro(sink, transaction);
                if (this.threads.isEmpty___ro(transaction)) {
                    (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.terminated;
                } else {
                    (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.shutdown;
                    ThreadLocalTransaction.getThreadLocalTransaction().registerLifecycleListener(new InterruptWorkersListener());
                }
                return sink;
            }
            case terminated: {
                return Collections.EMPTY_LIST;
            }
        }
        throw new IllegalStateException();
    }

    public List shutdownNow___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        switch ((!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state) {
            case unstarted: {
                (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.terminated;
                return Collections.EMPTY_LIST;
            }
            case started: 
            case shutdown: {
                LinkedList sink = new LinkedList();
                this.workQueue.drainTo___up(sink, transaction);
                if (this.threads.isEmpty___up(transaction)) {
                    (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.terminated;
                } else {
                    (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.shutdown;
                    ThreadLocalTransaction.getThreadLocalTransaction().registerLifecycleListener(new InterruptWorkersListener());
                }
                return sink;
            }
            case terminated: {
                return Collections.EMPTY_LIST;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isShutdown() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isShutdown___ro(AlphaTransaction alphaTransaction) {
        return this.isShutdown___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public boolean isShutdown___up(AlphaTransaction alphaTransaction) {
        return this.isShutdown___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isShutdown___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        if (tranlocalThis.state == State.shutdown) return true;
        if (tranlocalThis.state != State.terminated) return false;
        return true;
    }

    public boolean isShutdown___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state == State.shutdown || (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state == State.terminated;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isTerminated() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isTerminated___ro(AlphaTransaction alphaTransaction) {
        return this.isTerminated___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public boolean isTerminated___up(AlphaTransaction alphaTransaction) {
        return this.isTerminated___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public boolean isTerminated___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return tranlocalThis.state == State.terminated;
    }

    public boolean isTerminated___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state == State.terminated;
    }

    /*
     * Exception decompiling
     */
    public boolean isStarted() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isStarted___ro(AlphaTransaction alphaTransaction) {
        return this.isStarted___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public boolean isStarted___up(AlphaTransaction alphaTransaction) {
        return this.isStarted___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public boolean isStarted___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return tranlocalThis.state == State.started;
    }

    public boolean isStarted___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        return (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state == State.started;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean awaitTermination(long arg1, TimeUnit arg2) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean awaitTermination___ro(long l, TimeUnit timeUnit, AlphaTransaction alphaTransaction) throws InterruptedException {
        return this.awaitTermination___ro(l, timeUnit, alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public boolean awaitTermination___up(long l, TimeUnit timeUnit, AlphaTransaction alphaTransaction) throws InterruptedException {
        return this.awaitTermination___up(l, timeUnit, alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public boolean awaitTermination___ro(long timeout, TimeUnit unit, AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) throws InterruptedException {
        switch (tranlocalThis.state) {
            case unstarted: {
                throw new UnsupportedOperationException();
            }
            case started: {
                throw new UnsupportedOperationException();
            }
            case shutdown: {
                throw new UnsupportedOperationException();
            }
            case terminated: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    public boolean awaitTermination___up(long timeout, TimeUnit unit, AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) throws InterruptedException {
        switch ((!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state) {
            case unstarted: {
                throw new UnsupportedOperationException();
            }
            case started: {
                throw new UnsupportedOperationException();
            }
            case shutdown: {
                throw new UnsupportedOperationException();
            }
            case terminated: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * Exception decompiling
     */
    public void awaitTermination() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void awaitTermination___ro(AlphaTransaction alphaTransaction) throws InterruptedException {
        this.awaitTermination___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void awaitTermination___up(AlphaTransaction alphaTransaction) throws InterruptedException {
        this.awaitTermination___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void awaitTermination___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) throws InterruptedException {
        if (tranlocalThis.state != State.terminated) {
            StmUtils.retry();
        }
    }

    public void awaitTermination___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) throws InterruptedException {
        if ((!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state != State.terminated) {
            StmUtils.retry();
        }
    }

    /*
     * Exception decompiling
     */
    public void awaitTerminationUninterruptibly() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void awaitTerminationUninterruptibly___ro(AlphaTransaction alphaTransaction) {
        this.awaitTerminationUninterruptibly___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void awaitTerminationUninterruptibly___up(AlphaTransaction alphaTransaction) {
        this.awaitTerminationUninterruptibly___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void awaitTerminationUninterruptibly___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        if (tranlocalThis.state != State.terminated) {
            StmUtils.retry();
        }
    }

    public void awaitTerminationUninterruptibly___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        if ((!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state != State.terminated) {
            StmUtils.retry();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void execute(Runnable arg1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void execute___ro(Runnable runnable, AlphaTransaction alphaTransaction) {
        this.execute___ro(runnable, alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void execute___up(Runnable runnable, AlphaTransaction alphaTransaction) {
        this.execute___up(runnable, alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void execute___ro(Runnable command, AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        if (command == null) {
            throw new NullPointerException();
        }
        switch (tranlocalThis.state) {
            case unstarted: {
                this.start___ro(transaction, tranlocalThis);
            }
            case started: {
                boolean workOffered = this.workQueue.offer___ro(command, transaction);
                if (workOffered) break;
                throw new RejectedExecutionException();
            }
            case shutdown: {
                throw new RejectedExecutionException();
            }
            case terminated: {
                throw new RejectedExecutionException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void execute___up(Runnable command, AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        if (command == null) {
            throw new NullPointerException();
        }
        switch ((!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state) {
            case unstarted: {
                this.start___up(transaction, tranlocalThis);
            }
            case started: {
                boolean workOffered = this.workQueue.offer___up(command, transaction);
                if (workOffered) break;
                throw new RejectedExecutionException();
            }
            case shutdown: {
                throw new RejectedExecutionException();
            }
            case terminated: {
                throw new RejectedExecutionException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void start() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void start___ro(AlphaTransaction alphaTransaction) {
        this.start___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void start___up(AlphaTransaction alphaTransaction) {
        this.start___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    public void start___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        switch (tranlocalThis.state) {
            case unstarted: {
                (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.started;
                this.createAndRegisterWorkers___ro(tranlocalThis.corePoolSize, transaction, tranlocalThis);
                break;
            }
            case started: {
                break;
            }
            case shutdown: {
                throw new IllegalStateException();
            }
            case terminated: {
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void start___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        switch ((!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).state) {
            case unstarted: {
                (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.started;
                this.createAndRegisterWorkers___up((!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this))).corePoolSize, transaction, tranlocalThis);
                break;
            }
            case started: {
                break;
            }
            case shutdown: {
                throw new IllegalStateException();
            }
            case terminated: {
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void createAndRegisterWorkers(int arg1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createAndRegisterWorkers___ro(int n, AlphaTransaction alphaTransaction) {
        this.createAndRegisterWorkers___ro(n, alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    private void createAndRegisterWorkers___up(int n, AlphaTransaction alphaTransaction) {
        this.createAndRegisterWorkers___up(n, alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    private void createAndRegisterWorkers___ro(int workerCount, AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        Thread[] newThreads = new Thread[workerCount];
        for (int k = 0; k < workerCount; ++k) {
            Worker worker = new Worker();
            Thread thread = tranlocalThis.threadFactory.newThread(worker);
            thread.setName("Worker-" + this.workerIdGenerator.incrementAndGet());
            worker.thread = thread;
            this.threads.add___ro(thread, transaction);
            newThreads[k] = thread;
        }
        ThreadLocalTransaction.getThreadLocalTransaction().registerLifecycleListener(new StartWorkersListener(newThreads));
    }

    private void createAndRegisterWorkers___up(int workerCount, AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        Thread[] newThreads = new Thread[workerCount];
        for (int k = 0; k < workerCount; ++k) {
            Worker worker = new Worker();
            Thread thread = (!tranlocalThis.isCommitted() ? tranlocalThis : (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForRead((AlphaTransactionalObject)this)).threadFactory.newThread(worker);
            thread.setName("Worker-" + this.workerIdGenerator.incrementAndGet());
            worker.thread = thread;
            this.threads.add___up(thread, transaction);
            newThreads[k] = thread;
        }
        ThreadLocalTransaction.getThreadLocalTransaction().registerLifecycleListener(new StartWorkersListener(newThreads));
    }

    /*
     * Exception decompiling
     */
    private void signalTerminated() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void signalTerminated___ro(AlphaTransaction alphaTransaction) {
        this.signalTerminated___ro(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    private void signalTerminated___up(AlphaTransaction alphaTransaction) {
        this.signalTerminated___up(alphaTransaction, (TransactionalThreadPoolExecutor__Tranlocal)alphaTransaction.openForRead(this));
    }

    private void signalTerminated___ro(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.terminated;
    }

    private void signalTerminated___up(AlphaTransaction transaction, TransactionalThreadPoolExecutor__Tranlocal tranlocalThis) {
        (!tranlocalThis.isCommitted() ? tranlocalThis : (tranlocalThis = (TransactionalThreadPoolExecutor__Tranlocal)transaction.openForWrite((AlphaTransactionalObject)this))).state = State.terminated;
    }

    static {
        ___transactionFactory_2002349453734244 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.signalTerminated()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349453574412 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.createAndRegisterWorkers(int)").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349453416217 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.start()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349453256323 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.execute(Runnable)").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349453077996 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadonly(true).setReadTrackingEnabled(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.awaitTerminationUninterruptibly()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349452906028 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadonly(true).setReadTrackingEnabled(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.awaitTermination()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(true).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349452731468 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadonly(true).setReadTrackingEnabled(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.awaitTermination(long,j.u.c.TimeUnit)").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(true).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349452566981 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadonly(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.isStarted()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349452399843 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadonly(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.isTerminated()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349452224967 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadonly(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.isShutdown()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349452049613 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadTrackingEnabled(false).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.shutdownNow()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349451883078 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.shutdown()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349451718297 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadonly(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.getThreadFactory()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349451550602 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadTrackingEnabled(false).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.setThreadFactory(j.u.c.ThreadFactory)").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349451376667 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadonly(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.getState()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349451199724 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadonly(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.getWorkQueue()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349451031670 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadonly(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.getCurrentPoolSize()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349450838587 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadTrackingEnabled(false).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.setCorePoolSize(int)").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349450616677 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setReadonly(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.getCorePoolSize()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349450452498 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.<init>(o.m.t.c.TransactionalQueue,int)").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(0).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349450284535 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.<init>(o.m.t.c.TransactionalQueue)").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(0).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349450117822 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.<init>(int)").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(0).setTimeoutNs(Long.MAX_VALUE).build();
        ___transactionFactory_2002349449877254 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor.<init>()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(0).setTimeoutNs(Long.MAX_VALUE).build();
        ___LOCKOWNER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TransactionalThreadPoolExecutor.class, Transaction.class, "___lockOwner");
        ___LISTENERS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TransactionalThreadPoolExecutor.class, Listeners.class, "___listeners");
    }

    @Override
    public final AlphaTranlocal ___load() {
        return this.___tranlocal;
    }

    @Override
    public final AlphaTranlocal ___load(long readVersion) {
        AlphaTranlocal second;
        AlphaTranlocal first;
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if ((first = this.___tranlocal) == null) {
            return null;
        }
        long firstVersion = first.getWriteVersion();
        if (firstVersion == readVersion) {
            return first;
        }
        if (firstVersion > readVersion) {
            throw this.createOldVersionNotFoundReadConflict(readVersion, first);
        }
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if (this.___lockOwner != null) {
            throw this.createLockNotFreeReadConflict();
        }
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if (first == (second = this.___tranlocal)) {
            return first;
        }
        if (second.getWriteVersion() == readVersion) {
            return second;
        }
        throw this.createOldVersionNotFoundReadConflict(readVersion, second);
    }

    private LockNotFreeReadConflict createLockNotFreeReadConflict() {
        if (LockNotFreeReadConflict.reuse) {
            return LockNotFreeReadConflict.INSTANCE;
        }
        String msg = String.format("Failed to load already locked transactionalobject '%s'", AlphaStmUtils.toTxObjectString(this));
        return new LockNotFreeReadConflict(msg);
    }

    private OldVersionNotFoundReadConflict createOldVersionNotFoundReadConflict(long readVersion, AlphaTranlocal found) {
        if (OldVersionNotFoundReadConflict.reuse) {
            return OldVersionNotFoundReadConflict.INSTANCE;
        }
        String msg = String.format("Can't load version '%s' transactionalobject '%s', the oldest version found is '%s'", readVersion, AlphaStmUtils.toTxObjectString(this), found.getWriteVersion());
        return new OldVersionNotFoundReadConflict(msg);
    }

    @Override
    public AlphaTranlocal ___openForCommutingOperation() {
        throw new TodoException();
    }

    @Override
    public Listeners ___storeUpdate(AlphaTranlocal update, long writeVersion, boolean releaseLock) {
        update.prepareForCommit(writeVersion);
        this.___tranlocal = update;
        Listeners listeners = null;
        if (this.___listeners != null) {
            if (___BUGSHAKER_ENABLED) {
                Bugshaker.shakeBugs();
            }
            listeners = ___LISTENERS_UPDATER.getAndSet((BasicMixin)((Object)this), null);
        }
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if (releaseLock) {
            this.___lockOwner = null;
        }
        return listeners;
    }

    @Override
    public void ___storeInitial(AlphaTranlocal tranlocal, long writeVersion) {
        tranlocal.prepareForCommit(writeVersion);
        this.___tranlocal = tranlocal;
    }

    @Override
    public final Transaction ___getLockOwner() {
        return this.___lockOwner;
    }

    @Override
    public boolean ___tryLock(Transaction lockOwner) {
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if (this.___lockOwner != null) {
            return false;
        }
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        return ___LOCKOWNER_UPDATER.compareAndSet((BasicMixin)((Object)this), null, lockOwner);
    }

    @Override
    public void ___releaseLock(Transaction expectedLockOwner) {
        if (this.___lockOwner == expectedLockOwner) {
            if (___BUGSHAKER_ENABLED) {
                Bugshaker.shakeBugs();
            }
            this.___lockOwner = null;
        }
    }

    public final Listeners ___getListeners() {
        return this.___listeners;
    }

    @Override
    public final RegisterRetryListenerResult ___registerRetryListener(Latch listener, long minimumWakeupVersion) {
        AlphaTranlocal second;
        Listeners newListeners;
        Listeners oldListeners;
        boolean registered;
        AlphaTranlocal first;
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if ((first = this.___tranlocal) == null) {
            return RegisterRetryListenerResult.noregistration;
        }
        if (first.getWriteVersion() >= minimumWakeupVersion) {
            listener.open();
            return RegisterRetryListenerResult.opened;
        }
        do {
            if (___BUGSHAKER_ENABLED) {
                Bugshaker.shakeBugs();
            }
            oldListeners = this.___listeners;
            newListeners = new Listeners(listener, oldListeners);
            registered = this.___listeners != oldListeners ? false : ___LISTENERS_UPDATER.compareAndSet((BasicMixin)((Object)this), oldListeners, newListeners);
            if (___BUGSHAKER_ENABLED) {
                Bugshaker.shakeBugs();
            }
            if (registered || first == (second = this.___tranlocal)) continue;
            listener.open();
            return RegisterRetryListenerResult.opened;
        } while (!registered);
        if (___BUGSHAKER_ENABLED) {
            Bugshaker.shakeBugs();
        }
        if (first != (second = this.___tranlocal)) {
            if (this.___listeners == newListeners) {
                ___LISTENERS_UPDATER.compareAndSet((BasicMixin)((Object)this), newListeners, oldListeners);
            }
            listener.open();
            return RegisterRetryListenerResult.opened;
        }
        return RegisterRetryListenerResult.registered;
    }

    @Override
    public /* synthetic */ AlphaTranlocal ___openUnconstructed() {
        return new TransactionalThreadPoolExecutor__Tranlocal(this);
    }

    @InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
    private class InterruptWorkersListener
    implements TransactionLifecycleListener {
        public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349390966929;

        private InterruptWorkersListener() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void notify(Transaction arg1, TransactionLifecycleEvent arg2) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void notify___ro(Transaction tx, TransactionLifecycleEvent event, AlphaTransaction transaction) {
            if (event == TransactionLifecycleEvent.PostCommit) {
                Iterator iterator = TransactionalThreadPoolExecutor.this.threads.iterator___ro(transaction);
                while (iterator.hasNext()) {
                    Thread thread = (Thread)iterator.next();
                    thread.interrupt();
                }
            }
        }

        public void notify___up(Transaction tx, TransactionLifecycleEvent event, AlphaTransaction transaction) {
            if (event == TransactionLifecycleEvent.PostCommit) {
                Iterator iterator = TransactionalThreadPoolExecutor.this.threads.iterator___up(transaction);
                while (iterator.hasNext()) {
                    Thread thread = (Thread)iterator.next();
                    thread.interrupt();
                }
            }
        }

        static {
            ___transactionFactory_2002349390966929 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor$InterruptWorkersListener.notify(o.m.a.Transaction,o.m.a.l.TransactionLifecycleEvent)").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        }
    }

    @InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
    private static class StartWorkersListener
    implements TransactionLifecycleListener {
        private final Thread[] threads;

        private StartWorkersListener(Thread ... threads) {
            this.threads = threads;
        }

        @Override
        public void notify(Transaction t, TransactionLifecycleEvent event) {
            if (event == TransactionLifecycleEvent.PostCommit) {
                for (int k = 0; k < this.threads.length; ++k) {
                    this.threads[k].start();
                }
            }
        }
    }

    @InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
    private class Worker
    implements Runnable {
        private Thread thread;
        public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349509978148;
        public static final /* synthetic */ TransactionFactory ___transactionFactory_2002349510209157;

        private Worker() {
        }

        @Override
        public void run() {
            this.work();
            this.drainWorkQueue();
            this.die();
        }

        private void work() {
            boolean again = true;
            do {
                try {
                    Runnable command = this.takeWork();
                    if (command == null) {
                        again = false;
                        continue;
                    }
                    this.execute(command);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (again);
        }

        /*
         * Exception decompiling
         */
        private Runnable takeWork() throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private Runnable takeWork___ro(AlphaTransaction transaction) throws InterruptedException {
            if (TransactionalThreadPoolExecutor.this.threads.size___ro(transaction) > ((TransactionalThreadPoolExecutor__Tranlocal)ThreadLocalTransaction.getRequiredThreadLocalTransaction().openForRead((AlphaTransactionalObject)TransactionalThreadPoolExecutor.this)).corePoolSize || TransactionalThreadPoolExecutor.this.isShutdown___ro(transaction)) {
                TransactionalThreadPoolExecutor.this.threads.remove___ro(this.thread, transaction);
                return null;
            }
            return (Runnable)TransactionalThreadPoolExecutor.this.workQueue.take___ro(transaction);
        }

        private Runnable takeWork___up(AlphaTransaction transaction) throws InterruptedException {
            if (TransactionalThreadPoolExecutor.this.threads.size___up(transaction) > ((TransactionalThreadPoolExecutor__Tranlocal)ThreadLocalTransaction.getRequiredThreadLocalTransaction().openForRead((AlphaTransactionalObject)TransactionalThreadPoolExecutor.this)).corePoolSize || TransactionalThreadPoolExecutor.this.isShutdown___up(transaction)) {
                TransactionalThreadPoolExecutor.this.threads.remove___up(this.thread, transaction);
                return null;
            }
            return (Runnable)TransactionalThreadPoolExecutor.this.workQueue.take___up(transaction);
        }

        private void drainWorkQueue() {
            boolean again = true;
            do {
                Runnable command;
                if ((command = (Runnable)TransactionalThreadPoolExecutor.this.workQueue.poll()) == null) {
                    again = false;
                    continue;
                }
                this.execute(command);
            } while (again);
        }

        /*
         * Exception decompiling
         */
        private void die() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void die___ro(AlphaTransaction transaction) {
            if (TransactionalThreadPoolExecutor.this.isShutdown___ro(transaction)) {
                TransactionalThreadPoolExecutor.this.signalTerminated();
            }
        }

        private void die___up(AlphaTransaction transaction) {
            if (TransactionalThreadPoolExecutor.this.isShutdown___up(transaction)) {
                TransactionalThreadPoolExecutor.this.signalTerminated();
            }
        }

        private void execute(Runnable command) {
            try {
                command.run();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        static {
            ___transactionFactory_2002349510209157 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor$Worker.die()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(false).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
            ___transactionFactory_2002349509978148 = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(true).setFamilyName("o.m.t.e.TransactionalThreadPoolExecutor$Worker.takeWork()").setTraceLevel(TraceLevel.valueOf("none")).setInterruptible(true).setWriteSkewAllowed(true).setMaxRetries(1000).setTimeoutNs(Long.MAX_VALUE).build();
        }
    }

    @InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
    static enum State {
        unstarted,
        started,
        shutdown,
        terminated;

    }
}

