/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Iterator;
import org.apache.camel.builder.AdviceWithTask;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.EndpointHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdviceWithTasks {
    private static final Logger LOG = LoggerFactory.getLogger(AdviceWithTasks.class);

    private AdviceWithTasks() {
    }

    public static AdviceWithTask replaceByToString(RouteDefinition route, String toString, ProcessorDefinition replace) {
        return AdviceWithTasks.doReplace(route, new MatchByToString(toString), replace);
    }

    public static AdviceWithTask replaceById(RouteDefinition route, String id, ProcessorDefinition replace) {
        return AdviceWithTasks.doReplace(route, new MatchById(id), replace);
    }

    private static AdviceWithTask doReplace(final RouteDefinition route, final MatchBy matchBy, final ProcessorDefinition replace) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                Iterator<ProcessorDefinition> it = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ProcessorDefinition.class);
                while (it.hasNext()) {
                    int index;
                    ProcessorDefinition parent;
                    ProcessorDefinition output = it.next();
                    if (!matchBy.match(output) || (parent = output.getParent()) == null || (index = parent.getOutputs().indexOf(output)) == -1) continue;
                    match = true;
                    parent.getOutputs().add(index + 1, replace);
                    ProcessorDefinition old = parent.getOutputs().remove(index);
                    LOG.info("AdviceWith (" + matchBy.getId() + ") : [" + old + "] --> replace [" + replace + "]");
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    public static AdviceWithTask removeByToString(RouteDefinition route, String toString) {
        return AdviceWithTasks.doRemove(route, new MatchByToString(toString));
    }

    public static AdviceWithTask removeById(RouteDefinition route, String id) {
        return AdviceWithTasks.doRemove(route, new MatchById(id));
    }

    private static AdviceWithTask doRemove(final RouteDefinition route, final MatchBy matchBy) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                Iterator<ProcessorDefinition> it = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ProcessorDefinition.class);
                while (it.hasNext()) {
                    int index;
                    ProcessorDefinition parent;
                    ProcessorDefinition output = it.next();
                    if (!matchBy.match(output) || (parent = output.getParent()) == null || (index = parent.getOutputs().indexOf(output)) == -1) continue;
                    match = true;
                    ProcessorDefinition old = parent.getOutputs().remove(index);
                    LOG.info("AdviceWith (" + matchBy.getId() + ") : [" + old + "] --> remove");
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    public static AdviceWithTask beforeByToString(RouteDefinition route, String toString, ProcessorDefinition before) {
        return AdviceWithTasks.doBefore(route, new MatchByToString(toString), before);
    }

    public static AdviceWithTask beforeById(RouteDefinition route, String id, ProcessorDefinition before) {
        return AdviceWithTasks.doBefore(route, new MatchById(id), before);
    }

    private static AdviceWithTask doBefore(final RouteDefinition route, final MatchBy matchBy, final ProcessorDefinition before) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                Iterator<ProcessorDefinition> it = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ProcessorDefinition.class);
                while (it.hasNext()) {
                    int index;
                    ProcessorDefinition parent;
                    ProcessorDefinition output = it.next();
                    if (!matchBy.match(output) || (parent = output.getParent()) == null || (index = parent.getOutputs().indexOf(output)) == -1) continue;
                    match = true;
                    ProcessorDefinition existing = parent.getOutputs().get(index);
                    parent.getOutputs().add(index, before);
                    LOG.info("AdviceWith (" + matchBy.getId() + ") : [" + existing + "] --> before [" + before + "]");
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    public static AdviceWithTask afterByToString(RouteDefinition route, String toString, ProcessorDefinition after) {
        return AdviceWithTasks.doAfter(route, new MatchByToString(toString), after);
    }

    public static AdviceWithTask afterById(RouteDefinition route, String id, ProcessorDefinition after) {
        return AdviceWithTasks.doAfter(route, new MatchById(id), after);
    }

    private static AdviceWithTask doAfter(final RouteDefinition route, final MatchBy matchBy, final ProcessorDefinition after) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                Iterator<ProcessorDefinition> it = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ProcessorDefinition.class);
                while (it.hasNext()) {
                    int index;
                    ProcessorDefinition parent;
                    ProcessorDefinition output = it.next();
                    if (!matchBy.match(output) || (parent = output.getParent()) == null || (index = parent.getOutputs().indexOf(output)) == -1) continue;
                    match = true;
                    ProcessorDefinition existing = parent.getOutputs().get(index);
                    parent.getOutputs().add(index + 1, after);
                    LOG.info("AdviceWith (" + matchBy.getId() + ") : [" + existing + "] --> after [" + after + "]");
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    private static final class MatchByToString
    implements MatchBy {
        private final String toString;

        private MatchByToString(String toString) {
            this.toString = toString;
        }

        @Override
        public String getId() {
            return this.toString;
        }

        @Override
        public boolean match(ProcessorDefinition processor) {
            return EndpointHelper.matchPattern(processor.toString(), this.toString);
        }
    }

    private static final class MatchById
    implements MatchBy {
        private final String id;

        private MatchById(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean match(ProcessorDefinition processor) {
            return EndpointHelper.matchPattern(processor.getId(), this.id);
        }
    }

    private static interface MatchBy {
        public String getId();

        public boolean match(ProcessorDefinition var1);
    }
}

