/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.util.IOHelper;

public class FileInputStreamCache
extends InputStream
implements StreamCache,
Closeable {
    private InputStream stream;
    private File file;

    public FileInputStreamCache(File file) throws FileNotFoundException {
        this.file = file;
        this.stream = new FileInputStream(file);
    }

    @Override
    public void close() {
        if (this.isSteamOpened()) {
            IOHelper.close(this.getInputStream());
        }
    }

    @Override
    public void reset() {
        try {
            this.close();
            this.stream = new FileInputStream(this.file);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Cannot reset stream from file " + this.file, e);
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        IOHelper.copy(this.getInputStream(), os);
    }

    @Override
    public int available() throws IOException {
        return this.getInputStream().available();
    }

    @Override
    public int read() throws IOException {
        return this.getInputStream().read();
    }

    protected InputStream getInputStream() {
        return this.stream;
    }

    private boolean isSteamOpened() {
        if (this.stream != null && this.stream instanceof FileInputStream) {
            return ((FileInputStream)this.stream).getChannel().isOpen();
        }
        return this.stream != null;
    }
}

