/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.ExpressionAdapter;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.spi.RouteContext;

@XmlRootElement(name="interceptFrom")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InterceptFromDefinition
extends InterceptDefinition {
    @XmlAttribute
    protected String uri;

    public InterceptFromDefinition() {
    }

    public InterceptFromDefinition(String uri) {
        this.uri = uri;
    }

    @Override
    public String toString() {
        return "InterceptFrom[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "interceptFrom";
    }

    @Override
    public String getLabel() {
        return "interceptFrom";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        SetHeaderDefinition headerDefinition = new SetHeaderDefinition("CamelInterceptedEndpoint", new ExpressionAdapter(){

            public Object evaluate(Exchange exchange, Class type) {
                if (exchange.getFromEndpoint() != null) {
                    return exchange.getFromEndpoint().getEndpointUri();
                }
                return null;
            }

            public String toString() {
                return "";
            }
        });
        this.getOutputs().add(0, headerDefinition);
        return this.createChildProcessor(routeContext, true);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

