/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="xstream")
@XmlAccessorType(value=XmlAccessType.NONE)
public class XStreamDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String encoding;
    @XmlAttribute
    private String driver = "xml";
    @XmlAttribute
    private String driverRef;
    @XmlJavaTypeAdapter(value=ConvertersAdapter.class)
    @XmlElement(name="converters")
    private List<String> converters;
    @XmlJavaTypeAdapter(value=AliasAdapter.class)
    @XmlElement(name="aliases")
    private Map<String, String> aliases;
    @XmlJavaTypeAdapter(value=OmitFieldsAdapter.class)
    @XmlElement(name="omitFields")
    private Map<String, String[]> omitFields;
    @XmlJavaTypeAdapter(value=ImplicitCollectionsAdapter.class)
    @XmlElement(name="implicitCollections")
    private Map<String, String[]> implicitCollections;

    public XStreamDataFormat() {
        super("xstream");
    }

    public XStreamDataFormat(String encoding) {
        this();
        this.setEncoding(encoding);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDriverRef() {
        return this.driverRef;
    }

    public void setDriverRef(String driverRef) {
        this.driverRef = driverRef;
    }

    public List<String> getConverters() {
        return this.converters;
    }

    public void setConverters(List<String> converters) {
        this.converters = converters;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public Map<String, String[]> getOmitFields() {
        return this.omitFields;
    }

    public void setOmitFields(Map<String, String[]> omitFields) {
        this.omitFields = omitFields;
    }

    public Map<String, String[]> getImplicitCollections() {
        return this.implicitCollections;
    }

    public void setImplicitCollections(Map<String, String[]> implicitCollections) {
        this.implicitCollections = implicitCollections;
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        if ("json".equals(this.driver)) {
            this.setProperty(this, "dataFormatName", "json-xstream");
        }
        DataFormat answer = super.createDataFormat(routeContext);
        if (ObjectHelper.isNotEmpty(this.driverRef)) {
            this.setProperty(answer, "xstreamDriver", CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.driverRef));
        }
        return answer;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat) {
        if (this.encoding != null) {
            this.setProperty(dataFormat, "encoding", this.encoding);
        }
        if (this.converters != null) {
            this.setProperty(dataFormat, "converters", this.converters);
        }
        if (this.aliases != null) {
            this.setProperty(dataFormat, "aliases", this.aliases);
        }
        if (this.omitFields != null) {
            this.setProperty(dataFormat, "omitFields", this.omitFields);
        }
        if (this.implicitCollections != null) {
            this.setProperty(dataFormat, "implicitCollections", this.implicitCollections);
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class OmitFieldEntry {
        @XmlAttribute(name="class")
        private String clsName;
        @XmlElement(name="field")
        private String[] fields;

        public OmitFieldEntry() {
        }

        public OmitFieldEntry(String clsName, String[] fields) {
            this.clsName = clsName;
            this.fields = fields;
        }

        public String getClsName() {
            return this.clsName;
        }

        public void setClsName(String clsName) {
            this.clsName = clsName;
        }

        public String[] getFields() {
            return this.fields;
        }

        public void setFields(String[] fields) {
            this.fields = fields;
        }

        public String toString() {
            return "OmitField[" + this.clsName + ", fields=" + Arrays.asList(this.fields) + "]";
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class OmitFieldList {
        @XmlElement(name="omitField")
        private List<OmitFieldEntry> list = new ArrayList<OmitFieldEntry>();

        public List<OmitFieldEntry> getList() {
            return this.list;
        }

        public void setList(List<OmitFieldEntry> list) {
            this.list = list;
        }
    }

    @XmlTransient
    public static class OmitFieldsAdapter
    extends XmlAdapter<OmitFieldList, Map<String, String[]>> {
        public OmitFieldList marshal(Map<String, String[]> v) throws Exception {
            ArrayList<OmitFieldEntry> list = new ArrayList<OmitFieldEntry>();
            for (Map.Entry<String, String[]> e : v.entrySet()) {
                OmitFieldEntry entry = new OmitFieldEntry(e.getKey(), e.getValue());
                list.add(entry);
            }
            OmitFieldList collectionList = new OmitFieldList();
            collectionList.setList(list);
            return collectionList;
        }

        public Map<String, String[]> unmarshal(OmitFieldList v) throws Exception {
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            for (OmitFieldEntry entry : v.getList()) {
                map.put(entry.getClsName(), entry.getFields());
            }
            return map;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class AliasEntry {
        @XmlAttribute
        private String name;
        @XmlAttribute(name="class")
        private String clsName;

        public AliasEntry() {
        }

        public AliasEntry(String key, String clsName) {
            this.name = key;
            this.clsName = clsName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getClsName() {
            return this.clsName;
        }

        public void setClsName(String clsName) {
            this.clsName = clsName;
        }

        public String toString() {
            return "Alias[name=" + this.name + ", class=" + this.clsName + "]";
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class AliasList {
        @XmlElement(name="alias")
        private List<AliasEntry> list = new ArrayList<AliasEntry>();

        public List<AliasEntry> getList() {
            return this.list;
        }

        public void setList(List<AliasEntry> list) {
            this.list = list;
        }
    }

    @XmlTransient
    public static class AliasAdapter
    extends XmlAdapter<AliasList, Map<String, String>> {
        public AliasList marshal(Map<String, String> value) throws Exception {
            if (value == null || value.isEmpty()) {
                return new AliasList();
            }
            ArrayList<AliasEntry> ret = new ArrayList<AliasEntry>(value.size());
            for (Map.Entry<String, String> entry : value.entrySet()) {
                ret.add(new AliasEntry(entry.getKey(), entry.getValue()));
            }
            AliasList jaxbMap = new AliasList();
            jaxbMap.setList(ret);
            return jaxbMap;
        }

        public Map<String, String> unmarshal(AliasList value) throws Exception {
            HashMap<String, String> answer = new HashMap<String, String>();
            for (AliasEntry alias : value.getList()) {
                answer.put(alias.getName(), alias.getClsName());
            }
            return answer;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class ImplicitCollectionEntry {
        @XmlAttribute(name="name")
        private String clsName;
        @XmlElement(name="field")
        private String[] fields;

        public ImplicitCollectionEntry() {
        }

        public ImplicitCollectionEntry(String clsName, String[] fields) {
            this.clsName = clsName;
            this.fields = fields;
        }

        public String getClsName() {
            return this.clsName;
        }

        public void setClsName(String clsName) {
            this.clsName = clsName;
        }

        public String[] getFields() {
            return this.fields;
        }

        public void setFields(String[] fields) {
            this.fields = fields;
        }

        public String toString() {
            return "Alias[ImplicitCollection=" + this.clsName + ", fields=" + Arrays.asList(this.fields) + "]";
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class ImplicitCollectionList {
        @XmlElement(name="class")
        private List<ImplicitCollectionEntry> list = new ArrayList<ImplicitCollectionEntry>();

        public List<ImplicitCollectionEntry> getList() {
            return this.list;
        }

        public void setList(List<ImplicitCollectionEntry> list) {
            this.list = list;
        }
    }

    @XmlTransient
    public static class ImplicitCollectionsAdapter
    extends XmlAdapter<ImplicitCollectionList, Map<String, String[]>> {
        public ImplicitCollectionList marshal(Map<String, String[]> v) throws Exception {
            ArrayList<ImplicitCollectionEntry> list = new ArrayList<ImplicitCollectionEntry>();
            for (Map.Entry<String, String[]> e : v.entrySet()) {
                ImplicitCollectionEntry entry = new ImplicitCollectionEntry(e.getKey(), e.getValue());
                list.add(entry);
            }
            ImplicitCollectionList collectionList = new ImplicitCollectionList();
            collectionList.setList(list);
            return collectionList;
        }

        public Map<String, String[]> unmarshal(ImplicitCollectionList v) throws Exception {
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            for (ImplicitCollectionEntry entry : v.getList()) {
                map.put(entry.getClsName(), entry.getFields());
            }
            return map;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class ConverterEntry {
        @XmlAttribute(name="class")
        private String clsName;

        public String getClsName() {
            return this.clsName;
        }

        public void setClsName(String clsName) {
            this.clsName = clsName;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class ConverterList {
        @XmlElement(name="converter")
        private List<ConverterEntry> list = new ArrayList<ConverterEntry>();

        public List<ConverterEntry> getList() {
            return this.list;
        }

        public void setList(List<ConverterEntry> list) {
            this.list = list;
        }
    }

    @XmlTransient
    public static class ConvertersAdapter
    extends XmlAdapter<ConverterList, List<String>> {
        public ConverterList marshal(List<String> v) throws Exception {
            ArrayList<ConverterEntry> list = new ArrayList<ConverterEntry>();
            for (String str : v) {
                ConverterEntry entry = new ConverterEntry();
                entry.setClsName(str);
                list.add(entry);
            }
            ConverterList converterList = new ConverterList();
            converterList.setList(list);
            return converterList;
        }

        public List<String> unmarshal(ConverterList v) throws Exception {
            ArrayList<String> list = new ArrayList<String>();
            for (ConverterEntry entry : v.getList()) {
                list.add(entry.getClsName());
            }
            return list;
        }
    }
}

