/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.Traceable;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class UnmarshalProcessor
extends ServiceSupport
implements Processor,
Traceable,
CamelContextAware {
    private CamelContext camelContext;
    private final DataFormat dataFormat;

    public UnmarshalProcessor(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        ObjectHelper.notNull(this.dataFormat, "dataFormat");
        InputStream stream = ExchangeHelper.getMandatoryInBody(exchange, InputStream.class);
        try {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            Object result = this.dataFormat.unmarshal(exchange, stream);
            out.setBody(result);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public String toString() {
        return "Unmarshal[" + this.dataFormat + "]";
    }

    @Override
    public String getTraceLabel() {
        return "unmarshal[" + this.dataFormat + "]";
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.dataFormat instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.dataFormat)).setCamelContext(this.camelContext);
        }
        ServiceHelper.startService(this.dataFormat);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.dataFormat);
    }
}

