/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.ra.MessageActivationSpec;
import org.apache.activemq.ra.MessageResourceAdapter;
import org.apache.activemq.selector.SelectorParser;

public class ActiveMQActivationSpec
implements MessageActivationSpec,
Serializable {
    public static final String AUTO_ACKNOWLEDGE_MODE = "Auto-acknowledge";
    public static final String DUPS_OK_ACKNOWLEDGE_MODE = "Dups-ok-acknowledge";
    public static final String DURABLE_SUBSCRIPTION = "Durable";
    public static final String NON_DURABLE_SUBSCRIPTION = "NonDurable";
    public static final int INVALID_ACKNOWLEDGE_MODE = -1;
    private static final long serialVersionUID = -7153087544100459975L;
    private transient MessageResourceAdapter resourceAdapter;
    private String destinationType;
    private String messageSelector;
    private String destination;
    private String acknowledgeMode = "Auto-acknowledge";
    private String userName;
    private String password;
    private String clientId;
    private String subscriptionName;
    private String subscriptionDurability = "NonDurable";
    private String noLocal = "false";
    private String useRAManagedTransaction = "false";
    private String maxSessions = "10";
    private String maxMessagesPerSessions = "10";
    private String enableBatch = "false";
    private String maxMessagesPerBatch = "10";
    private RedeliveryPolicy redeliveryPolicy;

    public void validate() throws InvalidPropertyException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<PropertyDescriptor> propsNotSet = new ArrayList<PropertyDescriptor>();
        try {
            if (!this.isValidDestination(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("destination", ActiveMQActivationSpec.class));
            }
            if (!this.isValidDestinationType(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("destinationType", ActiveMQActivationSpec.class));
            }
            if (!this.isValidAcknowledgeMode(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("acknowledgeMode", ActiveMQActivationSpec.class));
            }
            if (!this.isValidSubscriptionDurability(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("subscriptionDurability", ActiveMQActivationSpec.class));
            }
            if (!this.isValidClientId(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("clientId", ActiveMQActivationSpec.class));
            }
            if (!this.isValidSubscriptionName(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("subscriptionName", ActiveMQActivationSpec.class));
            }
            if (!this.isValidMaxMessagesPerSessions(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("maxMessagesPerSessions", ActiveMQActivationSpec.class));
            }
            if (!this.isValidMaxSessions(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("maxSessions", ActiveMQActivationSpec.class));
            }
            if (!this.isValidMessageSelector(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("messageSelector", ActiveMQActivationSpec.class));
            }
            if (!this.isValidNoLocal(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("noLocal", ActiveMQActivationSpec.class));
            }
            if (!this.isValidUseRAManagedTransaction(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("useRAManagedTransaction", ActiveMQActivationSpec.class));
            }
            if (!this.isValidEnableBatch(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("enableBatch", ActiveMQActivationSpec.class));
            }
            if (!this.isValidMaxMessagesPerBatch(errorMessages)) {
                propsNotSet.add(new PropertyDescriptor("maxMessagesPerBatch", ActiveMQActivationSpec.class));
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        if (propsNotSet.size() > 0) {
            StringBuffer b = new StringBuffer();
            b.append("Invalid settings:");
            Iterator iter = errorMessages.iterator();
            while (iter.hasNext()) {
                b.append(" ");
                b.append((String)iter.next());
            }
            InvalidPropertyException e = new InvalidPropertyException(b.toString());
            PropertyDescriptor[] descriptors = propsNotSet.toArray(new PropertyDescriptor[propsNotSet.size()]);
            e.setInvalidPropertyDescriptors(descriptors);
            throw e;
        }
    }

    @Override
    public boolean isValidUseRAManagedTransaction(List<String> errorMessages) {
        try {
            new Boolean(this.useRAManagedTransaction);
            return true;
        }
        catch (Throwable throwable) {
            errorMessages.add("useRAManagedTransaction must be set to: true or false.");
            return false;
        }
    }

    @Override
    public boolean isValidNoLocal(List<String> errorMessages) {
        try {
            new Boolean(this.noLocal);
            return true;
        }
        catch (Throwable throwable) {
            errorMessages.add("noLocal must be set to: true or false.");
            return false;
        }
    }

    @Override
    public boolean isValidMessageSelector(List<String> errorMessages) {
        try {
            if (!this.isEmpty(this.messageSelector)) {
                SelectorParser.parse((String)this.messageSelector);
            }
            return true;
        }
        catch (Throwable e) {
            errorMessages.add("messageSelector not set to valid message selector: " + e);
            return false;
        }
    }

    @Override
    public boolean isValidMaxSessions(List<String> errorMessages) {
        try {
            if (Integer.parseInt(this.maxSessions) > 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        errorMessages.add("maxSessions must be set to number > 0");
        return false;
    }

    @Override
    public boolean isValidMaxMessagesPerSessions(List<String> errorMessages) {
        try {
            if (Integer.parseInt(this.maxMessagesPerSessions) > 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        errorMessages.add("maxMessagesPerSessions must be set to number > 0");
        return false;
    }

    @Override
    public boolean isValidMaxMessagesPerBatch(List<String> errorMessages) {
        try {
            if (Integer.parseInt(this.maxMessagesPerBatch) > 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        errorMessages.add("maxMessagesPerBatch must be set to number > 0");
        return false;
    }

    @Override
    public boolean isValidEnableBatch(List<String> errorMessages) {
        try {
            new Boolean(this.enableBatch);
            return true;
        }
        catch (Throwable throwable) {
            errorMessages.add("enableBatch must be set to: true or false");
            return false;
        }
    }

    @Override
    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
        if (this.resourceAdapter != null) {
            throw new ResourceException("ResourceAdapter already set");
        }
        if (!(resourceAdapter instanceof MessageResourceAdapter)) {
            throw new ResourceException("ResourceAdapter is not of type: " + MessageResourceAdapter.class.getName());
        }
        this.resourceAdapter = (MessageResourceAdapter)resourceAdapter;
    }

    @Override
    public String getDestinationType() {
        if (!this.isEmpty(this.destinationType)) {
            return this.destinationType;
        }
        return null;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    @Override
    public String getPassword() {
        if (!this.isEmpty(this.password)) {
            return this.password;
        }
        return null;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getUserName() {
        if (!this.isEmpty(this.userName)) {
            return this.userName;
        }
        return null;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getMessageSelector() {
        if (!this.isEmpty(this.messageSelector)) {
            return this.messageSelector;
        }
        return null;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    @Override
    public String getNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(String noLocal) {
        if (noLocal != null) {
            this.noLocal = noLocal;
        }
    }

    @Override
    public String getAcknowledgeMode() {
        if (!this.isEmpty(this.acknowledgeMode)) {
            return this.acknowledgeMode;
        }
        return null;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    @Override
    public String getClientId() {
        if (!this.isEmpty(this.clientId)) {
            return this.clientId;
        }
        return null;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getDestination() {
        if (!this.isEmpty(this.destination)) {
            return this.destination;
        }
        return null;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    @Override
    public String getSubscriptionDurability() {
        if (!this.isEmpty(this.subscriptionDurability)) {
            return this.subscriptionDurability;
        }
        return null;
    }

    public void setSubscriptionDurability(String subscriptionDurability) {
        this.subscriptionDurability = subscriptionDurability;
    }

    @Override
    public String getSubscriptionName() {
        if (!this.isEmpty(this.subscriptionName)) {
            return this.subscriptionName;
        }
        return null;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    @Override
    public boolean isValidSubscriptionName(List<String> errorMessages) {
        if (!this.isDurableSubscription() || this.subscriptionName != null && this.subscriptionName.trim().length() > 0) {
            return true;
        }
        errorMessages.add("subscriptionName must be set since durable subscription was requested.");
        return false;
    }

    @Override
    public boolean isValidClientId(List<String> errorMessages) {
        if (!this.isDurableSubscription() || this.clientId != null && this.clientId.trim().length() > 0) {
            return true;
        }
        errorMessages.add("clientId must be set since durable subscription was requested.");
        return false;
    }

    @Override
    public boolean isDurableSubscription() {
        return DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability);
    }

    @Override
    public boolean isValidSubscriptionDurability(List<String> errorMessages) {
        if (DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability) && this.getDestinationType() != null && !Topic.class.getName().equals(this.getDestinationType())) {
            errorMessages.add("subscriptionDurability cannot be set to: Durable when destinationType is set to " + Queue.class.getName() + " as it is only valid when destinationType is set to " + Topic.class.getName() + ".");
            return false;
        }
        if (NON_DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability) || DURABLE_SUBSCRIPTION.equals(this.subscriptionDurability)) {
            return true;
        }
        errorMessages.add("subscriptionDurability must be set to: NonDurable or Durable.");
        return false;
    }

    @Override
    public boolean isValidAcknowledgeMode(List<String> errorMessages) {
        if (AUTO_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode) || DUPS_OK_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode)) {
            return true;
        }
        errorMessages.add("acknowledgeMode must be set to: Auto-acknowledge or Dups-ok-acknowledge.");
        return false;
    }

    @Override
    public boolean isValidDestinationType(List<String> errorMessages) {
        if (Queue.class.getName().equals(this.destinationType) || Topic.class.getName().equals(this.destinationType)) {
            return true;
        }
        errorMessages.add("destinationType must be set to: " + Queue.class.getName() + " or " + Topic.class.getName() + ".");
        return false;
    }

    @Override
    public boolean isValidDestination(List<String> errorMessages) {
        if (this.destination != null && !this.destination.equals("")) {
            return true;
        }
        errorMessages.add("destination is a required field and must be set to the destination name.");
        return false;
    }

    @Override
    public boolean isEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    public String toString() {
        return "ActiveMQActivationSpec{acknowledgeMode='" + this.acknowledgeMode + "'" + ", destinationType='" + this.destinationType + "'" + ", messageSelector='" + this.messageSelector + "'" + ", destination='" + this.destination + "'" + ", clientId='" + this.clientId + "'" + ", subscriptionName='" + this.subscriptionName + "'" + ", subscriptionDurability='" + this.subscriptionDurability + "'" + "}";
    }

    @Override
    public int getAcknowledgeModeForSession() {
        if (AUTO_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode)) {
            return 1;
        }
        if (DUPS_OK_ACKNOWLEDGE_MODE.equals(this.acknowledgeMode)) {
            return 3;
        }
        return -1;
    }

    public void setActiveMQDestination(ActiveMQDestination destination) {
        this.setDestination(destination.getPhysicalName());
        if (destination instanceof Queue) {
            this.setDestinationType(Queue.class.getName());
        } else {
            this.setDestinationType(Topic.class.getName());
        }
    }

    public ActiveMQDestination createDestination() {
        if (this.isEmpty(this.destinationType) || this.isEmpty(this.destination)) {
            return null;
        }
        ActiveMQQueue dest = null;
        if (Queue.class.getName().equals(this.destinationType)) {
            dest = new ActiveMQQueue(this.destination);
        } else if (Topic.class.getName().equals(this.destinationType)) {
            dest = new ActiveMQTopic(this.destination);
        } else assert (false) : "Execution should never reach here";
        return dest;
    }

    @Override
    public String getMaxMessagesPerSessions() {
        return this.maxMessagesPerSessions;
    }

    public void setMaxMessagesPerSessions(String maxMessagesPerSessions) {
        if (maxMessagesPerSessions != null) {
            this.maxMessagesPerSessions = maxMessagesPerSessions;
        }
    }

    @Override
    public String getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(String maxSessions) {
        if (maxSessions != null) {
            this.maxSessions = maxSessions;
        }
    }

    @Override
    public String getUseRAManagedTransaction() {
        return this.useRAManagedTransaction;
    }

    public void setUseRAManagedTransaction(String useRAManagedTransaction) {
        if (useRAManagedTransaction != null) {
            this.useRAManagedTransaction = useRAManagedTransaction;
        }
    }

    @Override
    public int getMaxMessagesPerSessionsIntValue() {
        return Integer.parseInt(this.maxMessagesPerSessions);
    }

    @Override
    public int getMaxSessionsIntValue() {
        return Integer.parseInt(this.maxSessions);
    }

    @Override
    public boolean isUseRAManagedTransactionEnabled() {
        return Boolean.valueOf(this.useRAManagedTransaction);
    }

    @Override
    public boolean getNoLocalBooleanValue() {
        return Boolean.valueOf(this.noLocal);
    }

    @Override
    public String getEnableBatch() {
        return this.enableBatch;
    }

    public void setEnableBatch(String enableBatch) {
        if (enableBatch != null) {
            this.enableBatch = enableBatch;
        }
    }

    @Override
    public boolean getEnableBatchBooleanValue() {
        return Boolean.valueOf(this.enableBatch);
    }

    @Override
    public int getMaxMessagesPerBatchIntValue() {
        return Integer.parseInt(this.maxMessagesPerBatch);
    }

    @Override
    public String getMaxMessagesPerBatch() {
        return this.maxMessagesPerBatch;
    }

    public void setMaxMessagesPerBatch(String maxMessagesPerBatch) {
        if (maxMessagesPerBatch != null) {
            this.maxMessagesPerBatch = maxMessagesPerBatch;
        }
    }

    @Override
    public double getBackOffMultiplier() {
        if (this.redeliveryPolicy == null) {
            return 0.0;
        }
        return this.redeliveryPolicy.getBackOffMultiplier();
    }

    @Override
    public long getInitialRedeliveryDelay() {
        if (this.redeliveryPolicy == null) {
            return 0L;
        }
        return this.redeliveryPolicy.getInitialRedeliveryDelay();
    }

    @Override
    public int getMaximumRedeliveries() {
        if (this.redeliveryPolicy == null) {
            return 0;
        }
        return this.redeliveryPolicy.getMaximumRedeliveries();
    }

    @Override
    public boolean isUseExponentialBackOff() {
        if (this.redeliveryPolicy == null) {
            return false;
        }
        return this.redeliveryPolicy.isUseExponentialBackOff();
    }

    public void setBackOffMultiplier(double backOffMultiplier) {
        this.lazyCreateRedeliveryPolicy().setBackOffMultiplier(backOffMultiplier);
    }

    @Override
    public long getMaximumRedeliveryDelay() {
        if (this.redeliveryPolicy == null) {
            return 0L;
        }
        return this.redeliveryPolicy.getMaximumRedeliveryDelay();
    }

    public void setMaximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.lazyCreateRedeliveryPolicy().setMaximumRedeliveryDelay(maximumRedeliveryDelay);
    }

    public void setInitialRedeliveryDelay(long initialRedeliveryDelay) {
        this.lazyCreateRedeliveryPolicy().setInitialRedeliveryDelay(initialRedeliveryDelay);
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.lazyCreateRedeliveryPolicy().setMaximumRedeliveries(maximumRedeliveries);
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.lazyCreateRedeliveryPolicy().setUseExponentialBackOff(useExponentialBackOff);
    }

    @Override
    public RedeliveryPolicy redeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    @Override
    public RedeliveryPolicy lazyCreateRedeliveryPolicy() {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = new RedeliveryPolicy();
        }
        return this.redeliveryPolicy;
    }
}

