/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.util.CastUtils;

public class SortProcessor
implements Processor {
    private final Expression expression;
    private final Comparator<Object> comparator;

    public SortProcessor(Expression expression, Comparator<Object> comparator) {
        this.expression = expression;
        this.comparator = comparator;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        List list = CastUtils.cast(this.expression.evaluate(exchange, List.class));
        Collections.sort(list, this.comparator);
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(in);
            out.setBody(list);
        } else {
            in.setBody(list);
        }
    }

    public String toString() {
        return "Sort[" + this.expression + "]";
    }
}

